/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SchemaValidationException;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.internal.json.Diagnostic;
import com.ibm.vis.internal.json.SpecValidator;
import com.ibm.vis.template.JSONSerialization;
import com.ibm.vis.template.Parameter;
import com.ibm.vis.template.ParameterResolveOrderComparator;
import com.ibm.vis.template.internal.ParameterValue;
import com.ibm.vis.template.internal.TemplateFactory;
import com.ibm.vis.template.parser.JSONPathParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

@OnDemandLoad(value="com/ibm/vis/layers/templateLayer")
public class Template {
    private JSONObject template = null;
    private HashMap<String, Parameter> parameterMap = null;
    private ArrayList<Parameter> parameterList = null;
    private boolean validationEnabled = true;

    public static Template createTemplateFromString(String string) {
        return new Template(string);
    }

    public static Template createTemplateFromJSON(JSONObject jSONObject) {
        Template template = new Template(null);
        template.constructTemplate(null, jSONObject);
        return template;
    }

    public Template(String string) {
        this.constructTemplate(string, null);
    }

    void constructTemplate(String string, JSONObject jSONObject) {
        JSONArray jSONArray;
        if (string == null && jSONObject == null) {
            return;
        }
        if (jSONObject != null) {
            this.template = jSONObject;
        } else {
            try {
                this.template = BasicFactory.parse(string);
            }
            catch (IOException iOException) {
                throw new SpecException(null, ErrorCode.SPEC_PARSE_FAIL, string);
            }
        }
        JSONArray jSONArray2 = (JSONArray)BasicFactory.getItem(this.template, "parameters");
        if (jSONArray2 != null) {
            int n = BasicFactory.getJSONArraySize(jSONArray2);
            this.parameterMap = new HashMap(n);
            this.parameterList = new ArrayList();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = (JSONObject)BasicFactory.getArrayItem(jSONArray2, i);
                Parameter object = TemplateFactory.createParameter(jSONObject2);
                this.parameterMap.put(object.getId(), object);
                object.setIndex(i);
                this.parameterList.add(object);
            }
        }
        if ((jSONArray = (JSONArray)BasicFactory.getItem(this.template, "parameterValues")) != null) {
            Collection<ParameterValue> collection = TemplateFactory.createParameterValues(jSONArray);
            for (ParameterValue parameterValue : collection) {
                Parameter parameter = this.getParameter(parameterValue.getId());
                if (parameter == null) continue;
                parameter.setValue(parameterValue.getValue());
            }
        }
        BasicFactory.remove(this.template, "parameters");
        BasicFactory.remove(this.template, "parameterValues");
    }

    public boolean canBeResolved() {
        if (this.parameterMap != null) {
            for (Parameter parameter : this.parameterMap.values()) {
                if (!parameter.isRequired() || parameter.hasValue()) continue;
                return false;
            }
        }
        return true;
    }

    public String resolve() {
        return JSONSerialization.forVizJSONDisplay(60).serialize(this.resolveToJSON());
    }

    public JSONObject resolveToJSON() {
        Object object;
        if (!this.canBeResolved()) {
            throw new EngineException(null, ErrorCode.TEMPLATE_CANNOT_BE_RESOLVED, null);
        }
        JSONObject jSONObject = (JSONObject)BasicFactory.deepClone(this.template);
        JSONPathParser jSONPathParser = new JSONPathParser(jSONObject);
        if (this.parameterMap != null) {
            BasicFactory.sortList(this.parameterList, new ParameterResolveOrderComparator());
            object = this.parameterList.iterator();
            while (object.hasNext()) {
                Parameter parameter = (Parameter)object.next();
                parameter.resolve(jSONPathParser, this.parameterMap);
            }
        }
        if (!((Diagnostic)(object = this.validate(jSONObject))).isOK()) {
            throw new SchemaValidationException("Validation failed", ErrorCode.SPEC_PARSE_FAIL, null, (Diagnostic)object);
        }
        return jSONObject;
    }

    public boolean hasParameters() {
        if (this.parameterMap == null) {
            return false;
        }
        return this.parameterMap.size() > 0;
    }

    public Collection<Parameter> getParameters() {
        if (this.parameterMap != null) {
            return this.parameterMap.values();
        }
        return null;
    }

    public String[] getParameterIds() {
        if (this.parameterMap != null && this.parameterMap.size() > 0) {
            Set<String> set = this.parameterMap.keySet();
            return set.toArray(new String[set.size()]);
        }
        return null;
    }

    public Parameter getParameter(String string) {
        if (this.parameterMap != null) {
            return this.parameterMap.get(string);
        }
        return null;
    }

    public void setParameterValue(String string, Object object) {
        Parameter parameter = this.parameterMap.get(string);
        if (parameter == null) {
            throw new EngineException(null, ErrorCode.PARAMETER_NOT_FOUND, string);
        }
        parameter.setValue(object);
    }

    protected Diagnostic validate(JSONObject jSONObject) {
        return SpecValidator.validate(jSONObject);
    }

    protected final JSONObject getTempl() {
        return this.template;
    }
}

