/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.template.BooleanParameter;
import com.ibm.vis.template.ColorPaletteParameter;
import com.ibm.vis.template.ColorParameter;
import com.ibm.vis.template.DoubleParameter;
import com.ibm.vis.template.FontParameter;
import com.ibm.vis.template.LengthParameter;
import com.ibm.vis.template.LongIntegerParameter;
import com.ibm.vis.template.Parameter;
import com.ibm.vis.template.SizeParameter;
import com.ibm.vis.template.StringParameter;
import com.ibm.vis.template.StyleByPaletteParameter;
import com.ibm.vis.template.internal.ParameterValue;
import com.ibm.vis.template.internal.ResolutionCase;
import com.ibm.vis.template.internal.ResolutionItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TemplateFactory {
    private static final String strId = "id";
    private static final String strLabel = "label";
    private static final String strDescription = "description";
    private static final String strRequired = "required";
    private static final String strType = "type";
    private static final String strResolveOrder = "resolveOrder";
    private static final String strString = "string";
    private static final String strBoolean = "boolean";
    private static final String strInteger = "integer";
    private static final String strDouble = "double";
    private static final String strLength = "length";
    private static final String strColor = "color";
    private static final String strSize = "size";
    private static final String strFont = "font";
    private static final String strColorPalette = "colorPalette";
    private static final String strStyleByPalette = "styleByPalette";
    private static final String strDefaultValue = "defaultValue";
    private static final String strResolution = "resolution";
    private static final String strResolutionCases = "resolutionCases";
    private static final String strResolutionCase = "resolutionCase";
    private static final String strValue = "value";
    private static final String strMethod = "method";
    private static final String strTarget = "target";
    private static final String strSourceParameter = "sourceParameter";
    private static final String strSourceValue = "sourceValue";
    private static final String strSourcePath = "sourcePath";

    public static Parameter createParameter(JSONObject jSONObject) {
        String string = (String)BasicFactory.getItem(jSONObject, strId);
        String string2 = (String)BasicFactory.getItem(jSONObject, strLabel);
        String string3 = (String)BasicFactory.getItem(jSONObject, strDescription);
        Boolean bl = (Boolean)BasicFactory.getItem(jSONObject, strRequired);
        Integer n = (Long)BasicFactory.getItem(jSONObject, strResolveOrder) == null ? null : Integer.valueOf(((Long)BasicFactory.getItem(jSONObject, strResolveOrder)).intValue());
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        String string4 = (String)BasicFactory.getItem(jSONObject, strType);
        Object object = BasicFactory.getItem(jSONObject, strDefaultValue);
        List<ResolutionItem> list = TemplateFactory.createResolutionItemList((JSONArray)BasicFactory.getItem(jSONObject, strResolution));
        List<ResolutionCase> list2 = TemplateFactory.createResolutionCaseList((JSONArray)BasicFactory.getItem(jSONObject, strResolutionCases), string4);
        Parameter parameter = null;
        if (string4.equals(strString)) {
            parameter = new StringParameter(string, string2, string3, bl2, list, list2, n);
        } else if (string4.equals(strBoolean)) {
            parameter = new BooleanParameter(string, string2, string3, bl2, list, list2, n);
        } else if (string4.equals(strInteger)) {
            parameter = new LongIntegerParameter(string, string2, string3, bl2, list, list2, n);
        } else if (string4.equals(strDouble)) {
            parameter = new DoubleParameter(string, string2, string3, bl2, list, list2, n);
        } else if (string4.equals(strLength)) {
            parameter = new LengthParameter(string, string2, string3, bl2, list, list2, n);
        } else if (string4.equals(strColor)) {
            parameter = new ColorParameter(string, string2, string3, bl2, list, list2, n);
        } else if (string4.equals(strSize)) {
            parameter = new SizeParameter(string, string2, string3, bl2, list, list2, n);
        } else if (string4.equals(strFont)) {
            parameter = new FontParameter(string, string2, string3, bl2, list, list2, n);
        } else if (string4.equals(strColorPalette)) {
            parameter = new ColorPaletteParameter(string, string2, string3, bl2, list, list2, n);
        } else if (string4.equals(strStyleByPalette)) {
            parameter = new StyleByPaletteParameter(string, string2, string3, bl2, list, list2, n);
        }
        if (object != null) {
            TemplateFactory.setDefaultValue(string, parameter, object);
        }
        return parameter;
    }

    private static final void setDefaultValue(String string, Parameter parameter, Object object) {
        try {
            parameter.setValue(object);
        }
        catch (EngineException engineException) {
            throw new SpecException(null, ErrorCode.PARAMETER_DEFAULT_VALUE_TYPE_MISMATCH, string);
        }
    }

    private static List<ResolutionItem> createResolutionItemList(JSONArray jSONArray) {
        ArrayList<ResolutionItem> arrayList = null;
        if (jSONArray != null) {
            int n = BasicFactory.size(jSONArray);
            arrayList = new ArrayList<ResolutionItem>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(TemplateFactory.createResolutionItem((JSONObject)BasicFactory.getArrayItem(jSONArray, i)));
            }
        }
        return arrayList;
    }

    private static List<ResolutionCase> createResolutionCaseList(JSONArray jSONArray, String string) {
        ArrayList<ResolutionCase> arrayList = null;
        if (jSONArray != null) {
            int n = BasicFactory.size(jSONArray);
            arrayList = new ArrayList<ResolutionCase>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(TemplateFactory.createResolutionCase((JSONObject)BasicFactory.getArrayItem(jSONArray, i), string));
            }
        }
        return arrayList;
    }

    public static Collection<ParameterValue> createParameterValues(JSONArray jSONArray) {
        int n = BasicFactory.size(jSONArray);
        ArrayList<ParameterValue> arrayList = new ArrayList<ParameterValue>(n);
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
            String string = (String)BasicFactory.getItem(jSONObject, strId);
            Object object = BasicFactory.getItem(jSONObject, strValue);
            arrayList.add(new ParameterValue(string, object));
        }
        return arrayList;
    }

    public static ResolutionItem createResolutionItem(JSONObject jSONObject) {
        String string = (String)BasicFactory.getItem(jSONObject, strMethod);
        String string2 = (String)BasicFactory.getItem(jSONObject, strTarget);
        String string3 = (String)BasicFactory.getItem(jSONObject, strSourceParameter);
        Object object = BasicFactory.getItem(jSONObject, strSourceValue);
        String string4 = (String)BasicFactory.getItem(jSONObject, strSourcePath);
        return new ResolutionItem(string, string2, string3, object, string4);
    }

    public static ResolutionCase createResolutionCase(JSONObject jSONObject, String string) {
        Object object = BasicFactory.getItem(jSONObject, strResolutionCase);
        TemplateFactory.validateResolutionCase(object, string);
        List<ResolutionItem> list = TemplateFactory.createResolutionItemList((JSONArray)BasicFactory.getItem(jSONObject, strResolution));
        return new ResolutionCase(object, list);
    }

    private static void validateResolutionCase(Object object, String string) throws SpecException {
        boolean bl;
        boolean bl2 = BasicFactory.isBoolean(object);
        boolean bl3 = BasicFactory.isString(object);
        boolean bl4 = BasicFactory.isInteger(object);
        boolean bl5 = bl = object == null;
        if (!(bl2 || bl3 || bl4 || bl)) {
            throw new SpecException(null, ErrorCode.PARAMETER_INVALID_RESOLUTION_CASE, string);
        }
        if (bl2 && !strBoolean.equals(string) || bl3 && !strString.equals(string) || bl4 && !strInteger.equals(string)) {
            throw new SpecException(null, ErrorCode.PARAMETER_RESOLUTION_CASE_MISMATCH, string);
        }
    }
}

