/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template.parser;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.internal.json.JSONTreeNode;
import java.util.ArrayList;
import java.util.Iterator;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class JSONMatcher {
    public static ArrayList<JSONTreeNode> filterNodesByEquals(ArrayList<JSONTreeNode> arrayList, String string, Object object) {
        ArrayList<JSONTreeNode> arrayList2 = new ArrayList<JSONTreeNode>();
        for (JSONTreeNode jSONTreeNode : arrayList) {
            if (!jSONTreeNode.containsValue(string, object)) continue;
            arrayList2.add(jSONTreeNode);
        }
        return arrayList2;
    }

    public static ArrayList<JSONTreeNode> filterNodesByChildExists(ArrayList<JSONTreeNode> arrayList, String string) {
        ArrayList<JSONTreeNode> arrayList2 = new ArrayList<JSONTreeNode>();
        for (JSONTreeNode jSONTreeNode : arrayList) {
            if (!jSONTreeNode.contains(string)) continue;
            arrayList2.add(jSONTreeNode);
        }
        return arrayList2;
    }

    public static ArrayList<JSONTreeNode> findChildren(ArrayList<JSONTreeNode> arrayList) {
        ArrayList<JSONTreeNode> arrayList2 = new ArrayList<JSONTreeNode>();
        for (JSONTreeNode jSONTreeNode : arrayList) {
            arrayList2.addAll(jSONTreeNode.getChildren());
        }
        return arrayList2;
    }

    public static ArrayList<JSONTreeNode> findChildrenInArrays(ArrayList<JSONTreeNode> arrayList) {
        ArrayList<JSONTreeNode> arrayList2 = new ArrayList<JSONTreeNode>();
        for (JSONTreeNode jSONTreeNode : arrayList) {
            if (jSONTreeNode.hasAnonymousChildren()) {
                arrayList2.addAll(jSONTreeNode.getAnonymousChildren());
                continue;
            }
            arrayList2.add(jSONTreeNode);
        }
        return arrayList2;
    }

    public static ArrayList<JSONTreeNode> filterNodesByPredicateIndex(ArrayList<JSONTreeNode> arrayList, int n) {
        JSONTreeNode jSONTreeNode;
        ArrayList<JSONTreeNode> arrayList2 = new ArrayList<JSONTreeNode>();
        if (arrayList.size() == 1 && arrayList.get(0).hasAnonymousChildren()) {
            JSONTreeNode jSONTreeNode2 = arrayList.get(0);
            arrayList2.clear();
            JSONTreeNode jSONTreeNode3 = jSONTreeNode2.getChildByIndex(n);
            if (jSONTreeNode3 != null) {
                arrayList2.add(jSONTreeNode3);
            }
        } else if (arrayList.size() > n && (jSONTreeNode = arrayList.get(n)) != null) {
            arrayList2.add(jSONTreeNode);
        }
        return arrayList2;
    }

    public static ArrayList<JSONTreeNode> findSingleOrMultipleNodesByName(ArrayList<JSONTreeNode> arrayList, String string, boolean bl) {
        ArrayList<JSONTreeNode> arrayList2 = new ArrayList<JSONTreeNode>();
        for (JSONTreeNode jSONTreeNode : arrayList) {
            if (bl) {
                arrayList2.addAll(jSONTreeNode.findNodes(string));
                continue;
            }
            JSONTreeNode jSONTreeNode2 = jSONTreeNode.findNode(string);
            if (jSONTreeNode2 == null) continue;
            arrayList2.add(jSONTreeNode2);
        }
        return arrayList2;
    }

    public static ArrayList<JSONTreeNode> findParents(ArrayList<JSONTreeNode> arrayList) {
        ArrayList<JSONTreeNode> arrayList2 = new ArrayList<JSONTreeNode>();
        for (JSONTreeNode jSONTreeNode : arrayList) {
            JSONTreeNode jSONTreeNode2 = jSONTreeNode.getParent();
            if (jSONTreeNode2 == null) continue;
            JSONTreeNode jSONTreeNode3 = jSONTreeNode2.getParent();
            if (jSONTreeNode3 == null) {
                if (arrayList2.contains(jSONTreeNode2)) continue;
                arrayList2.add(jSONTreeNode2);
                continue;
            }
            if (arrayList2.contains(jSONTreeNode3)) continue;
            arrayList2.add(jSONTreeNode3);
        }
        return arrayList2;
    }

    public static ArrayList<JSONTreeNode> addChild(ArrayList<JSONTreeNode> arrayList, String string) {
        assert (arrayList != null && string != null);
        ArrayList<JSONTreeNode> arrayList2 = new ArrayList<JSONTreeNode>();
        for (JSONTreeNode jSONTreeNode : arrayList) {
            Object object;
            Object object2;
            if (jSONTreeNode.isArray()) {
                object2 = jSONTreeNode.getAnonymousChildren();
                object = ((ArrayList)object2).iterator();
                while (object.hasNext()) {
                    JSONTreeNode jSONTreeNode2 = (JSONTreeNode)object.next();
                    JSONObject jSONObject = BasicFactory.createJSONObject();
                    JSONTreeNode jSONTreeNode3 = new JSONTreeNode(jSONObject, jSONTreeNode2, string);
                    jSONTreeNode2.addChild(jSONTreeNode3);
                    arrayList2.add(jSONTreeNode3);
                }
                continue;
            }
            object2 = BasicFactory.createJSONObject();
            object = new JSONTreeNode(object2, jSONTreeNode, string);
            jSONTreeNode.addChild((JSONTreeNode)object);
            arrayList2.add((JSONTreeNode)object);
        }
        return arrayList2;
    }

    public static ArrayList<JSONTreeNode> addAnonymousChildren(ArrayList<JSONTreeNode> arrayList, int n) {
        assert (arrayList != null && n > -1);
        ArrayList<JSONTreeNode> arrayList2 = new ArrayList<JSONTreeNode>();
        for (JSONTreeNode jSONTreeNode : arrayList) {
            int n2 = jSONTreeNode.getAnonymousChildren().size();
            int n3 = n + 1;
            int n4 = n3 - n2;
            jSONTreeNode.addAnonymousChildren(n4);
            if (jSONTreeNode.getAnonymousChildren().size() <= n) continue;
            arrayList2.add(jSONTreeNode.getAnonymousChildren().get(n));
        }
        return arrayList2;
    }

    public static ArrayList<JSONTreeNode> addJSONArrayObject(ArrayList<JSONTreeNode> arrayList, String string, int n) {
        assert (arrayList != null && n > -1);
        ArrayList<JSONTreeNode> arrayList2 = new ArrayList<JSONTreeNode>();
        for (JSONTreeNode jSONTreeNode : arrayList) {
            Object object;
            if (jSONTreeNode.isArray()) {
                object = jSONTreeNode.getAnonymousChildren();
                Iterator<JSONTreeNode> iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    JSONTreeNode jSONTreeNode2 = iterator.next();
                    JSONTreeNode jSONTreeNode3 = JSONMatcher.createArrayNodeWithEmptyItems(jSONTreeNode, string, n + 1);
                    jSONTreeNode2.addChild(jSONTreeNode3);
                    arrayList2.add(jSONTreeNode3.getAnonymousChildren().get(n));
                }
                continue;
            }
            object = JSONMatcher.createArrayNodeWithEmptyItems(jSONTreeNode, string, n + 1);
            jSONTreeNode.addChild((JSONTreeNode)object);
            arrayList2.add(((JSONTreeNode)object).getAnonymousChildren().get(n));
        }
        return arrayList2;
    }

    private static JSONTreeNode createArrayNodeWithEmptyItems(JSONTreeNode jSONTreeNode, String string, int n) {
        assert (jSONTreeNode != null);
        assert (n > -1);
        JSONArray jSONArray = BasicFactory.createJSONArray();
        JSONTreeNode jSONTreeNode2 = new JSONTreeNode(jSONArray, jSONTreeNode, string);
        jSONTreeNode2.addAnonymousChildren(n);
        return jSONTreeNode2;
    }
}

