/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template.ravetype;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.template.internal.TemplateUtils;
import com.ibm.vis.template.ravetype.AbstractDataType;
import com.ibm.vis.template.ravetype.RaveDataType;
import java.io.IOException;

public class RaveColor
extends AbstractDataType {
    private Object colorValue;

    public void setRGBA(Number number, Number number2, Number number3, Number number4) {
        String string = "";
        ColorUtil.validateRGB(number, number2, number3);
        ColorUtil.validateZeroToOneRange(number4);
        if (number != null) {
            string = "\"r\": " + number;
        }
        if (number2 != null) {
            string = string.equals("") ? "\"g\": " + number2 : string + ", \"g\": " + number2;
        }
        if (number3 != null) {
            string = string.equals("") ? "\"b\": " + number3 : string + ", \"b\": " + number3;
        }
        if (number4 != null) {
            string = string.equals("") ? "\"a\": " + number4 : string + ", \"a\": " + number4;
        }
        if (!string.equals("")) {
            string = "{ " + string + " }";
        }
        try {
            this.colorValue = BasicFactory.parse(string);
        }
        catch (IOException iOException) {
            throw new EngineException("Failed to convert RGB values into a JSONObject", ErrorCode.TEMPLATE_INVALID_ARGUMENT, null);
        }
    }

    public void setHSLA(Number number, Number number2, Number number3, Number number4) throws IOException {
        String string = "";
        ColorUtil.validateHSL(number, number2, number3);
        ColorUtil.validateZeroToOneRange(number4);
        if (number != null) {
            string = "\"h\": " + number;
        }
        if (number2 != null) {
            string = string.equals("") ? "\"s\": " + number2 : string + ", \"s\": " + number2;
        }
        if (number3 != null) {
            string = string.equals("") ? "\"l\": " + number3 : string + ", \"l\": " + number3;
        }
        if (number4 != null) {
            string = string.equals("") ? "\"a\": " + number4 : string + ", \"a\": " + number4;
        }
        if (!string.equals("")) {
            string = "{ " + string + " }";
        }
        this.colorValue = BasicFactory.parse(string);
    }

    public void setDelta(Number number, Number number2, Number number3, Number number4) {
        if (this.colorValue == null) {
            this.colorValue = BasicFactory.createJSONObject();
        } else if (BasicFactory.isString(this.colorValue)) {
            throw new EngineException("Delta values is not supported for String color", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
        if (number != null) {
            BasicFactory.put(this.colorValue, "dValue", number);
        }
        if (number2 != null) {
            BasicFactory.put(this.colorValue, "dSaturation", number2);
        }
        if (number3 != null) {
            BasicFactory.put(this.colorValue, "dLightness", number3);
        }
        if (number4 != null) {
            BasicFactory.put(this.colorValue, "dAlpha", number4);
        }
    }

    public void setColorByName(String string) {
        ColorUtil.validateColorName(string);
        this.colorValue = string;
    }

    public void setColorByHexString(String string) {
        ColorUtil.validateColorHexString(string);
        this.colorValue = string;
    }

    public void setColorByCSSRgbString(String string) {
        ColorUtil.validateColorCSSString(string);
        this.colorValue = string;
    }

    @Override
    public Object getValue() {
        return this.colorValue;
    }

    @Override
    public void setValue(Object object) {
        TemplateUtils.validateForNotNullValue(object, ErrorCode.PARAMETER_INVALID_VALUE, "Color parameter parameter value can not be null");
        if (BasicFactory.isString(object)) {
            ColorUtil.validateColorString(object.toString());
            this.colorValue = object;
        } else if (BasicFactory.isObject(object)) {
            ColorUtil.validateColorObject((JSONObject)object);
            this.colorValue = object;
        } else {
            RaveColor.reportTypeMismatch(object, "RaveColor");
        }
    }

    @Override
    public RaveDataType getType() {
        return RaveDataType.RaveColor;
    }
}

