/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template.ravetype;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.Gradient;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.template.internal.TemplateUtils;
import com.ibm.vis.template.ravetype.AbstractDataType;
import com.ibm.vis.template.ravetype.RaveColorOffset;
import com.ibm.vis.template.ravetype.RaveDataType;
import com.ibm.vis.template.ravetype.RaveLength;
import java.util.ArrayList;
import java.util.List;

public class RaveGradientFill
extends AbstractDataType {
    private static final String KEY_TYPE = "type";
    private static final String KEY_COLORS = "colors";
    private static final String KEY_ANGLE = "angle";
    private static final String KEY_FOCUS = "focus";
    private static final String KEY_FOCUS_X = "x";
    private static final String KEY_FOCUS_Y = "y";
    private static final String KEY_GLOBAL = "global";
    private JSONObject fillValue = null;
    private String gradientType;
    private Object focusX;
    private Object focusY;
    private double angle;
    private boolean isGlobal;

    private JSONObject getFillJSON() {
        if (this.fillValue == null) {
            this.fillValue = BasicFactory.createJSONObject();
        }
        return this.fillValue;
    }

    public static boolean containsFillAttributes(JSONObject jSONObject) {
        String[] stringArray;
        boolean bl = false;
        for (String string : stringArray = BasicFactory.keySet(jSONObject)) {
            if (!(KEY_ANGLE.equals(string) || KEY_COLORS.equals(string) || KEY_FOCUS.equals(string) || KEY_GLOBAL.equals(string) || KEY_TYPE.equals(string))) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(Object object) {
        TemplateUtils.validateForNotNullValue(object, ErrorCode.PARAMETER_INVALID_VALUE, "Null gradient fill is not supported.");
        if (BasicFactory.isObject(object)) {
            Object object2;
            ArrayList<RaveColorOffset> arrayList;
            Object object3;
            if (BasicFactory.containsKey(object, KEY_TYPE)) {
                object3 = BasicFactory.getItem(object, KEY_TYPE);
                if (!BasicFactory.isString(object3)) throw new EngineException("Invalid gradient type", ErrorCode.PARAMETER_INVALID_VALUE, null);
                this.setGradientType((String)object3);
            }
            if (BasicFactory.containsKey(object, KEY_ANGLE)) {
                object3 = BasicFactory.getItem(object, KEY_ANGLE);
                if (!BasicFactory.isNumber(object3)) throw new EngineException("Invalid gradient angle ", ErrorCode.PARAMETER_INVALID_VALUE, null);
                this.setAngle((Number)object3);
            }
            if (BasicFactory.containsKey(object, KEY_FOCUS)) {
                object3 = BasicFactory.getItem(object, KEY_FOCUS);
                if (!BasicFactory.isObject(object3)) throw new EngineException("Invalid gradient focus values", ErrorCode.PARAMETER_INVALID_VALUE, null);
                Object object4 = BasicFactory.getItem(object, KEY_FOCUS_X);
                arrayList = BasicFactory.getItem(object, KEY_FOCUS_X);
                RaveLength raveLength = new RaveLength();
                raveLength.setValue(object4);
                object2 = new RaveLength();
                ((RaveLength)object2).setValue(arrayList);
                this.setFocus(raveLength, (RaveLength)object2);
            }
            if (BasicFactory.containsKey(object, KEY_GLOBAL)) {
                object3 = BasicFactory.getItem(object, KEY_GLOBAL);
                if (!BasicFactory.isBoolean(object3)) throw new EngineException("Invalid global value ", ErrorCode.PARAMETER_INVALID_VALUE, null);
                this.setGlobal((Boolean)object3);
            }
            if (!BasicFactory.containsKey(object, KEY_COLORS)) return;
            object3 = BasicFactory.getItem(object, KEY_COLORS);
            if (!BasicFactory.isArray(object3)) throw new EngineException("Invalid color offset value", ErrorCode.PARAMETER_INVALID_VALUE, null);
            int n = BasicFactory.getJSONArraySize((JSONArray)object3);
            if (n == 0) {
                throw new EngineException("Empty color offset list is not supported", ErrorCode.PARAMETER_INVALID_VALUE, null);
            }
            arrayList = new ArrayList<RaveColorOffset>();
            for (int i = 0; i < n; ++i) {
                object2 = BasicFactory.getArrayItem((JSONArray)object3, i);
                RaveColorOffset raveColorOffset = new RaveColorOffset();
                raveColorOffset.setValue(object2);
                arrayList.add(raveColorOffset);
            }
            this.setColorOffset(arrayList);
            return;
        } else {
            RaveGradientFill.reportTypeMismatch(object, "RaveGradientFill");
        }
    }

    @Override
    public Object getValue() {
        return this.fillValue;
    }

    public void setGradientType(String string) {
        TemplateUtils.validateForNotNullValue(string, ErrorCode.PARAMETER_INVALID_VALUE, "Null gradient type is not supported.");
        if (!Gradient.isValidGradientType(string)) {
            throw new EngineException("'" + string + "' is not a supported fill gradient type.", ErrorCode.PARAMETER_INVALID_VALUE, null);
        }
        this.gradientType = string;
        BasicFactory.put(this.getFillJSON(), KEY_TYPE, string);
    }

    public String getGradientType() {
        return this.gradientType;
    }

    public void setFocus(RaveLength raveLength, RaveLength raveLength2) {
        TemplateUtils.validate(raveLength != null || raveLength2 != null, ErrorCode.PARAMETER_INVALID_VALUE, "Both x and y value for focus cannot not be null");
        TemplateUtils.validate(raveLength != null && raveLength.getValue() != null || raveLength2 != null && raveLength2.getValue() != null, ErrorCode.PARAMETER_INVALID_VALUE, "Empty Rave Length parameter is not supported.");
        JSONObject jSONObject = null;
        if (raveLength != null) {
            jSONObject = BasicFactory.createJSONObject();
            BasicFactory.put(jSONObject, KEY_FOCUS_X, raveLength.getValue());
            this.focusX = raveLength.getValue();
        }
        if (raveLength2 != null) {
            if (jSONObject == null) {
                jSONObject = BasicFactory.createJSONObject();
            }
            BasicFactory.put(jSONObject, KEY_FOCUS_Y, raveLength2.getValue());
            this.focusY = raveLength2.getValue();
        }
        if (jSONObject != null) {
            BasicFactory.put(this.getFillJSON(), KEY_FOCUS, jSONObject);
        }
    }

    public Object getFocusX() {
        return this.focusX;
    }

    public Object getFocusY() {
        return this.focusY;
    }

    public void setAngle(Number number) {
        TemplateUtils.validateForNotNullValue(number, ErrorCode.PARAMETER_INVALID_VALUE, "Null Gradient angle is not supported");
        BasicFactory.put(this.getFillJSON(), KEY_ANGLE, number);
        this.angle = number.doubleValue();
    }

    public double getAngle() {
        return this.angle;
    }

    public void setGlobal(Boolean bl) {
        TemplateUtils.validateForNotNullValue(bl, ErrorCode.PARAMETER_INVALID_VALUE, "Null Global value is not supported");
        BasicFactory.put(this.getFillJSON(), KEY_GLOBAL, bl);
        this.isGlobal = bl;
    }

    public boolean getIsGlobal() {
        return this.isGlobal;
    }

    public void insertColorOffset(RaveColorOffset raveColorOffset, int n) {
        int n2;
        TemplateUtils.validate(n >= 0, ErrorCode.TEMPLATE_INVALID_ARGUMENT, "Index of color offset should be greater then 0");
        JSONArray jSONArray = (JSONArray)BasicFactory.getItem(this.getFillJSON(), KEY_COLORS);
        if (jSONArray == null) {
            jSONArray = BasicFactory.createJSONArray();
            BasicFactory.put(this.getFillJSON(), KEY_COLORS, jSONArray);
        }
        if ((n2 = BasicFactory.getJSONArraySize(jSONArray)) < n) {
            int n3 = n - n2;
            for (int i = 0; i < n3; ++i) {
                BasicFactory.add(jSONArray, BasicFactory.createJSONObject());
            }
        }
        Object object = null;
        object = raveColorOffset == null || raveColorOffset.getValue() == null ? BasicFactory.createJSONObject() : raveColorOffset.getValue();
        BasicFactory.addAt(jSONArray, object, n);
    }

    public void setColorOffset(List<RaveColorOffset> list) {
        TemplateUtils.validate(list != null && list.size() != 0, ErrorCode.PARAMETER_INVALID_VALUE, "Null or Empty color offset values are not supported.");
        JSONArray jSONArray = BasicFactory.createJSONArray();
        for (RaveColorOffset raveColorOffset : list) {
            BasicFactory.add(jSONArray, raveColorOffset.getValue());
        }
        BasicFactory.put(this.getFillJSON(), KEY_COLORS, jSONArray);
    }

    @Override
    public RaveDataType getType() {
        return RaveDataType.RaveGradientFill;
    }
}

