/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template.ravetype;

import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.template.ravetype.AbstractDataType;
import com.ibm.vis.template.ravetype.RaveDataType;

public class RaveLength
extends AbstractDataType {
    private static final String[] UNITS = new String[]{"%%", "%", "px", "pt", "pc", "cm", "mm", "in"};
    private Number numericValue = null;
    private String unitValue = null;

    @Override
    public void setValue(Object object) {
        if (BasicFactory.isNumber(object)) {
            this.numericValue = (Number)object;
        } else if (BasicFactory.isString(object)) {
            String string = ((String)object).trim();
            boolean bl = false;
            for (int i = 0; i < UNITS.length && !bl; ++i) {
                if (!string.endsWith(UNITS[i])) continue;
                bl = true;
                this.unitValue = UNITS[i];
                string = string.substring(0, string.length() - UNITS[i].length());
            }
            try {
                this.numericValue = Double.valueOf(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                RaveLength.reportTypeMismatch(object, "RaveLength");
            }
        } else {
            RaveLength.reportTypeMismatch(object, "RaveLength");
        }
    }

    @Override
    public Object getValue() {
        Number number = this.numericValue;
        if (BasicFactory.isInteger(this.numericValue)) {
            number = this.numericValue.longValue();
        }
        if (this.unitValue == null) {
            return number;
        }
        return number + this.unitValue;
    }

    public void setLength(Number number, String string) {
        if (!RaveLength.isValidUnit(string)) {
            RaveLength.reportTypeMismatch((number == null ? "" : number) + string, "RaveLength");
        }
        this.numericValue = number;
        this.unitValue = string;
    }

    private static boolean isValidUnit(String string) {
        boolean bl = false;
        if (string == null || string.length() == 0) {
            bl = true;
        } else {
            for (int i = 0; i < UNITS.length && !bl; ++i) {
                if (!UNITS[i].equals(string)) continue;
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public RaveDataType getType() {
        return RaveDataType.RaveLength;
    }
}

