/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.template.ravetype;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.template.internal.TemplateUtils;
import com.ibm.vis.template.ravetype.AbstractDataType;
import com.ibm.vis.template.ravetype.RaveColor;
import com.ibm.vis.template.ravetype.RaveDataType;
import com.ibm.vis.template.ravetype.RaveGradientFill;

public class RaveStyle
extends AbstractDataType {
    private static final String KEY_FILL = "fill";
    private JSONObject styleJSON = null;
    private AbstractDataType fill = null;

    @Override
    public void setValue(Object object) {
        TemplateUtils.validateForNotNullValue(object, ErrorCode.PARAMETER_INVALID_VALUE, "Null style value is not supported.");
        if (BasicFactory.isObject(object)) {
            if (BasicFactory.containsKey(object, KEY_FILL)) {
                Object object2 = BasicFactory.getItem(object, KEY_FILL);
                if (BasicFactory.isObject(object2) && RaveGradientFill.containsFillAttributes((JSONObject)object2)) {
                    RaveGradientFill raveGradientFill = new RaveGradientFill();
                    raveGradientFill.setValue(object2);
                    this.setFillForGradientColor(raveGradientFill);
                } else {
                    RaveColor raveColor = new RaveColor();
                    raveColor.setValue(object2);
                    this.setFillForSolidColor(raveColor);
                }
            }
        } else {
            RaveStyle.reportTypeMismatch(object, "RaveStyle");
        }
    }

    @Override
    public Object getValue() {
        return this.styleJSON;
    }

    private JSONObject getStyleJSON() {
        if (this.styleJSON == null) {
            this.styleJSON = BasicFactory.createJSONObject();
        }
        return this.styleJSON;
    }

    private void setFill(AbstractDataType abstractDataType) {
        TemplateUtils.validateForNotNullValue(abstractDataType, ErrorCode.PARAMETER_INVALID_VALUE, "Null fill style is not supported");
        Object object = abstractDataType.getValue();
        TemplateUtils.validateForNotNullValue(object, ErrorCode.PARAMETER_INVALID_VALUE, "Null fill style is not supported");
        BasicFactory.put(this.getStyleJSON(), KEY_FILL, object);
        this.fill = abstractDataType;
    }

    public void setFillForSolidColor(RaveColor raveColor) {
        this.setFill(raveColor);
    }

    public void setFillForGradientColor(RaveGradientFill raveGradientFill) {
        this.setFill(raveGradientFill);
    }

    public AbstractDataType getFill() {
        return this.fill;
    }

    @Override
    public RaveDataType getType() {
        return RaveDataType.RaveStyle;
    }
}

