/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.DateFormatter;
import com.ibm.vis.engine.LocalizationSettings;
import com.ibm.vis.engine.LocalizedDateFormatter;
import com.ibm.vis.engine.LocalizedNumberFormatter;
import com.ibm.vis.engine.NumberFormatter;
import com.ibm.vis.engine.StringFormatter;
import com.ibm.vis.engine.configuration.ContrastParameters;
import com.ibm.vis.engine.configuration.HighContrastState;
import com.ibm.vis.engine.configuration.IVisConfiguration;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.asynchronous.AsynchAction;
import com.ibm.vis.engine.internal.asynchronous.AsynchronousService;
import com.ibm.vis.engine.internal.globalization.LocalizationUtil;
import com.ibm.vis.engine.internal.interaction.effect.Effect;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.SpecUtil;
import com.ibm.vis.engine.internal.nativeImpl.ThreadHelper;
import com.ibm.vis.engine.internal.nativeImpl.ThreadLauncher;
import com.ibm.vis.engine.internal.nativeImpl.VisCommandExecutor;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.engine.internal.util.Version;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.interaction.ChangeEffect;
import com.ibm.vis.interaction.Interactivity;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.events.RaveEvent;
import com.ibm.vis.interaction.events.RaveListener;
import com.ibm.vis.interaction.events.SceneTreeReadyEvent;
import com.ibm.vis.interaction.events.SpecChangeEvent;
import com.ibm.vis.interaction.events.VisControlBeingDestroyedEvent;
import com.ibm.vis.interaction.events.VisControlDestroyEvent;
import com.ibm.vis.interaction.events.VisControlStartupEvent;
import com.ibm.vis.interaction.events.VisualizationReadyEvent;
import com.ibm.vis.interaction.events.VisualizationRenderEvent;
import com.ibm.vis.interaction.internal.SelectionTransition;
import com.ibm.vis.interaction.internal.ViewportZoomImpl;
import com.ibm.vis.interaction.internal.events.EventDispatcher;
import com.ibm.vis.interaction.internal.events.EventDispatcherImpl;
import com.ibm.vis.internal.AbstractMappedJSONObject;
import com.ibm.vis.internal.accessibility.description.SimpleChartDescriber;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.LogEntry;
import com.ibm.vis.monitor.LogLevel;
import com.ibm.vis.monitor.LogListener;
import com.ibm.vis.monitor.Logger;
import com.ibm.vis.scenetree.internal.SceneNodeJSONSerializer;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.spec.internal.LocalizationSpec;
import com.ibm.vis.ui.VisController;
import com.ibm.vis.ui.awt.VisControlLifecycleListener;
import com.ibm.vis.ui.awt.VisualizationEventListener;
import com.ibm.vis.ui.awt.internal.SceneRendering;
import com.ibm.vis.ui.awt.internal.VisControlInteractivity;
import com.ibm.vis.ui.awt.internal.VisPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class VisControl
extends JLayeredPane
implements VisController {
    private static final long serialVersionUID = 8907778855126631333L;
    private final Vis vis;
    private final boolean allocatedVis;
    private final VisControlInteractivity interactivity;
    private LocalizationSettings localizationSettings;
    VisState visState;
    JSONObject setSpec;
    private SceneTree currentScene;
    private JSONObject defenderControllerSpec;
    private boolean defenderController = false;
    private final EventDispatcher eventDispatcher;
    private final Map<Object, RaveListener> backwardCompatibleListenersMap;
    private String baseURI = null;
    private final VisPanel foregroundPanel;
    private static final Integer foregroundPanelLayer = new Integer(2);
    private Toolkit toolkit = null;
    private HighContrastState highContrastState;
    private int currentTransitionIndex;
    private final VisCommandExecutor executorService;

    public VisControl(RaveListener raveListener, String string) {
        this(null, raveListener, string);
    }

    protected VisControl(Vis vis, RaveListener raveListener, String string) {
        ThreadHelper threadHelper;
        if (vis == null) {
            this.vis = new Vis(null);
            this.allocatedVis = true;
        } else {
            this.vis = vis;
            this.allocatedVis = false;
        }
        if (this.vis != null && this.vis.getLogger() != null) {
            this.vis.getLogger().addListener(new LogListener(){

                @Override
                public boolean isTracing() {
                    return false;
                }

                @Override
                public void accept(LogEntry logEntry) {
                    if (logEntry.getLevel() == LogLevel.Error) {
                        VisControl.this.onError(new Exception(logEntry.getMessage()));
                    }
                }
            });
        }
        this.executorService = VisCommandExecutor.newInstance();
        if (this.allocatedVis) {
            threadHelper = new ThreadHelper(this.executorService, this.vis.getLogger());
            this.vis.setThreadHelper(threadHelper);
        } else {
            threadHelper = this.vis.getThreadHelper();
        }
        this.setName(string);
        this.foregroundPanel = new VisPanel(this, string + "-Fore");
        this.add((Component)this.foregroundPanel, foregroundPanelLayer);
        this.localizationSettings = new LocalizationSettings();
        this.eventDispatcher = new EventDispatcherImpl(this);
        this.backwardCompatibleListenersMap = new HashMap<Object, RaveListener>();
        this.interactivity = new VisControlInteractivity(this, this.getRendering(), this.eventDispatcher, threadHelper);
        if (raveListener != null) {
            this.addListener("VisControlStartupEvent", raveListener);
        }
        final VisControlInteractivity visControlInteractivity = this.interactivity;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = VisControl.this.getSize();
                visControlInteractivity.visControlSizeChanged(dimension.width, dimension.height);
                VisControl.this.repaint();
            }
        });
        this.fireVisControlStartupEvent();
        this.highContrastState = HighContrastState.SYSTEM_DEFAULT;
        this.currentScene = null;
    }

    @Override
    public void copyConfigurationFrom(IVisConfiguration iVisConfiguration) {
        if (iVisConfiguration != null) {
            this.setBaseURI(iVisConfiguration.getBaseURI());
            this.setDateFormatter(iVisConfiguration.getDateFormatter());
            this.setDefaultLocalization(iVisConfiguration.getDefaultLocalization());
            this.setGenerateAccessibility(iVisConfiguration.getGenerateAccessibility());
            this.setHighContrast(iVisConfiguration.getHighContrast());
            this.setLocalizedDateFormatter(iVisConfiguration.getLocalizedDateFormatter());
            this.setLocalizedNumberFormatter(iVisConfiguration.getLocalizedNumberFormatter());
            this.setNumberFormatter(iVisConfiguration.getNumberFormatter());
            this.setSpecificationDefaultVersion(iVisConfiguration.getSpecificationDefaultVersion());
            this.setSpecificationValidation(iVisConfiguration.getSpecificationValidation());
            this.setStringFormatter(iVisConfiguration.getStringFormatter());
            this.setTooltipsForTruncatedText(iVisConfiguration.getTooltipsForTruncatedText());
        }
    }

    private boolean highContrastFromSystem() {
        this.toolkit = Toolkit.getDefaultToolkit();
        Object object = this.toolkit.getDesktopProperty("win.highContrast.on");
        return object != null ? (Boolean)object : false;
    }

    @Override
    public void setLogger(Logger logger) {
        this.vis.setLogger(logger);
    }

    @Override
    public Logger getLogger() {
        return this.vis.getLogger();
    }

    @Override
    public void addGlobalListener(RaveListener raveListener) {
        this.getEventDispatcher().addListener(raveListener);
    }

    @Override
    public void addListener(Object object, RaveListener raveListener) {
        this.getEventDispatcher().addListenerToGroup(object, raveListener);
    }

    @Override
    public void removeGlobalListener(RaveListener raveListener) {
        this.getEventDispatcher().removeListener(raveListener);
    }

    @Override
    public void removeListener(Object object, RaveListener raveListener) {
        this.getEventDispatcher().removeListenerFromGroup(object, raveListener);
    }

    @Override
    public void addVisualizationListener(RaveListener raveListener) {
        this.getEventDispatcher().addListenerToGroup("SpecChangeEvent", raveListener);
        this.getEventDispatcher().addListenerToGroup("VisualizationReadyEvent", raveListener);
        this.getEventDispatcher().addListenerToGroup("SceneTreeReadyEvent", raveListener);
        this.getEventDispatcher().addListenerToGroup("VisualizationRenderEvent", raveListener);
    }

    @Override
    public void removeVisualizationListener(RaveListener raveListener) {
        this.getEventDispatcher().removeListenerFromGroup("SpecChangeEvent", raveListener);
        this.getEventDispatcher().removeListenerFromGroup("VisualizationReadyEvent", raveListener);
        this.getEventDispatcher().removeListenerFromGroup("SceneTreeReadyEvent", raveListener);
        this.getEventDispatcher().removeListenerFromGroup("VisualizationRenderEvent", raveListener);
    }

    @Override
    public void addVisControlListener(RaveListener raveListener) {
        this.getEventDispatcher().addListenerToGroup("VisControlStartupEvent", raveListener);
        this.getEventDispatcher().addListenerToGroup("VisControlBeingDestroyedEvent", raveListener);
        this.getEventDispatcher().addListenerToGroup("VisControlDestroyEvent", raveListener);
    }

    @Override
    public void removeVisControlListener(RaveListener raveListener) {
        this.getEventDispatcher().removeListenerFromGroup("VisControlStartupEvent", raveListener);
        this.getEventDispatcher().removeListenerFromGroup("VisControlBeingDestroyedEvent", raveListener);
        this.getEventDispatcher().removeListenerFromGroup("VisControlDestroyEvent", raveListener);
    }

    @Deprecated
    public void addVisualizationEventListener(final VisualizationEventListener visualizationEventListener) {
        final VisControl visControl = this;
        RaveListener raveListener = new RaveListener(){

            @Override
            public void update(RaveEvent raveEvent, VisController visController) {
                if ("SpecChangeEvent".equals(raveEvent.getEventGroup())) {
                    visualizationEventListener.onSpecChange(visControl);
                } else if ("VisualizationReadyEvent".equals(raveEvent.getEventGroup())) {
                    visualizationEventListener.onReady(visControl);
                } else if ("VisualizationRenderEvent".equals(raveEvent.getEventGroup())) {
                    visualizationEventListener.onRender(visControl);
                }
            }
        };
        this.backwardCompatibleListenersMap.put(visualizationEventListener, raveListener);
        this.addVisualizationListener(raveListener);
    }

    @Deprecated
    public void removeVisualizationEventListener(VisualizationEventListener visualizationEventListener) {
        RaveListener raveListener = this.backwardCompatibleListenersMap.get(visualizationEventListener);
        this.backwardCompatibleListenersMap.remove(visualizationEventListener);
        this.removeVisualizationListener(raveListener);
    }

    @Deprecated
    public void addVisControlLifecycleListener(final VisControlLifecycleListener visControlLifecycleListener) {
        final VisControl visControl = this;
        RaveListener raveListener = new RaveListener(){

            @Override
            public void update(RaveEvent raveEvent, VisController visController) {
                if ("VisControlStartupEvent".equals(raveEvent.getEventGroup())) {
                    visControlLifecycleListener.onStartup(visControl);
                } else if ("VisControlBeingDestroyedEvent".equals(raveEvent.getEventGroup())) {
                    visControlLifecycleListener.onBeingDestroyed(visControl);
                } else if ("VisControlDestroyEvent".equals(raveEvent.getEventGroup())) {
                    visControlLifecycleListener.onDestroy(visControl);
                }
            }
        };
        this.backwardCompatibleListenersMap.put(visControlLifecycleListener, raveListener);
        this.addVisControlListener(raveListener);
    }

    @Deprecated
    public void removeVisControlLifecycleListener(VisControlLifecycleListener visControlLifecycleListener) {
        RaveListener raveListener = this.backwardCompatibleListenersMap.get(visControlLifecycleListener);
        this.backwardCompatibleListenersMap.remove(visControlLifecycleListener);
        this.removeVisControlListener(raveListener);
    }

    @Override
    public void setNumberFormatter(NumberFormatter numberFormatter) {
        this.vis.setNumberFormatter(numberFormatter);
    }

    @Override
    public NumberFormatter getNumberFormatter() {
        return this.vis.getNumberFormatter();
    }

    @Override
    public void setLocalizedNumberFormatter(LocalizedNumberFormatter localizedNumberFormatter) {
        this.vis.setLocalizedNumberFormatter(localizedNumberFormatter);
    }

    @Override
    public LocalizedNumberFormatter getLocalizedNumberFormatter() {
        return this.vis.getLocalizedNumberFormatter();
    }

    @Override
    public void setDateFormatter(DateFormatter dateFormatter) {
        this.vis.setDateFormatter(dateFormatter);
    }

    @Override
    public DateFormatter getDateFormatter() {
        return this.vis.getDateFormatter();
    }

    @Override
    public void setLocalizedDateFormatter(LocalizedDateFormatter localizedDateFormatter) {
        this.vis.setLocalizedDateFormatter(localizedDateFormatter);
    }

    @Override
    public LocalizedDateFormatter getLocalizedDateFormatter() {
        return this.vis.getLocalizedDateFormatter();
    }

    @Override
    public void setStringFormatter(StringFormatter stringFormatter) {
        this.vis.setStringFormatter(stringFormatter);
    }

    @Override
    public StringFormatter getStringFormatter() {
        return this.vis.getStringFormatter();
    }

    @Override
    public final Interactivity getInteractivity() {
        return this.interactivity;
    }

    @Deprecated
    public void setScene(JSONArray jSONArray) {
    }

    public void setSceneTree(SceneTree sceneTree) {
        this.applySceneWithTransition(sceneTree, 0);
    }

    @Deprecated
    public JSONArray getScene() {
        if (this.currentScene != null) {
            return SceneNodeJSONSerializer.serialize(this.currentScene);
        }
        return null;
    }

    public SceneTree getSceneTree() {
        return this.currentScene;
    }

    @Override
    public final void setSpecification(JSONObject jSONObject) {
        this.setSpecificationWithTransition(jSONObject, 0);
    }

    @Override
    public void setContrast(ContrastParameters contrastParameters) {
        JSONObject jSONObject;
        if (this.vis.setContrast(contrastParameters) && (jSONObject = this.vis.getOrigSpecification()) != null) {
            this.setSpecification(jSONObject);
        }
    }

    private boolean isHighContrastModeActive() {
        if (this.highContrastState == HighContrastState.SYSTEM_DEFAULT) {
            return this.highContrastFromSystem();
        }
        return this.highContrastState == HighContrastState.ALWAYS;
    }

    @Override
    public final JSONObject getSpecification() {
        return this.vis.getSpecification();
    }

    @Override
    public void setSpecificationWithTransition(JSONObject jSONObject, int n) {
        if (this.vis.getLogger() != null) {
            this.vis.getLogger().detail(LogComponent.AppVisBoard, "VisControl: Setting Spec");
        }
        this.defenderControllerSpec = null;
        if (!this.defenderController) {
            this._splitDefenderSpec(jSONObject);
        }
        this.setSpec = jSONObject;
        this.currentTransitionIndex = n;
        AsynchronousService asynchronousService = new AsynchronousService();
        asynchronousService.clear();
        AsynchSetSpecAction asynchSetSpecAction = new AsynchSetSpecAction(this);
        this.vis.setSpecAction(asynchSetSpecAction);
        asynchronousService.addAction(asynchSetSpecAction);
        AsynchCompleteSceneAction asynchCompleteSceneAction = new AsynchCompleteSceneAction(this);
        asynchronousService.addAction(asynchCompleteSceneAction);
        asynchronousService.run();
    }

    boolean setVisSpecification() {
        this.visState = this.vis.setSpecification(this.setSpec);
        this.fireSpecChangeEvent();
        this.visState.isSpecSet();
        return true;
    }

    boolean completeScene() {
        if (this.vis.getLogger() != null) {
            this.vis.getLogger().detail(LogComponent.AppVisBoard, "VisControl: Updating Scene");
        }
        this.visState = this.vis.makeSceneTree(null, this.visState);
        this.fireVisualizationReadyEvent();
        SceneTree sceneTree = this.visState.getSceneTree();
        this.fireSceneTreeReadyEvent();
        this.interactivity.notifySceneChanged(true);
        this.applySceneWithTransition(sceneTree, this.currentTransitionIndex);
        if (this.vis.getStartingViewport() != null) {
            ViewportZoomImpl viewportZoomImpl = (ViewportZoomImpl)this.interactivity.getViewportZoom();
            viewportZoomImpl.initializeWithViewport(this.vis.getStartingViewport(), this.vis.getPanFlag(), this.visState.getSceneTree());
        }
        return true;
    }

    @Override
    public void updateSpecificationData(JSONArray jSONArray, int n) {
        if (this.vis.getLogger() != null) {
            this.vis.getLogger().detail(LogComponent.AppVisBoard, "VisControl: Updating Spec Data");
        }
        VisState visState = this.vis.updateSpecificationData(jSONArray);
        this.fireSpecChangeEvent();
        if (this.vis.getLogger() != null) {
            this.vis.getLogger().detail(LogComponent.AppVisBoard, "VisControl: Updating Scene");
        }
        visState = this.vis.recreateSceneTree(null, visState, 1);
        this.fireVisualizationReadyEvent();
        SceneTree sceneTree = visState.getSceneTree();
        this.fireSceneTreeReadyEvent();
        this.applySceneWithTransition(sceneTree, n);
    }

    public void setSceneWithTransition(SceneTree sceneTree, int n) {
        this.applySceneWithTransition(sceneTree, n);
    }

    private synchronized void applySceneWithTransition(SceneTree sceneTree, int n) {
        if (this.vis.getLogger() != null) {
            this.vis.getLogger().detail(LogComponent.AppVisBoard, "VisControl: Setting Scene");
        }
        this.getAccessibleContext().setVisDescription(this.vis.getDescription());
        if (!this.vis.getVisContext().isHandlingSceneTree()) {
            for (Integer n2 : this.interactivity.getSceneState().getSelectionKeys()) {
                SceneItem[] sceneItemArray = this.interactivity.getSelected(n2);
                SceneNode[] sceneNodeArray = new SceneNode[sceneItemArray.length];
                for (int i = 0; i < sceneItemArray.length; ++i) {
                    sceneNodeArray[i] = sceneItemArray[i].getSceneNode();
                }
                String[] stringArray = SelectionTransition.getMatchingNodeIds(sceneNodeArray, sceneTree);
                this.interactivity.applySelectionHighlightOnScene(sceneTree, stringArray, n2);
            }
        }
        this.interactivity.reset();
        ChangeEffect changeEffect = this.interactivity.getChangeEffects().getChangeEffect(n);
        this.interactivity.setStartAnimation((Effect)changeEffect);
        this.setScene(sceneTree);
        this.interactivity.updateStateWithSceneTree(sceneTree);
        this.foregroundPanel.getRendering().setScene(sceneTree);
        if (SwingUtilities.isEventDispatchThread()) {
            this.setComponentPreferredSize();
        }
        this.repaint();
    }

    public synchronized void setScene(SceneTree sceneTree) {
        this.currentScene = sceneTree;
    }

    void onError(Throwable throwable) {
        JOptionPane jOptionPane = new JOptionPane("Exception Thrown in VisControl: " + throwable, 0);
        JDialog jDialog = jOptionPane.createDialog(this, "Error");
        jDialog.setModal(false);
        jDialog.setVisible(true);
        throwable.printStackTrace();
    }

    @Override
    public void repaint() {
        super.repaint();
        this.fireVisualizationRenderEvent();
    }

    public void waitForAnimationCompletion() {
        this.getRendering().waitForStartAnimationCompletion();
    }

    private void setComponentPreferredSize() {
        Dim dim = this.getRendering().getSize();
        if (dim == null) {
            return;
        }
        Dimension dimension = new Dimension((int)dim.getWidth(), (int)dim.getHeight());
        if (dimension != this.getPreferredSize()) {
            this.invalidate();
            this.setPreferredSize(dimension);
            this.foregroundPanel.setSize(dimension);
            JComponent jComponent = this;
            while (!(jComponent instanceof JScrollPane) && jComponent.getParent() instanceof JComponent) {
                jComponent = (JComponent)jComponent.getParent();
            }
            jComponent.revalidate();
        }
    }

    public final EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    protected void fireSpecChangeEvent() {
        SpecChangeEvent specChangeEvent = new SpecChangeEvent();
        this.getEventDispatcher().notify(specChangeEvent);
    }

    protected void fireVisualizationReadyEvent() {
        VisualizationReadyEvent visualizationReadyEvent = new VisualizationReadyEvent();
        this.getEventDispatcher().notify(visualizationReadyEvent);
    }

    protected void fireSceneTreeReadyEvent() {
        SceneTreeReadyEvent sceneTreeReadyEvent = new SceneTreeReadyEvent();
        this.getEventDispatcher().notify(sceneTreeReadyEvent);
    }

    protected void fireVisualizationRenderEvent() {
        VisualizationRenderEvent visualizationRenderEvent = new VisualizationRenderEvent();
        this.getEventDispatcher().notify(visualizationRenderEvent);
    }

    protected void fireVisControlStartupEvent() {
        VisControlStartupEvent visControlStartupEvent = new VisControlStartupEvent();
        this.getEventDispatcher().notify(visControlStartupEvent);
    }

    protected void fireVisControlBeingDestroyedEvent() {
        VisControlBeingDestroyedEvent visControlBeingDestroyedEvent = new VisControlBeingDestroyedEvent();
        this.getEventDispatcher().notify(visControlBeingDestroyedEvent);
    }

    protected void fireVisControlDestroyEvent() {
        VisControlDestroyEvent visControlDestroyEvent = new VisControlDestroyEvent();
        this.getEventDispatcher().notify(visControlDestroyEvent);
    }

    public Image makeImage() {
        return this.foregroundPanel.makeImage();
    }

    public Image makeImageWithoutAlpha() {
        BufferedImage bufferedImage = (BufferedImage)this.foregroundPanel.makeImage();
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 5);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public void dispose() {
        this.fireVisControlBeingDestroyedEvent();
        this.getRendering().dispose();
        this.interactivity.dispose();
        this.foregroundPanel.dispose();
        if (this.allocatedVis) {
            this.vis.dispose();
        }
        this.executorService.dispose();
        this.fireVisControlDestroyEvent();
        ThreadLauncher.disposeAll();
    }

    @Deprecated
    public void setStartAnimation(Effect effect) {
        this.interactivity.setStartAnimation(effect);
    }

    @Deprecated
    public boolean usesFractionalMetrics() {
        return this.vis.getVisContext().usesFractionalMetrics();
    }

    @Deprecated
    public void setDefaultLocalizationSpec(JSONObject jSONObject) {
        LocalizationSpec localizationSpec = (LocalizationSpec)AbstractMappedJSONObject.createSpecObjectFromType(jSONObject, "LocalizationSpec");
        this.vis.setDefaultLocalization(localizationSpec);
    }

    @Override
    public void setDefaultLocalization(LocalizationSettings localizationSettings) {
        if (localizationSettings != null) {
            this.localizationSettings = localizationSettings.copy();
            LocalizationSpec localizationSpec = LocalizationUtil.createLocationSpec(this.localizationSettings);
            this.vis.setDefaultLocalization(localizationSpec);
        }
    }

    @Override
    public LocalizationSettings getDefaultLocalization() {
        return this.localizationSettings.copy();
    }

    @Override
    public void setTooltipsForTruncatedText(boolean bl) {
        this.vis.getVisContext().setTooltipsForTruncatedText(bl);
        this.vis.updateLegendVis();
    }

    @Override
    public boolean getTooltipsForTruncatedText() {
        return this.vis.getVisContext().getTooltipsForTruncatedText();
    }

    @Override
    public AccessibleVisControl getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleVisControl();
        }
        return (AccessibleVisControl)this.accessibleContext;
    }

    @Override
    public void setSpecificationValidation(boolean bl) {
        this.vis.setSpecificationValidation(bl);
    }

    @Override
    public boolean getSpecificationValidation() {
        return this.vis.getSpecificationValidation();
    }

    @Override
    public void setSpecificationDefaultVersion(String string) {
        if (string == null || string.isEmpty()) {
            this.vis.setSpecificationDefaultVersion(null);
        } else {
            this.vis.setSpecificationDefaultVersion(Version.parseVersion(string));
        }
    }

    @Override
    public String getSpecificationDefaultVersion() {
        Version version = this.vis.getSpecificationDefaultVersion();
        return version == null ? null : version.toString();
    }

    @Deprecated
    public final Vis getVis() {
        return this.vis;
    }

    @Deprecated
    public final SceneRendering getRendering() {
        return this.foregroundPanel.getRendering();
    }

    @Override
    public void setBaseURI(String string) {
        if (string != null) {
            this.baseURI = string;
            if (this.baseURI != null) {
                SpecUtil.setResourcePath(this.baseURI);
            }
        }
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public void setGenerateAccessibility(boolean bl) {
        this.vis.getVisContext().setGenerateAccessibility(bl);
    }

    @Override
    public boolean getGenerateAccessibility() {
        return this.vis.getVisContext().getGenerateAccessibility();
    }

    @Override
    @Deprecated
    public void setHighContrast(HighContrastState highContrastState) {
        this.highContrastState = highContrastState;
        this.vis.setHighContrast(this.isHighContrastModeActive());
    }

    @Override
    @Deprecated
    public HighContrastState getHighContrast() {
        if (this.highContrastState != null) {
            return this.highContrastState;
        }
        return HighContrastState.SYSTEM_DEFAULT;
    }

    public final VisCommandExecutor getExecutorService() {
        return this.executorService;
    }

    public void buildDefenderController(VisControl visControl) {
        this.defenderController = true;
        visControl.getInteractivity().linkDefenderInteractivity(this.getInteractivity());
        this.setSpecification(visControl.defenderControllerSpec);
        this.getInteractivity().initializeDefenderPosition();
    }

    private boolean _splitDefenderSpec(JSONObject jSONObject) {
        Object object;
        JSONObject jSONObject2;
        int n = 0;
        int n2 = -1;
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"grammar");
        if (jSONArray != null) {
            n = jSONArray.size();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject3 = (JSONObject)jSONArray.get(i);
                JSONArray jSONArray2 = (JSONArray)jSONObject3.get((Object)"elements");
                if (jSONArray2 == null) continue;
                int n3 = jSONArray2.size();
                for (int j = 0; j < n3; ++j) {
                    jSONObject2 = (JSONObject)jSONArray2.get(j);
                    object = jSONObject2.get((Object)"interactionType");
                    if (object == null || !(object instanceof String) || !"scrollUnit".equals(object)) continue;
                    n2 = i;
                }
            }
        }
        if (n2 > -1) {
            double d = 0.0;
            double d2 = 0.0;
            this.defenderControllerSpec = (JSONObject)BasicFactory.deepClone(jSONObject);
            jSONArray = (JSONArray)jSONObject.get((Object)"grammar");
            jSONArray.remove(n2);
            JSONObject jSONObject4 = (JSONObject)this.defenderControllerSpec.get((Object)"size");
            jSONArray = (JSONArray)this.defenderControllerSpec.get((Object)"grammar");
            jSONObject2 = (JSONObject)jSONArray.get(n2);
            object = (JSONObject)jSONObject2.get((Object)"bounds");
            if (jSONObject4 != null) {
                d = ((Number)jSONObject4.get((Object)"height")).doubleValue();
                if (object != null && d > 0.0) {
                    double d3 = VisControl._getBoundsValue((JSONObject)object, "top", d);
                    double d4 = VisControl._getBoundsValue((JSONObject)object, "bottom", d);
                    BasicFactory.remove(jSONObject2, "bounds");
                    d2 = d4 - d3;
                    jSONObject4.put((Object)"height", (Object)d2);
                }
            }
            jSONArray = new JSONArray();
            jSONArray.add((Object)jSONObject2);
            this.defenderControllerSpec.put((Object)"grammar", (Object)jSONArray);
            n2 = 0;
            return true;
        }
        return false;
    }

    private static double _getBoundsValue(JSONObject jSONObject, String string, double d) {
        double d2 = 0.0;
        Object object = null;
        String string2 = null;
        if (jSONObject.containsKey((Object)string) && (object = jSONObject.get((Object)string)) != null) {
            if (object instanceof String) {
                string2 = (String)object;
                d2 = string2.endsWith("%") ? Double.parseDouble(string2.substring(0, string2.length() - 1)) / 100.0 * d : Double.parseDouble(string2.substring(0, string2.length() - 1));
            } else if (object instanceof Number) {
                d2 = ((Number)object).doubleValue();
            }
        }
        return d2;
    }

    @Override
    public boolean isDefenderChart() {
        return this.defenderControllerSpec != null;
    }

    @Override
    public ContrastParameters getContrast() {
        return this.vis.getContrast();
    }

    @Override
    public void setStartingViewport(double[][] dArray, boolean bl) {
        if (dArray == null) {
            this.vis.resetStartingViewport();
        } else {
            this.vis.setStartingViewport(dArray, bl);
        }
    }

    public class AccessibleVisControl
    extends JLayeredPane.AccessibleJLayeredPane {
        private static final long serialVersionUID = 4591490668599730769L;
        private String visDescription;

        public AccessibleVisControl() {
            super(VisControl.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return VisAccessibleRole.VIS;
        }

        protected void setVisDescription(String string) {
            String string2 = string;
            if (string2 == null && VisControl.this.getGenerateAccessibility()) {
                string2 = new SimpleChartDescriber(VisControl.this.vis.getCurrentSpec()).getDescription();
            }
            String string3 = this.visDescription;
            this.visDescription = string2;
            this.firePropertyChange("AccessibleDescription", string3, this.visDescription);
            if (this.visDescription != null && !this.visDescription.equals(string3)) {
                this.firePropertyChange("AccessibleDescription", string3, this.visDescription);
            }
        }

        @Override
        public String getAccessibleDescription() {
            String string = this.accessibleDescription;
            if (string == null) {
                string = this.visDescription;
            }
            if (string == null) {
                string = super.getAccessibleDescription();
            }
            return string;
        }
    }

    public static class VisAccessibleRole
    extends AccessibleRole {
        private static final String VIS_ROLE_DISPLAY_STRING_KEY = "visRoleDisplayString";
        private static final String VIS_CONTROL_RESOURCES = "com.ibm.vis.ui.awt.VisComponentResources";
        public static AccessibleRole VIS = new VisAccessibleRole("visRoleDisplayString");

        private VisAccessibleRole(String string) {
            super(string);
        }

        @Override
        protected String toDisplayString(String string, Locale locale) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
            return resourceBundle.getString(this.key);
        }

        @Override
        public String toDisplayString(Locale locale) {
            return this.toDisplayString(VIS_CONTROL_RESOURCES, locale);
        }
    }

    class AsynchCompleteSceneAction
    extends AsynchAction {
        VisControl visControl;

        public AsynchCompleteSceneAction(VisControl visControl2) {
            this.visControl = visControl2;
        }

        @Override
        public void run() {
            if (this.visControl.completeScene()) {
                this.done();
            } else {
                this.failed("The attempt to complete the scene failed");
            }
        }
    }

    class AsynchSetSpecAction
    extends AsynchAction {
        VisControl visControl;

        public AsynchSetSpecAction(VisControl visControl2) {
            this.visControl = visControl2;
        }

        @Override
        public void run() {
            if (this.visControl.setVisSpecification()) {
                this.done();
            } else {
                this.failed("The attempt to set the specification failed");
            }
        }
    }
}

