/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.interaction.internal.hitdetection.HitDetectionFilter;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.ui.awt.RaveMainType;
import com.ibm.vis.ui.awt.RaveSubType;
import com.ibm.vis.ui.awt.internal.ImageMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AreaShapeHitDetectionFilter
implements HitDetectionFilter {
    private final RaveMainType[] types;
    private final RaveSubType[] subTypes;

    public AreaShapeHitDetectionFilter(RaveMainType[] raveMainTypeArray, RaveSubType[] raveSubTypeArray) {
        this.types = raveMainTypeArray;
        this.subTypes = raveSubTypeArray;
    }

    @Override
    public boolean matches(SceneNode sceneNode) {
        SceneNodeImpl sceneNodeImpl = (SceneNodeImpl)sceneNode;
        String string = sceneNodeImpl.getId();
        if (string == null || SceneIdUtil.isBackId(string) || SceneIdUtil.isCoordsId(string) || SceneIdUtil.isOutId(string) || SceneIdUtil.isStrokeId(string)) {
            return false;
        }
        RaveMainType raveMainType = ImageMap.getMainType(SceneItemImpl.getSceneType(string));
        if (raveMainType == null) {
            return false;
        }
        if (this.types == null || this.types.length == 0) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; !bl && i < this.types.length; ++i) {
            if (this.types[i] != raveMainType) continue;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        if (this.subTypes == null || this.subTypes.length == 0) {
            return true;
        }
        RaveSubType raveSubType = ImageMap.getSubType(SceneItemImpl.getSceneSubType(string, sceneNodeImpl));
        bl = false;
        for (int i = 0; !bl && i < this.subTypes.length; ++i) {
            if (this.subTypes[i] != raveSubType) continue;
            bl = true;
        }
        return bl;
    }
}

