/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.internal.accessibility.AccessibleInfo;
import com.ibm.vis.internal.accessibility.AccessibleNode;
import com.ibm.vis.internal.accessibility.AtLink;
import java.util.ArrayList;
import java.util.Iterator;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class DisplayableNode {
    public static boolean showLabel = true;
    public static boolean showRole;
    public static boolean showHint;
    public static boolean showLinks;
    public static boolean showType;
    private AccessibleNode node;

    public DisplayableNode(AccessibleNode accessibleNode) {
        this.node = accessibleNode;
    }

    public AccessibleNode getNode() {
        return this.node;
    }

    public String toString() {
        ArrayList<AtLink> arrayList;
        Object object;
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        AccessibleInfo accessibleInfo = this.node.getAccessible();
        if (showLabel) {
            object = accessibleInfo.getStringProperty("label");
            if (object != null) {
                stringBuilder.append((String)object);
                bl = false;
            } else {
                arrayList = accessibleInfo.getProperty("fieldSummary");
                if (arrayList != null) {
                    stringBuilder.append(((Object)arrayList).toString());
                    bl = false;
                }
            }
        }
        if (showType && (object = accessibleInfo.getStringProperty("type")) != null) {
            if (!bl) {
                stringBuilder.append("<br>");
            }
            stringBuilder.append((String)object);
            bl = false;
        }
        if (showRole && (object = accessibleInfo.getStringProperty("role")) != null) {
            if (!bl) {
                stringBuilder.append("<br>");
            }
            stringBuilder.append((String)object);
            bl = false;
        }
        if (showHint && (object = accessibleInfo.getStringProperty("hint")) != null) {
            if (!bl) {
                stringBuilder.append("<br>");
            }
            stringBuilder.append((String)object);
            bl = false;
        }
        if (showLinks && (object = this.node.getAtLinks()) != null) {
            arrayList = new ArrayList<AtLink>();
            ArrayList<AtLink> arrayList2 = new ArrayList<AtLink>();
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                AtLink atLink = (AtLink)iterator.next();
                if (atLink.isFrom(this.node)) {
                    arrayList2.add(atLink);
                    continue;
                }
                if (!atLink.isTo(this.node)) continue;
                arrayList.add(atLink);
            }
            this.addLinks(stringBuilder, arrayList2, this.node, " link to: ");
            this.addLinks(stringBuilder, arrayList, this.node, " link from: ");
        }
        return stringBuilder.toString();
    }

    private void addLinks(StringBuilder stringBuilder, ArrayList<AtLink> arrayList, AccessibleNode accessibleNode, String string) {
        if (!arrayList.isEmpty()) {
            stringBuilder.append(string);
            for (AtLink atLink : arrayList) {
                stringBuilder.append(atLink.getDescriptionForLabel(accessibleNode)).append(" ");
            }
        }
    }

    public ArrayList<String> getSceneIds() {
        return this.node.getSceneIds();
    }

    public ArrayList<AtLink> getLinks() {
        return this.node.getAtLinks();
    }

    static {
        showLinks = true;
    }
}

