/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.util.SceneIdUtil;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.HitDetection;
import com.ibm.vis.interaction.internal.SceneItemImpl;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.ui.awt.AreaShape;
import com.ibm.vis.ui.awt.RaveMainType;
import com.ibm.vis.ui.awt.RaveSubType;
import com.ibm.vis.ui.awt.internal.AreaShapeHitDetectionFilter;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ImageMap {
    private final Vis vis;
    private final RaveMainType[] types;
    private final RaveSubType[] subTypes;

    public ImageMap(Vis vis, RaveMainType[] raveMainTypeArray, RaveSubType[] raveSubTypeArray) {
        this.vis = vis;
        this.types = raveMainTypeArray;
        this.subTypes = raveSubTypeArray;
    }

    public List<AreaShape> createShapes(SceneTree sceneTree) {
        SceneItem[] sceneItemArray;
        HitDetection hitDetection = new HitDetection(this.vis, sceneTree);
        for (SceneItem sceneItem : sceneItemArray = hitDetection.getFilteredItems(new AreaShapeHitDetectionFilter(this.types, this.subTypes))) {
            ((SceneItemImpl)sceneItem).decorateItem(this.vis, 0.0, 0.0);
        }
        ArrayList<AreaShape> arrayList = new ArrayList<AreaShape>();
        ArrayList<AreaShape> arrayList2 = new ArrayList<AreaShape>();
        ArrayList<AreaShape> arrayList3 = new ArrayList<AreaShape>();
        for (SceneItem sceneItem : sceneItemArray) {
            SceneItemImpl sceneItemImpl = (SceneItemImpl)sceneItem;
            ImageMap.addAreaShape(sceneItemImpl, arrayList, arrayList2, arrayList3);
            if (sceneItemImpl.getHitChildren() == null) continue;
            for (SceneItem sceneItem2 : sceneItemImpl.getHitChildren()) {
                SceneItemImpl sceneItemImpl2 = (SceneItemImpl)sceneItem2;
                ImageMap.addAreaShape(sceneItemImpl2, arrayList, arrayList2, arrayList3);
            }
        }
        ArrayList<AreaShape> arrayList4 = new ArrayList<AreaShape>();
        arrayList4.addAll(arrayList2);
        arrayList4.addAll(arrayList);
        arrayList4.addAll(arrayList3);
        return arrayList4;
    }

    private static void addAreaShape(SceneItemImpl sceneItemImpl, List<AreaShape> list, List<AreaShape> list2, List<AreaShape> list3) {
        String string = sceneItemImpl.getID();
        if (string == null) {
            return;
        }
        Shape shape = (Shape)sceneItemImpl.getSceneNode().getShape();
        if (shape == null || shape instanceof Schema) {
            return;
        }
        AreaShape areaShape = new AreaShape(sceneItemImpl, ImageMap.getMainType(sceneItemImpl.getType()), ImageMap.getSubType(sceneItemImpl.subType()), ImageMap.getTargetType(sceneItemImpl.dimensionIndex()));
        if (SceneIdUtil.isFaceted(string)) {
            list2.add(areaShape);
        } else if (SceneIdUtil.isAxisID(string)) {
            list.add(areaShape);
        } else {
            list3.add(areaShape);
        }
    }

    public static RaveMainType getMainType(String string) {
        if (string == null) {
            return null;
        }
        if ("element".equals(string)) {
            return RaveMainType.ELEMENT;
        }
        if ("legend".equals(string)) {
            return RaveMainType.LEGEND;
        }
        if ("axis".equals(string)) {
            return RaveMainType.AXIS;
        }
        if (string.equals("title")) {
            return RaveMainType.TITLE;
        }
        return null;
    }

    public static RaveSubType getSubType(String string) {
        if (string == null) {
            return RaveSubType.NONE;
        }
        if ("main".equals(string)) {
            return RaveSubType.MAIN;
        }
        if ("label".equals(string)) {
            return RaveSubType.LABEL;
        }
        if ("title".equals(string)) {
            return RaveSubType.TITLE;
        }
        if ("mark".equals(string)) {
            return RaveSubType.MARK;
        }
        if ("minorMark".equals(string)) {
            return RaveSubType.MINORMARK;
        }
        if ("line".equals(string)) {
            return RaveSubType.LINE;
        }
        if ("gridLine".equals(string)) {
            return RaveSubType.GRIDLINE;
        }
        if ("swatch".equals(string)) {
            return RaveSubType.SWATCH;
        }
        return RaveSubType.NONE;
    }

    private static RaveSubType getTargetType(Integer n) {
        RaveSubType raveSubType = null;
        if (n == null) {
            raveSubType = RaveSubType.NONE;
        } else if (n == 0) {
            raveSubType = RaveSubType.YAXIS;
        } else if (n == 1) {
            raveSubType = RaveSubType.XAXIS;
        }
        return raveSubType;
    }
}

