/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.interaction.Popup;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.navigation.FeatureShift;
import com.ibm.vis.interaction.navigation.MoveWeight;
import com.ibm.vis.interaction.navigation.Navigation;
import com.ibm.vis.interaction.navigation.NavigationDirection;
import com.ibm.vis.ui.awt.VisControl;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class KeyNavigationAdapter {
    private final Navigation navigation;
    private final JTextComponent textComponent;
    private static final String KEY_ENTER = "ENTER";
    private static final String KEY_ESCAPE = "ESCAPE";

    public KeyNavigationAdapter(JComponent jComponent, InteractivityImpl interactivityImpl, JTextComponent jTextComponent) {
        this.navigation = interactivityImpl.getNavigation();
        this.textComponent = jTextComponent;
        this.addKeybindings(jComponent);
    }

    protected JSONObject getVisSpecForSceneItem(SceneItem sceneItem) {
        return null;
    }

    private void addKeybindings(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap();
        ActionMap actionMap = jComponent.getActionMap();
        this.addMoveAction(inputMap, actionMap, "moveGreaterXNormalWeight", NavigationDirection.GREATER_X, MoveWeight.NORMAL, 39, 0);
        this.addMoveAction(inputMap, actionMap, "moveLesserXNormalWeight", NavigationDirection.LESSER_X, MoveWeight.NORMAL, 37, 0);
        this.addMoveAction(inputMap, actionMap, "moveGreaterYNormalWeight", NavigationDirection.GREATER_Y, MoveWeight.NORMAL, 40, 0);
        this.addMoveAction(inputMap, actionMap, "moveLesserYNormalWeight", NavigationDirection.LESSER_Y, MoveWeight.NORMAL, 38, 0);
        this.addMoveAction(inputMap, actionMap, "moveGreaterXHeavyWeight", NavigationDirection.GREATER_X, MoveWeight.HEAVY, 39, 64);
        this.addMoveAction(inputMap, actionMap, "moveLesserXHeavyWeight", NavigationDirection.LESSER_X, MoveWeight.HEAVY, 37, 64);
        this.addMoveAction(inputMap, actionMap, "moveGreaterYHeavyWeight", NavigationDirection.GREATER_Y, MoveWeight.HEAVY, 40, 64);
        this.addMoveAction(inputMap, actionMap, "moveLesserYHeavyWeight", NavigationDirection.LESSER_Y, MoveWeight.HEAVY, 38, 64);
        this.openPopupAction(inputMap, actionMap, (VisControl)jComponent, 10);
        this.closePopupAction(inputMap, actionMap, (VisControl)jComponent, 27);
        this.addFirstLastAction(inputMap, actionMap, "firstItem", 36, 0, true);
        this.addFirstLastAction(inputMap, actionMap, "lastItem", 35, 0, false);
        this.addShiftMoveAction(inputMap, actionMap, "shiftFeatureNext", FeatureShift.NEXT, false, 49, 0);
        this.addShiftMoveAction(inputMap, actionMap, "shiftFeaturePrevious", FeatureShift.PREVIOUS, false, 50, 0);
        this.addShiftMoveAction(inputMap, actionMap, "shiftPartNext", FeatureShift.NEXT, true, 32, 0);
        this.addShiftMoveAction(inputMap, actionMap, "shiftPartPrevious", FeatureShift.PREVIOUS, true, 32, 64);
        String string = "back";
        KeyStroke keyStroke = KeyStroke.getKeyStroke(51, 0);
        inputMap.put(keyStroke, string);
        BackMoveAction backMoveAction = new BackMoveAction();
        actionMap.put(string, backMoveAction);
    }

    private void addMoveAction(InputMap inputMap, ActionMap actionMap, String string, NavigationDirection navigationDirection, MoveWeight moveWeight, int n, int n2) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
        inputMap.put(keyStroke, string);
        MoveAction moveAction = new MoveAction(navigationDirection, moveWeight);
        actionMap.put(string, moveAction);
    }

    private void openPopupAction(InputMap inputMap, ActionMap actionMap, VisControl visControl, int n) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, 0);
        inputMap.put(keyStroke, KEY_ENTER);
        OpenPopUpAction openPopUpAction = new OpenPopUpAction(visControl);
        actionMap.put(KEY_ENTER, openPopUpAction);
    }

    private void closePopupAction(InputMap inputMap, ActionMap actionMap, VisControl visControl, int n) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, 0);
        inputMap.put(keyStroke, KEY_ESCAPE);
        ClosePopUpAction closePopUpAction = new ClosePopUpAction(visControl);
        actionMap.put(KEY_ESCAPE, closePopUpAction);
    }

    private void addShiftMoveAction(InputMap inputMap, ActionMap actionMap, String string, FeatureShift featureShift, boolean bl, int n, int n2) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
        inputMap.put(keyStroke, string);
        ShiftMoveAction shiftMoveAction = new ShiftMoveAction(featureShift, bl);
        actionMap.put(string, shiftMoveAction);
    }

    private void addFirstLastAction(InputMap inputMap, ActionMap actionMap, String string, int n, int n2, boolean bl) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
        inputMap.put(keyStroke, string);
        FirstLastAction firstLastAction = new FirstLastAction(bl);
        actionMap.put(string, firstLastAction);
    }

    void setDescription(SceneItem sceneItem) {
        if (this.textComponent.isVisible()) {
            this.textComponent.setText(KeyNavigationAdapter.getDescription(sceneItem));
        }
    }

    public static String getDescription(SceneItem sceneItem) {
        int n;
        double[] dArray;
        int n2;
        if (sceneItem == null) {
            return null;
        }
        String string = sceneItem.getType() + "/" + sceneItem.subType();
        int[] nArray = sceneItem.getRows();
        if (nArray != null && nArray.length > 0) {
            string = string + " ROWS [";
            int n3 = nArray.length > 3 ? 3 : nArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                string = string + nArray[n2];
                string = string + (n2 == n3 - 1 ? (nArray.length > 3 ? ",...]" : "]") : ",");
            }
        }
        if ((dArray = sceneItem.coordinates()) != null && dArray.length > 0) {
            string = string + " COORDS [";
            n2 = dArray.length > 3 ? 3 : dArray.length;
            for (n = 0; n < n2; ++n) {
                string = string + dArray[n];
                string = string + (n == n2 - 1 ? (dArray.length > 3 ? ",...]" : "]") : ",");
            }
        }
        if ((dArray = sceneItem.aestheticValues()) != null && dArray.length > 0) {
            string = string + " AESTHETICS [";
            n2 = dArray.length > 3 ? 3 : dArray.length;
            for (n = 0; n < n2; ++n) {
                string = string + dArray[n];
                string = string + (n == n2 - 1 ? (dArray.length > 3 ? ",...]" : "]") : ",");
            }
        }
        return string;
    }

    private class ClosePopUpAction
    extends AbstractAction {
        private final VisControl vc;

        public ClosePopUpAction(VisControl visControl) {
            this.vc = visControl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SceneItem sceneItem = KeyNavigationAdapter.this.navigation.move(null, null);
            Popup popup = this.vc.getInteractivity().getPopup();
            popup.hidePopup();
        }
    }

    private class OpenPopUpAction
    extends AbstractAction {
        private final VisControl vc;

        public OpenPopUpAction(VisControl visControl) {
            this.vc = visControl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SceneItem sceneItem = KeyNavigationAdapter.this.navigation.move(null, null);
            JSONObject jSONObject = KeyNavigationAdapter.this.getVisSpecForSceneItem(sceneItem);
            if (jSONObject != null) {
                Popup popup = this.vc.getInteractivity().getPopup();
                popup.showPopup(jSONObject, sceneItem, null);
            }
        }
    }

    private class MoveAction
    extends AbstractAction {
        private final NavigationDirection direction;
        private final MoveWeight weight;

        public MoveAction(NavigationDirection navigationDirection, MoveWeight moveWeight) {
            this.direction = navigationDirection;
            this.weight = moveWeight;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SceneItem sceneItem = KeyNavigationAdapter.this.navigation.move(this.direction, this.weight);
            KeyNavigationAdapter.this.setDescription(sceneItem);
        }
    }

    private class ShiftMoveAction
    extends AbstractAction {
        private final FeatureShift shift;
        private final boolean isPart;
        private String msg;

        public ShiftMoveAction(FeatureShift featureShift, boolean bl) {
            this.shift = featureShift;
            this.isPart = bl;
            this.msg = bl ? (FeatureShift.NEXT == featureShift ? "next part" : "previous part") : (FeatureShift.NEXT == featureShift ? "next feature " : "previous feature");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SceneItem sceneItem = this.isPart ? KeyNavigationAdapter.this.navigation.moveFeaturePart(this.shift) : KeyNavigationAdapter.this.navigation.nextFeature(this.shift);
            KeyNavigationAdapter.this.setDescription(sceneItem);
        }
    }

    private class BackMoveAction
    extends AbstractAction {
        private BackMoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SceneItem sceneItem = KeyNavigationAdapter.this.navigation.back();
            KeyNavigationAdapter.this.setDescription(sceneItem);
        }
    }

    private class FirstLastAction
    extends AbstractAction {
        boolean isFirst;

        FirstLastAction(boolean bl) {
            this.isFirst = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SceneItem sceneItem = null;
            if (this.isFirst) {
                sceneItem = KeyNavigationAdapter.this.navigation.firstItem();
                KeyNavigationAdapter.this.setDescription(sceneItem);
            } else {
                sceneItem = KeyNavigationAdapter.this.navigation.lastItem();
                KeyNavigationAdapter.this.setDescription(sceneItem);
            }
        }
    }
}

