/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal;

import com.ibm.vis.engine.internal.interaction.effect.DirtyNodeManager;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.VisCommand;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.internal.renderer.GraphicsRenderer;
import com.ibm.vis.internal.renderer.Renderer;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.internal.LoggerImpl;
import com.ibm.vis.ui.awt.internal.SceneRendering;
import com.ibm.vis.ui.awt.internal.render.AWTGraphicsRenderer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class MakeImageCommand
extends VisCommand {
    private final LoggerImpl logger;
    private final SceneRendering owner;
    private final Renderer renderer;
    private final Image previousImage;
    private static final boolean DEBUG = false;
    private boolean useFractionalMetrics;

    public MakeImageCommand(String string, Renderer renderer, SceneRendering sceneRendering, Image image, LoggerImpl loggerImpl, boolean bl) {
        super(null, VisCommand.Type.render, VisCommand.SubType.general, string);
        this.renderer = renderer;
        this.previousImage = image;
        this.owner = sceneRendering;
        this.logger = loggerImpl;
        this.useFractionalMetrics = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image call() throws Exception {
        Object object;
        int n;
        Dim dim = this.renderer.getRenderImageSize();
        int n2 = (int)dim.getWidth();
        int n3 = n2 * (n = (int)dim.getHeight());
        if (n3 < 0) {
            return this.showErrorDialog();
        }
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        try {
            bufferedImage = new BufferedImage(n2, n, 6);
            graphics2D = bufferedImage.createGraphics();
        }
        catch (Exception exception) {
            return this.showErrorDialog();
        }
        if (this.previousImage != null && this.previousImage.getWidth(null) == n2 && this.previousImage.getHeight(null) == n) {
            graphics2D.drawImage(this.previousImage, 0, 0, n2, n, this.owner.getComponent());
            if (this.logger != null) {
                this.logger.detail(LogComponent.AWTEngine, "Using existing image");
            }
        } else {
            object = this.owner.getDirtyNodeManager();
            if (object != null) {
                ((DirtyNodeManager)object).makeGloballyDirty();
            }
        }
        try {
            if (this.logger != null) {
                this.logger.logStartTime(LogComponent.AWTEngine, "MakeImage: Rendering Scene");
            }
            object = new AWTGraphicsRenderer(graphics2D, bufferedImage.getWidth(), bufferedImage.getHeight(), this.useFractionalMetrics);
            try {
                this.renderer.renderScene((GraphicsRenderer)object);
            }
            finally {
                ((AWTGraphicsRenderer)object).dispose();
            }
        }
        finally {
            graphics2D.dispose();
        }
        if (this.logger != null) {
            this.logger.logEndTime(LogComponent.AWTEngine, "MakeImage: Rendering Scene");
        }
        if (this.owner != null) {
            this.owner.setImage(bufferedImage);
        }
        if (this.logger != null) {
            this.logger.trace(LogComponent.AppVisBoard, "MakeImage: Returning image");
        }
        return bufferedImage;
    }

    private Image showErrorDialog() {
        JOptionPane jOptionPane = new JOptionPane("The created image is too large to display , please specify different values in the dialog.", 0);
        JDialog jDialog = jOptionPane.createDialog("Error");
        jDialog.setModal(false);
        jDialog.setVisible(true);
        return this.previousImage;
    }
}

