/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.internal.AbstractPopup;
import com.ibm.vis.interaction.internal.PopupNotchLocation;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.util.List;
import javax.swing.JPanel;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class PopupNotch
extends JPanel {
    private PopupNotchLocation location;

    public PopupNotch() {
        this.addMouseListener(new MouseAdapter(){});
    }

    public void position(Rectangle rectangle, PopupNotchLocation popupNotchLocation) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.location = popupNotchLocation;
    }

    private static Polygon makePolygon(List<Point> list) {
        Polygon polygon = new Polygon();
        for (Point point : list) {
            polygon.addPoint((int)point.getX(), (int)point.getY());
        }
        return polygon;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        List<Point> list = AbstractPopup.getNotchGeometry(new Rect(0.0, 0.0, rectangle.width, rectangle.height), this.location);
        Polygon polygon = PopupNotch.makePolygon(list);
        graphics.setClip(polygon);
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        list = AbstractPopup.getNotchGeometry(new Rect(1.0, 1.0, rectangle.width - 2, rectangle.height - 2), this.location);
        polygon = PopupNotch.makePolygon(list);
        graphics.drawPolygon(polygon);
        graphics.setColor(color);
    }
}

