/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal;

import com.ibm.vis.engine.internal.interaction.defender.ScrollUnitRenderer;
import com.ibm.vis.engine.internal.interaction.effect.DirtyNodeManager;
import com.ibm.vis.engine.internal.interaction.effect.Effect;
import com.ibm.vis.engine.internal.interaction.effect.EffectBuilder;
import com.ibm.vis.engine.internal.interaction.effect.EffectRunnable;
import com.ibm.vis.engine.internal.interaction.effect.SceneOwner;
import com.ibm.vis.engine.internal.interaction.effect.StyleEffect;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.PlatformDefaults;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.VisException;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.internal.renderer.Renderer;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.LogLevel;
import com.ibm.vis.monitor.internal.LoggerImpl;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.ui.awt.internal.EffectCommand;
import com.ibm.vis.ui.awt.internal.MakeImageCommand;
import com.ibm.vis.ui.awt.internal.VisPanel;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SceneRendering
implements SceneOwner {
    private VisPanel component;
    private Effect startEffect;
    private Map<Integer, StyleEffect> ongoingEffects;
    private ScrollUnitRenderer scrollUnitRenderer;
    private Future<Image> imageFuture;
    private Future<Boolean> startAnimationFuture;
    private SceneTree storedScene;
    private DirtyNodeManager dirtyNodeManager;
    private Image image;

    public SceneRendering(VisPanel visPanel) {
        this.component = visPanel;
        this.dirtyNodeManager = new DirtyNodeManager();
    }

    @Override
    public DirtyNodeManager getDirtyNodeManager() {
        return this.dirtyNodeManager;
    }

    @Override
    public void execute(final EffectRunnable effectRunnable) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                effectRunnable.run();
            }
        };
        this.startAnimationFuture = this.component.getExecutorService().execute(new EffectCommand("Effect", runnable, this.getLogger()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sceneEffectsChanged(int n) {
        LoggerImpl loggerImpl = this.getLogger();
        if (loggerImpl != null) {
            loggerImpl.detail(LogComponent.AWTEngine, "SceneRendering: sceneEffectsChanged");
        }
        Renderer renderer = new Renderer(this.storedScene);
        renderer.setDirtyNodeManager(this.dirtyNodeManager);
        boolean bl = n == 1 ? true : (this.getComponent() != null ? this.getComponent().getVis().getVisContext().usesFractionalMetrics() : PlatformDefaults.usesFractionalMetrics);
        MakeImageCommand makeImageCommand = new MakeImageCommand("Make Image", renderer, this, this.image, loggerImpl, bl);
        Future future = this.component.getExecutorService().execute(makeImageCommand);
        SceneRendering sceneRendering = this;
        synchronized (sceneRendering) {
            this.image = null;
            this.imageFuture = future;
        }
        try {
            if (loggerImpl != null) {
                loggerImpl.trace(LogComponent.AWTEngine, "SceneRendering: sceneEffectsChanged waitUntilRefreshed");
            }
            this.image = (Image)future.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            String string = SceneRendering.getMessage(executionException);
            if (loggerImpl != null) {
                loggerImpl.log(LogLevel.Error, LogComponent.AWTEngine, string, "exception", executionException);
            }
            if (executionException.getCause() instanceof VisException) {
                throw (VisException)executionException.getCause();
            }
            EngineException engineException = new EngineException(string, ErrorCode.EFFECTS_FAIL, null);
            engineException.initCause(executionException.getCause());
            throw engineException;
        }
    }

    private static String getMessage(Exception exception) {
        String string;
        String string2 = string = exception.getCause() != null ? exception.getCause().getMessage() : null;
        if (string == null) {
            string = "Error processing effects change";
        }
        return string;
    }

    private LoggerImpl getLogger() {
        return this.component.getLogger();
    }

    public Image getImage() {
        if (this.image != null) {
            return this.image;
        }
        try {
            if (this.imageFuture != null) {
                this.image = this.imageFuture.get();
                return this.image;
            }
        }
        catch (InterruptedException interruptedException) {
            this.image = null;
        }
        catch (CancellationException cancellationException) {
            this.image = null;
        }
        catch (ExecutionException executionException) {
            String string;
            LoggerImpl loggerImpl = this.getLogger();
            if (loggerImpl != null) {
                loggerImpl.log(LogLevel.Error, LogComponent.AWTEngine, "Error making image", "exception", executionException);
            }
            if (executionException.getCause() instanceof VisException) {
                throw (VisException)executionException.getCause();
            }
            String string2 = string = executionException.getCause() != null ? executionException.getCause().getMessage() : null;
            if (string == null) {
                string = "Error making image";
            }
            EngineException engineException = new EngineException(string, ErrorCode.RENDER_FAIL, null);
            engineException.initCause(executionException.getCause());
            throw engineException;
        }
        return this.image;
    }

    public synchronized Dim getSize() {
        return this.storedScene == null ? null : this.storedScene.getScaledSize();
    }

    public void setEffects(Map<Integer, StyleEffect> map) {
        this.ongoingEffects = map;
    }

    public final SceneTree getStoredScene() {
        return this.storedScene;
    }

    public void setScrollUnit(ScrollUnitRenderer scrollUnitRenderer) {
        this.scrollUnitRenderer = scrollUnitRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScene(SceneTree sceneTree) {
        SceneRendering sceneRendering = this;
        synchronized (sceneRendering) {
            SceneTree sceneTree2 = this.storedScene;
            this.storedScene = sceneTree;
            this.dirtyNodeManager.reset(sceneTree2 == sceneTree);
            boolean bl = this.installStartEffect(sceneTree2) && sceneTree2 != null;
            this.installMoreEffects();
            if (!bl) {
                this.sceneEffectsChanged(0);
            }
        }
    }

    public void setStartEffect(Effect effect) {
        this.startEffect = effect;
    }

    void installHighlightEffect(int n) {
        this.installHighlightEffectOnScene(this.storedScene, n);
    }

    void installHighlightEffectOnScene(SceneTree sceneTree, int n) {
        if (this.ongoingEffects != null) {
            Effect effect = this.ongoingEffects.get(n);
            EffectBuilder effectBuilder = new EffectBuilder(sceneTree, this, false, 0L);
            effect.install(effectBuilder);
        }
    }

    void installMoreEffects() {
        if (this.ongoingEffects != null) {
            Effect effect = this.ongoingEffects.get(0);
            EffectBuilder effectBuilder = effect.isAnimated() ? new EffectBuilder(this.storedScene, this, true, 100L) : new EffectBuilder(this.storedScene, this, false, 0L);
            if (this.ongoingEffects != null && this.ongoingEffects.size() > 0) {
                for (Effect effect2 : this.ongoingEffects.values()) {
                    effect2.install(effectBuilder);
                }
            }
            effectBuilder.start();
        }
        if (this.scrollUnitRenderer != null) {
            this.scrollUnitRenderer.install(new EffectBuilder(this.storedScene, this, true, 1L), this.component.getVis());
        }
    }

    private boolean installStartEffect(SceneTree sceneTree) {
        if (this.startEffect != null && !this.component.getVis().getVisContext().isUpdateViewport()) {
            EffectBuilder effectBuilder = new EffectBuilder(this.storedScene, this, this.startEffect.isAnimated(), this.startEffect.getTime());
            this.startEffect.installWithPrevious(effectBuilder, sceneTree);
            effectBuilder.start();
            return true;
        }
        return false;
    }

    public void waitForStartAnimationCompletion() {
        if (this.startAnimationFuture != null) {
            try {
                this.startAnimationFuture.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        this.component = null;
        this.storedScene = null;
    }

    @Override
    public boolean isInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            return true;
        }
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        return false;
    }

    public VisPanel getComponent() {
        return this.component;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        if (this.component != null && bufferedImage != null) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            if (n > 5 && n2 > 5) {
                Dimension dimension = this.component.getSize();
                if (dimension.width != n || dimension.height != n2) {
                    SwingUtilities.invokeLater(new ComponentResizer(this.component, n, n2));
                }
            }
        }
        if (this.component != null) {
            this.component.repaint();
        }
    }

    private static class ComponentResizer
    implements Runnable {
        VisPanel component;
        int width;
        int height;

        ComponentResizer(VisPanel visPanel, int n, int n2) {
            this.component = visPanel;
            this.width = n;
            this.height = n2;
        }

        @Override
        public void run() {
            this.component.setSize(this.width, this.height);
        }
    }
}

