/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.vis.engine.internal.interaction.effect.Effect;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.EventCoordinateHelper;
import com.ibm.vis.engine.internal.nativeImpl.ThreadHelper;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.interaction.Popup;
import com.ibm.vis.interaction.SceneItem;
import com.ibm.vis.interaction.events.DefenderInteractivityListener;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.InteractivityWrapper;
import com.ibm.vis.interaction.internal.events.EventDispatcher;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.ui.awt.VisControl;
import com.ibm.vis.ui.awt.internal.SceneRendering;
import com.ibm.vis.ui.awt.internal.VisPopup;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class VisControlInteractivity
extends InteractivityImpl {
    private final VisControl control;
    private final SceneRendering rendering;
    private Popup popup;
    private final ThreadHelper threadHelper;

    public VisControlInteractivity(VisControl visControl, SceneRendering sceneRendering, EventDispatcher eventDispatcher, ThreadHelper threadHelper) {
        super(visControl.getVis(), new EventCoordinateHelper(), eventDispatcher, null, sceneRendering.getDirtyNodeManager());
        this.control = visControl;
        this.rendering = sceneRendering;
        this.threadHelper = threadHelper;
        this.control.getRendering().setEffects(this.highlightEffect);
        visControl.getRendering().setScrollUnit(this.scrollUnitRenderer);
        this.addInteractivityListener(new DefenderInteractivityListener());
    }

    public void reset() {
    }

    public void setStartAnimation(Effect effect) {
        this.control.getRendering().setStartEffect(effect);
    }

    @Override
    public void installHighlightEffectOnScene(SceneTree sceneTree, int n) {
        this.rendering.installHighlightEffectOnScene(sceneTree, n);
    }

    @Override
    public void installHighlightEffect(int n) {
        this.installHighlightEffectOnScene(this.getSceneState().getSceneTree(), n);
    }

    @Override
    public void installMoreEffects() {
        this.rendering.installMoreEffects();
    }

    @Override
    public void rendererShowHighlights(SceneItem[] sceneItemArray) {
        this.rendering.sceneEffectsChanged(2);
    }

    @Override
    public void rendererRedrawSceneTree() {
        this.rendering.getDirtyNodeManager().makeGloballyDirty();
        this.rendering.sceneEffectsChanged(0);
    }

    @Override
    public Dim getCanvasDimensions() {
        return new Dim(this.control.getWidth(), this.control.getHeight());
    }

    @Override
    @Deprecated
    public void setScene(JSONArray jSONArray) {
    }

    public void setScene(SceneTree sceneTree) {
    }

    @Override
    public void executeInteractivity(InteractivityWrapper interactivityWrapper) {
        this.threadHelper.executeInteractivity(interactivityWrapper);
    }

    @Override
    @Deprecated
    public JSONArray getScene() {
        return this.control.getScene();
    }

    @Override
    public Popup getPopup() {
        if (this.popup == null) {
            this.popup = new VisPopup(this.control);
        }
        return this.popup;
    }

    @Override
    public void setSceneTree(SceneTree sceneTree) {
        this.control.getRendering().getDirtyNodeManager().makeGloballyDirty();
        this.control.setSceneTree(sceneTree);
    }
}

