/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.VisCommandExecutor;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.internal.LoggerImpl;
import com.ibm.vis.ui.awt.VisControl;
import com.ibm.vis.ui.awt.internal.SceneRendering;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class VisPanel
extends JPanel {
    private final VisControl control;
    private final SceneRendering rendering;

    public VisPanel(VisControl visControl, String string) {
        this.setName(string);
        this.rendering = new SceneRendering(this);
        this.setOpaque(false);
        this.control = visControl;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.renderImage(graphics, this.makeImage());
    }

    public final SceneRendering getRendering() {
        return this.rendering;
    }

    public boolean usesFractionalMetrics() {
        return this.control.usesFractionalMetrics();
    }

    public Image makeImage() {
        return this.getRendering().getImage();
    }

    public void setCurrentImage(Image image) {
        if (this.getLogger() != null) {
            this.getLogger().trace(LogComponent.AppVisBoard, "VisControl: Setting Image");
        }
        this.repaint();
    }

    protected void renderImage(Graphics graphics, Image image) {
        if (image != null) {
            if (this.getLogger() != null) {
                this.getLogger().detail(LogComponent.AppVisBoard, "VisControl: Rendering Image");
            }
            graphics.drawImage(this.makeImage(), 0, 0, this);
        }
    }

    public void dispose() {
        this.rendering.dispose();
    }

    public Vis getVis() {
        return this.control.getVis();
    }

    public final VisCommandExecutor getExecutorService() {
        return this.control.getExecutorService();
    }

    LoggerImpl getLogger() {
        return (LoggerImpl)this.control.getLogger();
    }
}

