/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.interaction.internal.AbstractPopup;
import com.ibm.vis.interaction.internal.InteractivityImpl;
import com.ibm.vis.interaction.internal.PopupNotchLocation;
import com.ibm.vis.ui.awt.VisControl;
import com.ibm.vis.ui.awt.internal.PopupNotch;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class VisPopup
extends AbstractPopup {
    private final VisControl parentControl;
    private JPanel panel;
    private JPanel notchPanel;
    private PopupNotch notch;
    private JScrollPane popUpVisControlPane;
    private final VisControl popupVisControl;

    public VisPopup(VisControl visControl) {
        super(visControl);
        this.parentControl = visControl;
        this.popupVisControl = this.makePopupVisControl();
        this.initPopupPanel();
        this.parentControl.add((Component)this.panel, JLayeredPane.POPUP_LAYER);
        this.parentControl.setLayout(null);
        this.parentControl.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JLayeredPane jLayeredPane = (JLayeredPane)focusEvent.getSource();
                jLayeredPane.setBackground(Color.green);
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JLayeredPane jLayeredPane = (JLayeredPane)focusEvent.getSource();
                jLayeredPane.setBackground(Color.blue);
            }
        });
    }

    @Override
    public void show(JSONObject jSONObject) {
        this.hidePopupPanel();
        this.popupVisControl.setSpecificationWithTransition(jSONObject, -1);
        this.layoutPopupPanel();
        this.showPopupPanel();
    }

    private void showPopupPanel() {
        this.panel.setVisible(true);
        this.popupVisControl.requestFocus();
    }

    @Override
    public void hide() {
        this.hidePopupPanel();
    }

    private void hidePopupPanel() {
        this.panel.setVisible(false);
        this.parentControl.requestFocus();
    }

    private void layoutPopupPanel() {
        Rect rect = this.getPopupBounds();
        this.panel.setBounds(VisPopup.makeRectangle(rect));
        PopupNotchLocation popupNotchLocation = this.getPopupNotchLocation(rect);
        Rect rect2 = VisPopup.getNotchPanelBounds(rect, popupNotchLocation);
        this.notchPanel.setBounds(VisPopup.makeRectangle(rect2));
        Rect rect3 = VisPopup.getNotchBounds(rect2, popupNotchLocation);
        this.notch.position(VisPopup.makeRectangle(rect3), popupNotchLocation);
        Rect rect4 = VisPopup.getPopupVisControlBounds(rect, popupNotchLocation);
        this.popUpVisControlPane.setBounds(VisPopup.makeRectangle(rect4));
        this.popUpVisControlPane.getViewport().removeAll();
        this.popUpVisControlPane.getViewport().add(this.popupVisControl);
        this.popupVisControl.setSize((int)rect4.getWidth(), (int)rect4.getHeight());
    }

    @Override
    protected VisControl getPopupVisControl() {
        return this.popupVisControl;
    }

    private void initPopupPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(null);
        this.panel.setOpaque(false);
        this.notchPanel = new JPanel();
        this.notchPanel.setLayout(null);
        this.notchPanel.setOpaque(false);
        this.notch = new PopupNotch();
        this.notchPanel.add(this.notch);
        this.notch.setBackground(Color.WHITE);
        this.panel.add(this.notchPanel);
        this.popUpVisControlPane = new JScrollPane();
        this.popUpVisControlPane.setBackground(Color.WHITE);
        this.popUpVisControlPane.setBorder(new BevelBorder(0, Color.BLACK, Color.BLACK));
        this.popUpVisControlPane.setVerticalScrollBarPolicy(20);
        this.popUpVisControlPane.setHorizontalScrollBarPolicy(30);
        this.panel.add(this.popUpVisControlPane);
    }

    private static Rectangle makeRectangle(Rect rect) {
        return new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
    }

    protected VisControl makePopupVisControl() {
        VisControl visControl = new VisControl(null, "popupVisControl");
        visControl.copyConfigurationFrom(this.parentControl);
        visControl.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                VisPopup.this.showPopupPanel();
            }
        });
        visControl.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    VisPopup.this.hidePopupPanel();
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        return visControl;
    }

    @Override
    protected Dim getPopupVisSize() {
        Vis vis = null;
        InteractivityImpl interactivityImpl = (InteractivityImpl)this.getPopupVisControl().getInteractivity();
        if (interactivityImpl != null) {
            vis = interactivityImpl.getVisInstance();
        }
        if (vis != null) {
            return vis.getSize();
        }
        return new Dim(0.0, 0.0);
    }
}

