/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.fontMaker;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.template.JSONSerialization;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class MakeFontInfo {
    private static final float SAMPLE_SIZE = 12.0f;
    private static final HashMap<String, String> FONTS = new HashMap();
    private static FontRenderContext FRC;

    private static boolean aggregated(JSONArray jSONArray) {
        for (int i = 0; i < jSONArray.size(); ++i) {
            for (int j = i + 1; j < jSONArray.size(); ++j) {
                JSONObject jSONObject;
                JSONObject jSONObject2 = (JSONObject)jSONArray.get(i);
                if (!MakeFontInfo.same(jSONObject2, jSONObject = (JSONObject)jSONArray.get(j))) continue;
                String string = (String)jSONObject2.get((Object)"n");
                String string2 = (String)jSONObject.get((Object)"n");
                jSONObject2.put((Object)"n", (Object)(string + "," + string2));
                System.out.println(string + " = " + string2);
                jSONArray.remove(j);
                return true;
            }
        }
        return false;
    }

    private static boolean same(JSONObject jSONObject, JSONObject jSONObject2) {
        if (!jSONObject.get((Object)"w").equals(jSONObject2.get((Object)"w"))) {
            return false;
        }
        if (!jSONObject.get((Object)"h").equals(jSONObject2.get((Object)"h"))) {
            return false;
        }
        if (!jSONObject.get((Object)"a").equals(jSONObject2.get((Object)"a"))) {
            return false;
        }
        if (!jSONObject.get((Object)"b").equals(jSONObject2.get((Object)"b"))) {
            return false;
        }
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"c");
        JSONArray jSONArray2 = (JSONArray)jSONObject2.get((Object)"c");
        JSONSerialization jSONSerialization = JSONSerialization.forJSONComparison();
        return jSONSerialization.serialize(jSONArray).equals(jSONSerialization.serialize(jSONArray2));
    }

    public static JSONArray createPagesArray() {
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < 256; ++i) {
            jSONArray.add((Object)0);
        }
        return jSONArray;
    }

    public static JSONArray createDetailPage() {
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i <= 256; ++i) {
            jSONArray.add((Object)0);
        }
        return jSONArray;
    }

    private static JSONObject getMetrics(Font font) {
        Font font2 = font.deriveFont(12.0f);
        Font font3 = font.deriveFont(1, 12.0f);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        String string = MakeFontInfo.availableCharacters(font2);
        int n = string.length();
        System.out.println(font2.getFamily() + ": " + n + " characters");
        JSONArray jSONArray = MakeFontInfo.createPagesArray();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            JSONArray jSONArray2;
            String string2 = string.substring(i, i + 1);
            int n3 = string2.charAt(0) >> 8;
            int n4 = string2.charAt(0) % 256 + 1;
            Object object = jSONArray.get(n3);
            if (Number.class.isAssignableFrom(object.getClass())) {
                jSONArray2 = MakeFontInfo.createDetailPage();
                jSONArray.set(n3, (Object)jSONArray2);
            } else {
                jSONArray2 = (JSONArray)object;
            }
            try {
                Rectangle2D rectangle2D = font2.getStringBounds(string2, FRC);
                Rectangle2D rectangle2D2 = font3.getStringBounds(string2, FRC);
                d += rectangle2D.getY();
                d2 += rectangle2D.getWidth();
                d3 += rectangle2D2.getWidth();
                d4 += rectangle2D.getHeight();
                jSONArray2.set(n4, (Object)(MakeFontInfo.rr(rectangle2D.getWidth()) + 2));
                continue;
            }
            catch (Exception exception) {
                ++n2;
                System.out.println("ERROR: Unknown exception while trying to measure character " + i);
                jSONArray2.set(n4, (Object)1);
            }
        }
        double d5 = MakeFontInfo.optimizeMetrics(string, jSONArray);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"c", (Object)jSONArray);
        jSONObject.put((Object)"w", (Object)((int)d5));
        jSONObject.put((Object)"h", (Object)MakeFontInfo.rr(d4 / (double)(n -= n2)));
        jSONObject.put((Object)"a", (Object)MakeFontInfo.rr(-d / (double)n));
        jSONObject.put((Object)"b", (Object)MakeFontInfo.rr2(d3 / d2));
        return jSONObject;
    }

    private static boolean hasCode(Font font, int n) {
        return !MakeFontInfo.isControlCode(n) && font.canDisplay((char)n);
    }

    private static boolean isControlCode(int n) {
        return n < 32 || n >= 8232 && n <= 8239 || n == 33331 || n == 133;
    }

    private static String availableCharacters(Font font) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 65535;
        for (int i = n3; i <= n4; ++i) {
            if (!MakeFontInfo.hasCode(font, i)) continue;
            ++n;
            n2 = i;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = n3; i <= n2; ++i) {
            if (!MakeFontInfo.hasCode(font, i)) continue;
            stringBuffer.append((char)i);
        }
        return stringBuffer.toString();
    }

    private static void compressRun(int n, int n2, int n3, JSONArray jSONArray, WidthStats widthStats) {
        block4: {
            block5: {
                block3: {
                    if (n != 0 || n2 <= 1) break block3;
                    ++widthStats.runsNoChar;
                    widthStats.inRunNoChar += n2;
                    jSONArray.set(n3 + 1, (Object)(-(n2 - 1)));
                    while (n2-- > 1) {
                        jSONArray.remove(n3 + 2);
                    }
                    break block4;
                }
                if (n2 <= 2 || n != widthStats.topWidth) break block5;
                ++widthStats.runsDefault;
                widthStats.inRunDefault += n2;
                JSONArray jSONArray2 = new JSONArray();
                jSONArray2.add((Object)(n2 - 3));
                jSONArray.set(n3 + 1, (Object)jSONArray2);
                while (n2-- > 1) {
                    jSONArray.remove(n3 + 2);
                }
                break block4;
            }
            if (n2 <= 2) break block4;
            ++widthStats.runsNormal;
            widthStats.inRunNormal += n2;
            JSONArray jSONArray3 = new JSONArray();
            jSONArray3.add((Object)(n2 - 3));
            jSONArray3.add((Object)n);
            jSONArray.set(n3 + 1, (Object)jSONArray3);
            while (n2-- > 1) {
                jSONArray.remove(n3 + 2);
            }
        }
    }

    private static void optimizePage(int n, JSONArray jSONArray, WidthStats[] widthStatsArray, WidthStats widthStats) {
        WidthStats widthStats2 = widthStatsArray[n];
        if (widthStats2.top == 256) {
            if (widthStats2.topWidth == widthStats.topWidth) {
                jSONArray.set(n, (Object)1);
            } else {
                jSONArray.set(n, (Object)widthStats2.topWidth);
            }
        } else {
            JSONArray jSONArray2 = (JSONArray)jSONArray.get(n);
            jSONArray2.set(0, (Object)widthStats2.topWidth);
            int n2 = -1;
            int n3 = -1;
            for (int i = 256; i > 0; --i) {
                int n4 = (Integer)jSONArray2.get(i);
                if (n4 == 0 && jSONArray2.size() == i + 1) {
                    jSONArray2.remove(i);
                    continue;
                }
                if (n4 == widthStats2.topWidth) {
                    jSONArray2.set(i, (Object)1);
                }
                if (n3 != n4) {
                    MakeFontInfo.compressRun(n3, n2, i, jSONArray2, widthStatsArray[n]);
                    n2 = 1;
                    n3 = n4;
                    continue;
                }
                ++n2;
            }
            MakeFontInfo.compressRun(n3, n2, 0, jSONArray2, widthStatsArray[n]);
        }
    }

    private static boolean isSimplePage(Object object) {
        return Number.class.isAssignableFrom(object.getClass());
    }

    private static double optimizeMetrics(String string, JSONArray jSONArray) {
        int n;
        WidthStats[] widthStatsArray = new WidthStats[256];
        WidthStats widthStats = new WidthStats();
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            int n2 = c >> 8;
            int n3 = ((Number)((JSONArray)jSONArray.get(n2)).get(c % 256 + 1)).intValue();
            widthStats.add(n3);
            WidthStats widthStats2 = widthStatsArray[n2];
            if (widthStats2 == null) {
                widthStats2 = widthStatsArray[n2] = new WidthStats();
            }
            widthStats2.add(n3);
        }
        widthStats.computeStats();
        for (n = 0; n < 256; ++n) {
            Object object = jSONArray.get(n);
            if (object == null || MakeFontInfo.isSimplePage(object)) continue;
            MakeFontInfo.optimizePage(n, jSONArray, widthStatsArray, widthStats);
        }
        while (jSONArray.size() > 0 && MakeFontInfo.isSimplePage(jSONArray.get(jSONArray.size() - 1)) && ((Number)jSONArray.get(jSONArray.size() - 1)).intValue() == 0) {
            jSONArray.remove(jSONArray.size() - 1);
        }
        n = 2;
        for (int i = 0; i < 256; ++i) {
            WidthStats widthStats3 = widthStatsArray[i];
            if (widthStats3 == null || widthStats3.count <= 0) continue;
            widthStats3.computeStats();
            StringBuilder stringBuilder = new StringBuilder();
            if (widthStats3.top == 256) {
                stringBuilder.append(String.format("  0x%02x", i));
                stringBuilder.append(String.format("  #%3d", widthStats3.count));
                stringBuilder.append(String.format("  e:%3d", (int)widthStats3.mean - n));
                stringBuilder.append(String.format("  full single-width page", new Object[0]));
            } else {
                stringBuilder.append(String.format("  0x%02x", i));
                stringBuilder.append(String.format("  #%3d", widthStats3.count));
                stringBuilder.append(String.format("  e:%3d", (int)widthStats3.mean - n));
                stringBuilder.append(String.format("  d:%3d", (int)widthStats3.var));
                stringBuilder.append(String.format("  m:%3d", widthStats3.min - n));
                stringBuilder.append(String.format("  M:%3d", widthStats3.max - n));
                stringBuilder.append(String.format("  top:%3d", widthStats3.top));
                stringBuilder.append(String.format("  topW:%3d", widthStats3.topWidth - n));
                stringBuilder.append(String.format("  runs(no,def,*):(%3d#%2d,%3d#%2d,%3d#%2d)", widthStats3.inRunNoChar, widthStats3.runsNoChar, widthStats3.inRunDefault, widthStats3.runsDefault, widthStats3.inRunNormal, widthStats3.runsNormal));
            }
            System.out.println(stringBuilder.toString());
        }
        return widthStats.topWidth;
    }

    private static int rr(double d) {
        return (int)Math.round(100.0 * d / 12.0);
    }

    private static Number rr2(double d) {
        return (int)Math.round(100.0 * d);
    }

    public static void main(String[] stringArray) throws IOException {
        String[] stringArray2 = new String[]{"andale mono", "andale wt", "arial black", "arial", "bookman old style", "century", "century gothic", "century schoolbook", "comic sans ms", "cordiaupc", "courier new", "courier", "garamond", "georgia", "gulim", "gulimche", "helvetica", "impact", "miriam", "miriam fixed", "miriam transparent", "microsoft sans serif", "ms gothic", "ms mincho", "ms pgothic", "ms pmincho", "ms ui gothic", "nsimsun", "nsimsun-18030", "papyrus", "pmingliu", "serif", "simhei", "simsun", "simsun-18030", "symbol", "tahoma", "times", "times new roman", "trebuchet ms", "verdana", "webdings"};
        JSONArray jSONArray = new JSONArray();
        FRC = new FontRenderContext(null, true, true);
        for (String object2 : stringArray2) {
            String string = FONTS.get(object2.toLowerCase().trim());
            if (string != null) {
                Font font = new Font(object2, 0, 12);
                JSONObject jSONObject = MakeFontInfo.getMetrics(font);
                jSONObject.put((Object)"n", (Object)object2.toLowerCase());
                jSONArray.add((Object)jSONObject);
                continue;
            }
            System.out.println("ERROR: " + object2 + " does not seem to be installed on this system.");
        }
        while (MakeFontInfo.aggregated(jSONArray)) {
        }
        Object object3 = JSONSerialization.forJSONComparison().serialize(jSONArray);
        object3 = ((String)object3).replaceAll("\"\\\\\":", "\"\\\\\\\\\":");
        object3 = ((String)object3).replaceAll(": ", ":");
        object3 = ((String)object3).replaceAll(", ", ",");
        object3 = ((String)object3).replaceAll("\\[ ", "\\[");
        object3 = ((String)object3).replaceAll(" \\]", "\\]");
        System.out.println("SIZE = " + ((String)object3).length());
        System.out.println((String)object3);
        File file = new File("../UCCommonEngine/java/src/com/ibm/vis/engine/internal/nativeImpl/metrics.json");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(((String)object3).getBytes("us-ascii"));
        fileOutputStream.close();
        File file2 = new File("../UCWebEngine/WebContent/js/native/com/ibm/vis/engine/internal/nativeImpl/PrecomputedFontMetrics.js");
        fileOutputStream = new FileOutputStream(file2);
        fileOutputStream.write("/************************************************************************\r\n** IBM Confidential\r\n**\r\n** OCO Source Materials\r\n**\r\n** IBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n**\r\n** (C) Copyright IBM Corp. 2011,2013\r\n**\r\n** The source code for this program is not published or otherwise divested of its trade secrets,\r\n** irrespective of what has been deposited with the U.S. Copyright Office.\r\n************************************************************************/\r\n\r\n".getBytes("us-ascii"));
        fileOutputStream.write("define([\"dojo/has\",\"exports\"],function(has,exports) {\r\n\r\n\thas.add(\"rave-precomputed-metrics\",1);\r\n\r\n\texports.FONTMETRICS =".getBytes("us-ascii"));
        fileOutputStream.write(((String)object3).getBytes("us-ascii"));
        fileOutputStream.write(";\r\n});\r\n".getBytes("us-ascii"));
        fileOutputStream.close();
    }

    static {
        for (String string : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            FONTS.put(string.toLowerCase(), string);
        }
        FRC = null;
    }

    private static class WidthStats {
        Map<Integer, Integer> data = new HashMap<Integer, Integer>();
        public int top = -1;
        public int topWidth = -1;
        public int max = -1;
        public int min = 1000;
        public double mean = 0.0;
        public double var = 0.0;
        public int count = 0;
        public int runsNoChar = 0;
        public int runsDefault = 0;
        public int runsNormal = 0;
        public int inRunNoChar = 0;
        public int inRunDefault = 0;
        public int inRunNormal = 0;

        private WidthStats() {
        }

        public void add(Integer n) {
            ++this.count;
            this.max = Math.max(this.max, n);
            this.min = Math.min(this.min, n);
            Integer n2 = this.data.get(n);
            if (n2 == null) {
                n2 = 0;
            }
            this.data.put(n, n2 + 1);
            if (n2 + 1 > this.top) {
                this.top = n2 + 1;
                this.topWidth = n;
            }
        }

        public void computeStats() {
            int n;
            int n2;
            if (this.count == 0) {
                return;
            }
            this.mean = 0.0;
            for (Map.Entry<Integer, Integer> entry : this.data.entrySet()) {
                n2 = entry.getKey();
                n = entry.getValue();
                this.mean += (double)(n * n2);
            }
            this.mean /= (double)this.count;
            this.var = 0.0;
            for (Map.Entry<Integer, Integer> entry : this.data.entrySet()) {
                n2 = entry.getKey();
                n = entry.getValue();
                this.var += (double)n * ((double)n2 - this.mean) * ((double)n2 - this.mean);
            }
            this.var = Math.sqrt(this.var);
        }
    }
}

