/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.monitor;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.LogLevel;
import com.ibm.vis.monitor.internal.LoggerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class VisboardTiming
extends LoggerImpl {
    private static final double TIMING_FACTOR = 1000000.0;
    private Map<String, TimingDetail> times = new HashMap<String, TimingDetail>();

    public void resetTimingData() {
        this.times.clear();
    }

    public void logSystemInfo(LogComponent logComponent) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("OS Name", System.getProperty("os.name"));
        hashMap.put("OS Version", System.getProperty("os.version"));
        hashMap.put("Architecture", System.getProperty("os.arch"));
        hashMap.put("JVM Version", System.getProperty("java.runtime.version"));
        hashMap.put("JVM Spec", System.getProperty("java.specification.version"));
        hashMap.put("JVM Vendor", System.getProperty("java.vm.vendor"));
        hashMap.put("Processors", Runtime.getRuntime().availableProcessors());
        hashMap.put("JVM  Max Memory (MB)", Runtime.getRuntime().maxMemory() / 0x100000L);
        this.logParam(LogLevel.Info, logComponent, "JVM and System Info", hashMap);
    }

    @Override
    public void logParam(LogLevel logLevel, LogComponent logComponent, String string, HashMap<String, Object> hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        hashMap.put("thread", Thread.currentThread().getName());
        super.logParam(logLevel, logComponent, string, hashMap);
    }

    @Override
    public void logStartTime(LogComponent logComponent, String string) {
        TimingDetail timingDetail = this.times.get(string);
        if (timingDetail == null) {
            timingDetail = new TimingDetail();
            this.times.put(string, timingDetail);
        }
        timingDetail.startTime = System.nanoTime();
    }

    @Override
    public void logEndTime(LogComponent logComponent, String string) {
        TimingDetail timingDetail = this.times.get(string);
        if (timingDetail == null) {
            this.log(LogLevel.Warning, logComponent, "End Timing -- failed; no matching start call", "target", string);
        } else {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            timingDetail.finishTiming(hashMap);
            this.logParam(LogLevel.Detail, logComponent, string + " Timing", hashMap);
        }
    }

    private final class TimingDetail {
        private long startTime;
        private long endTime;
        private List<Double> times = new ArrayList<Double>();

        private TimingDetail() {
        }

        public synchronized void finishTiming(HashMap<String, Object> hashMap) {
            this.endTime = System.nanoTime();
            double d = (double)(this.endTime - this.startTime) / 1000000.0;
            this.times.add(d);
            Collections.sort(this.times);
            int n = this.times.size();
            double d2 = this.times.get(0);
            double d3 = (this.times.get(n / 2) + this.times.get((n - 1) / 2)) / 2.0;
            double d4 = this.times.get(n - 1);
            hashMap.put("elapsed", d);
            hashMap.put("min/median/max", new double[]{d2, d3, d4});
            hashMap.put("unit", "ms");
        }
    }
}

