/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.render;

import com.ibm.vis.engine.internal.RenderEffect;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.scenetree.internal.SceneNodeRenderInfo;
import com.ibm.vis.ui.awt.internal.render.AWTConverter;
import com.ibm.vis.ui.awt.internal.render.GraphicsUtil;
import com.ibm.vis.ui.awt.internal.render.TextShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AWTBlurEffectRenderer {
    private final Graphics2D g;
    private final RenderEffect effect;
    private final boolean isShadow;

    AWTBlurEffectRenderer(Graphics2D graphics2D, RenderEffect renderEffect, boolean bl) {
        this.g = graphics2D;
        this.effect = renderEffect;
        this.isShadow = bl;
    }

    void render(Shape shape, SceneNodeRenderInfo sceneNodeRenderInfo) {
        int n;
        int n2;
        int n3;
        Color color = AWTConverter.getColor(this.effect.getColor());
        Rectangle rectangle = shape.getBounds();
        if (this.isShadow) {
            n3 = (int)Math.round(this.effect.getStdDev());
            n2 = (int)((double)rectangle.x + this.effect.getDX() - (double)(3 * n3));
            n = (int)((double)rectangle.y + this.effect.getDY() - (double)(3 * n3));
        } else {
            n3 = (int)Math.round(this.effect.getStdDev());
            n2 = rectangle.x - 3 * n3;
            n = rectangle.y - 3 * n3;
        }
        BufferedImage bufferedImage = this.blur(shape, sceneNodeRenderInfo, n3, color);
        this.g.drawImage(bufferedImage, null, n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage blur(Shape shape, SceneNodeRenderInfo sceneNodeRenderInfo, int n, Color color) {
        Graphics2D graphics2D = null;
        Rectangle rectangle = shape.getBounds();
        int n2 = rectangle.height;
        int n3 = rectangle.width;
        boolean bl = shape instanceof TextShape;
        int n4 = n2 + 6 * n;
        int n5 = n3 + 6 * n;
        BufferedImage bufferedImage = new BufferedImage(n5, n4, 2);
        graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.setRenderingHints(this.g.getRenderingHints());
            graphics2D.translate(-rectangle.x + 3 * n, -rectangle.y + 3 * n);
            Paint paint = AWTConverter.getFill(sceneNodeRenderInfo.getRenderFill());
            if (paint != null) {
                graphics2D.setPaint(paint);
                if (bl) {
                    ((TextShape)shape).render(graphics2D);
                } else {
                    graphics2D.fill(shape);
                }
            }
            if (!bl) {
                Stroke stroke = AWTConverter.getStroke(sceneNodeRenderInfo.getRenderStroke());
                Color color2 = AWTConverter.getStrokeColor(sceneNodeRenderInfo.getRenderStroke());
                if (stroke != null && color2 != null) {
                    graphics2D.setStroke(stroke);
                    graphics2D.setColor(color2);
                    graphics2D.draw(shape);
                }
            }
        }
        finally {
            graphics2D.dispose();
        }
        int n6 = 0;
        int n7 = 0;
        if (color != null) {
            int n8 = color.getRGB();
            double d = (double)GraphicsUtil.getAlpha(n8) / 255.0;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n5; ++j) {
                    n6 = bufferedImage.getRGB(j, i);
                    n7 = GraphicsUtil.getAlpha(n6);
                    n7 = (int)Math.round((double)n7 * d);
                    bufferedImage.setRGB(j, i, GraphicsUtil.updateAlpha(n7, n8));
                }
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n5; ++j) {
                    n6 = bufferedImage.getRGB(j, i);
                    n7 = GraphicsUtil.getAlpha(n6);
                    bufferedImage.setRGB(j, i, GraphicsUtil.rgb(n7, 0, 0, 0));
                }
            }
        }
        GraphicsUtil.gaussianBlurBufferedImage(bufferedImage, n);
        return bufferedImage;
    }
}

