/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.render;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.ColorNew;
import com.ibm.vis.engine.internal.GradientPaintInfo;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.FontUtil;
import com.ibm.vis.geom.BasicGeom;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.CompositeGeom;
import com.ibm.vis.geom.Curve;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.internal.renderer.Dashing;
import com.ibm.vis.scenetree.provisional.FontInfo;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;
import com.ibm.vis.ui.awt.internal.render.LinearGradient;
import com.ibm.vis.ui.awt.internal.render.RadialGradient;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class AWTConverter {
    AWTConverter() {
    }

    static Shape getShape(Geom geom) {
        if (geom == null) {
            return null;
        }
        if (geom.type() == 1007) {
            return AWTConverter.makeCompositeShape((CompositeGeom)geom);
        }
        if (geom.type() == 1000) {
            Line line = (Line)geom;
            if (line.getX1() != line.getX2() || line.getY1() != line.getY2()) {
                return new Line2D.Double(line.getX1(), line.getY1(), line.getX2(), line.getY2());
            }
            return null;
        }
        if (geom.type() == 1002) {
            Rect rect = (Rect)geom;
            return new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        }
        if (geom.type() == 1001) {
            Circle circle = (Circle)geom;
            double d = circle.getX();
            double d2 = circle.getY();
            double d3 = circle.getR();
            return new Ellipse2D.Double(d - d3, d2 - d3, 2.0 * d3, 2.0 * d3);
        }
        if (geom.type() == 1003) {
            GeneralPath generalPath = new GeneralPath();
            AWTConverter.addPolyPath(generalPath, (Poly)geom);
            return generalPath;
        }
        if (geom.type() == 1004) {
            GeneralPath generalPath = new GeneralPath();
            AWTConverter.addCurvePath(generalPath, (Curve)geom);
            return generalPath;
        }
        return null;
    }

    private static Shape makeCompositeShape(CompositeGeom compositeGeom) {
        Geom[] geomArray = compositeGeom.getParts();
        if (geomArray == null) {
            return null;
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(compositeGeom.getOddEven() ? 0 : 1);
        for (Geom geom : geomArray) {
            BasicGeom basicGeom;
            if (geom.type() == 1000) {
                basicGeom = (Line)geom;
                if (((Line)basicGeom).getX1() == ((Line)basicGeom).getX2() && ((Line)basicGeom).getY1() == ((Line)basicGeom).getY2()) continue;
                generalPath.moveTo(((Line)basicGeom).getX1(), ((Line)basicGeom).getY1());
                generalPath.lineTo(((Line)basicGeom).getX2(), ((Line)basicGeom).getY2());
                continue;
            }
            if (geom.type() == 1002) {
                basicGeom = (Rect)geom;
                generalPath.moveTo(((Rect)basicGeom).getX(), ((Rect)basicGeom).getY());
                generalPath.lineTo(((Rect)basicGeom).getX(), ((Rect)basicGeom).getY2());
                generalPath.lineTo(((Rect)basicGeom).getX2(), ((Rect)basicGeom).getY2());
                generalPath.lineTo(((Rect)basicGeom).getX2(), ((Rect)basicGeom).getY());
                generalPath.closePath();
                continue;
            }
            if (geom.type() == 1001) {
                basicGeom = (Circle)geom;
                Curve curve = Curve.makeFromCircle((Circle)basicGeom);
                AWTConverter.addCurvePath(generalPath, curve);
                continue;
            }
            if (geom.type() == 1003) {
                AWTConverter.addPolyPath(generalPath, (Poly)geom);
                continue;
            }
            if (geom.type() != 1004) continue;
            AWTConverter.addCurvePath(generalPath, (Curve)geom);
        }
        return generalPath;
    }

    private static void addPolyPath(GeneralPath generalPath, Poly poly) {
        double[] dArray = poly.getX();
        if (dArray.length < 1) {
            return;
        }
        double[] dArray2 = poly.getY();
        generalPath.moveTo(dArray[0], dArray2[0]);
        double d = dArray[0];
        double d2 = dArray2[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (d == dArray[i] && d2 == dArray2[i]) continue;
            generalPath.lineTo(dArray[i], dArray2[i]);
            d = dArray[i];
            d2 = dArray2[i];
        }
        if (poly.filled()) {
            generalPath.closePath();
        }
    }

    private static void addCurvePath(GeneralPath generalPath, Curve curve) {
        double[] dArray = curve.getX();
        if (dArray.length < 1) {
            return;
        }
        double[] dArray2 = curve.getY();
        boolean[] blArray = curve.getControls();
        generalPath.moveTo(dArray[0], dArray2[0]);
        double d = dArray[0];
        double d2 = dArray2[0];
        int n = 1;
        while (n < dArray.length) {
            if (!blArray[n]) {
                if (d != dArray[n] || d2 != dArray2[n]) {
                    generalPath.lineTo(dArray[n], dArray2[n]);
                    d = dArray[n];
                    d2 = dArray2[n];
                }
                ++n;
                continue;
            }
            if (!blArray[n + 1]) {
                generalPath.quadTo(dArray[n], dArray2[n], dArray[n + 1], dArray2[n + 1]);
                d = dArray[n + 1];
                d2 = dArray2[n + 1];
                n += 2;
                continue;
            }
            generalPath.curveTo(dArray[n], dArray2[n], dArray[n + 1], dArray2[n + 1], dArray[n + 2], dArray2[n + 2]);
            d = dArray[n + 2];
            d2 = dArray2[n + 2];
            n += 3;
        }
        if (curve.filled()) {
            generalPath.closePath();
        }
    }

    static Paint getFill(GradientPaintInfo gradientPaintInfo) {
        if (gradientPaintInfo == null) {
            return null;
        }
        if (gradientPaintInfo.getSolid() != null) {
            return AWTConverter.getColor(gradientPaintInfo.getSolid());
        }
        int n = gradientPaintInfo.getOffsets().length;
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorArray[i] = AWTConverter.getColor(gradientPaintInfo.getColors()[i]);
        }
        if (gradientPaintInfo.getType() == 1003) {
            return new RadialGradient((float)gradientPaintInfo.getCx(), (float)gradientPaintInfo.getCy(), (float)gradientPaintInfo.getCr(), gradientPaintInfo.getOffsets(), colorArray);
        }
        return LinearGradient.createLinearGradient((float)gradientPaintInfo.getX1(), (float)gradientPaintInfo.getY1(), (float)gradientPaintInfo.getX2(), (float)gradientPaintInfo.getY2(), gradientPaintInfo.getOffsets(), colorArray);
    }

    static Stroke getStroke(com.ibm.vis.engine.internal.Stroke stroke) {
        int n;
        if (stroke == null) {
            return null;
        }
        float f = (float)stroke.getWidth();
        int n2 = 0;
        if ("round".equals(stroke.getCap())) {
            n2 = 1;
        } else if ("square".equals(stroke.getCap())) {
            n2 = 2;
        }
        int n3 = 0;
        float f2 = 4.0f;
        if (stroke.getJoin() instanceof String) {
            if ("round".equals(stroke.getJoin())) {
                n3 = 1;
            } else if ("bevel".equals(stroke.getJoin())) {
                n3 = 2;
            }
        } else if (stroke.getJoin() instanceof Number) {
            f2 = ((Number)stroke.getJoin()).floatValue();
        }
        if (stroke.getDashing() == null) {
            return new BasicStroke(f, n2, n3, f2);
        }
        int[] nArray = Dashing.getDashArray(stroke.getDashing());
        if (nArray == null) {
            return new BasicStroke(f, n2, n3, f2);
        }
        float[] fArray = new float[nArray.length];
        float f3 = Math.max(1.0f, f);
        for (n = 0; n < nArray.length; ++n) {
            fArray[n] = f3 * (float)nArray[n];
        }
        if (n2 != 0) {
            for (n = 0; n < nArray.length; n += 2) {
                int n4 = n;
                fArray[n4] = fArray[n4] - f3;
                if (!(fArray[n] < 0.0f)) continue;
                fArray[n] = 0.0f;
            }
            for (n = 1; n < nArray.length; n += 2) {
                int n5 = n;
                fArray[n5] = fArray[n5] + f3;
            }
        }
        return new BasicStroke(f, n2, n3, f2, fArray, 0.0f);
    }

    static Color getStrokeColor(com.ibm.vis.engine.internal.Stroke stroke) {
        if (stroke == null) {
            return null;
        }
        return AWTConverter.getColor(stroke.getColor());
    }

    public static Color getColor(ColorNew colorNew) {
        if (colorNew == null) {
            return null;
        }
        double[] dArray = colorNew.getRGBA();
        return new Color((float)dArray[0] / 255.0f, (float)dArray[1] / 255.0f, (float)dArray[2] / 255.0f, (float)dArray[3]);
    }

    static Font getFont(FontInfo fontInfo) {
        if (fontInfo == null) {
            return FontUtil.DEFAULT_FONT;
        }
        String string = fontInfo.getFamily();
        if (string == null) {
            string = FontUtil.DEFAULT_FONT.getFamily();
        }
        boolean bl = fontInfo.getWeight() != null && fontInfo.getWeight().contains("bold");
        Map<AttributedCharacterIterator.Attribute, Object> map = FontUtil.populateFontAttributes(string, fontInfo.getSize(), bl, fontInfo.getStyle());
        return new Font(map);
    }

    static AffineTransform getTransform(TransformInfo transformInfo) {
        if (transformInfo == null) {
            return null;
        }
        Affine affine = ((TransformInfoImpl)transformInfo).getAffine();
        if (affine == null) {
            return null;
        }
        return new AffineTransform(affine.m00, affine.m10, affine.m01, affine.m11, affine.m02, affine.m12);
    }
}

