/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.render;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.PlatformDefaults;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.internal.renderer.GraphicsRenderer;
import com.ibm.vis.internal.renderer.NodeRenderer;
import com.ibm.vis.internal.renderer.NodeRendererProvider;
import com.ibm.vis.scenetree.provisional.TransformInfo;
import com.ibm.vis.ui.awt.internal.render.AWTConverter;
import com.ibm.vis.ui.awt.internal.render.AWTNodeRenderer;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Stack;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AWTGraphicsRenderer
implements GraphicsRenderer,
NodeRendererProvider {
    private static final AWTNodeRenderer AWT_NODE_RENDERER = new AWTNodeRenderer();
    private final Graphics2D g;
    private final Stack<AffineTransform> transforms;
    private final Stack<Shape> clips;
    private boolean isDisposed;
    private int width;
    private int height;

    public AWTGraphicsRenderer(Graphics2D graphics2D, int n, int n2, boolean bl) {
        this.width = n;
        this.height = n2;
        this.g = (Graphics2D)graphics2D.create();
        this.transforms = new Stack();
        this.clips = new Stack();
        this.isDisposed = false;
        this.setGraphicsInitialState(bl);
    }

    public AWTGraphicsRenderer(Graphics2D graphics2D, int n, int n2) {
        this(graphics2D, n, n2, PlatformDefaults.usesFractionalMetrics);
    }

    private void setGraphicsInitialState(boolean bl) {
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (bl) {
            this.g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        } else {
            this.g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    @Override
    public void saveGraphicsState(TransformInfo transformInfo, Rect rect) {
        Object object;
        this.transforms.push(this.g.getTransform());
        if (transformInfo != null && (object = AWTConverter.getTransform(transformInfo)) != null) {
            this.g.transform((AffineTransform)object);
        }
        this.clips.push(this.g.getClip());
        if (rect != null && (object = AWTConverter.getShape(rect)) != null) {
            this.g.clip((Shape)object);
        }
    }

    @Override
    public void restoreGraphicsState() {
        this.g.setClip(this.clips.pop());
        this.g.setTransform(this.transforms.pop());
    }

    @Override
    public void clear(Rect rect) {
        Composite composite = this.g.getComposite();
        this.g.setComposite(AlphaComposite.Clear);
        if (rect == null) {
            this.g.fillRect(0, 0, this.width, this.height);
        } else {
            this.g.fillRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
        }
        this.g.setComposite(composite);
    }

    final Graphics2D getGraphics() {
        return this.g;
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.g.dispose();
            this.isDisposed = true;
        }
    }

    @Override
    public NodeRendererProvider getNodeRendererProvider() {
        return this;
    }

    @Override
    public NodeRenderer getNodeRenderer(int n) {
        return AWT_NODE_RENDERER;
    }
}

