/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.render;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.image.ImageFill;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.resource.GraphicNativeResource;
import com.ibm.vis.scenetree.internal.SceneNodeRenderInfo;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AWTImageRenderer {
    private final ImageFill imageFill;
    private final BufferedImage image;

    AWTImageRenderer(SceneNodeRenderInfo sceneNodeRenderInfo) {
        this.imageFill = sceneNodeRenderInfo.getRenderImage();
        this.image = AWTImageRenderer.makeImage(this.imageFill);
    }

    private static BufferedImage makeImage(ImageFill imageFill) {
        if (imageFill == null || imageFill.getImageResource() == null || !imageFill.getImageResource().isLoaded()) {
            return null;
        }
        GraphicNativeResource graphicNativeResource = imageFill.getImageResource().getNativeResource();
        if (graphicNativeResource == null) {
            return null;
        }
        Object object = graphicNativeResource.getData();
        if (object instanceof BufferedImage) {
            return (BufferedImage)object;
        }
        return null;
    }

    void renderImage(Graphics2D graphics2D, Shape shape) {
        if (this.image == null || this.image.getWidth() == 0 || this.image.getHeight() == 0 || this.imageFill.getAlpha() <= 0.0) {
            return;
        }
        Shape shape2 = graphics2D.getClip();
        if (shape != null) {
            graphics2D.clip(shape);
        }
        Composite composite = null;
        if (this.imageFill.getAlpha() < 1.0) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.imageFill.getAlpha()));
        }
        double d = this.imageFill.getX();
        double d2 = this.imageFill.getY();
        double d3 = this.imageFill.getWidth();
        double d4 = this.imageFill.getHeight();
        Affine affine = this.imageFill.getTransformInfo().getAffine();
        if (affine != null) {
            d = affine.m00 * d + affine.m02;
            d2 = affine.m11 * d2 + affine.m12;
            d3 = affine.m00 * d3;
            d4 = affine.m11 * d4;
        }
        if ("texture".equals(this.imageFill.getMethod())) {
            int n = this.imageFill.getTileX();
            int n2 = this.imageFill.getTileY();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    graphics2D.drawImage(this.image, new AffineTransform(1.0, 0.0, 0.0, 1.0, d + (double)i * d3, d2 + (double)j * d4), null);
                }
            }
        } else {
            double d5 = d3 / (double)this.image.getWidth();
            double d6 = d4 / (double)this.image.getHeight();
            graphics2D.drawImage(this.image, new AffineTransform(d5, 0.0, 0.0, d6, d, d2), null);
        }
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
        graphics2D.setClip(shape2);
    }
}

