/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.render;

import com.ibm.vis.engine.internal.RenderEffect;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.internal.renderer.GraphicsRenderer;
import com.ibm.vis.internal.renderer.NodeRenderer;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.internal.SceneNodeRenderInfo;
import com.ibm.vis.scenetree.provisional.TextInfo;
import com.ibm.vis.ui.awt.internal.render.AWTBlurEffectRenderer;
import com.ibm.vis.ui.awt.internal.render.AWTConverter;
import com.ibm.vis.ui.awt.internal.render.AWTGraphicsRenderer;
import com.ibm.vis.ui.awt.internal.render.AWTImageRenderer;
import com.ibm.vis.ui.awt.internal.render.TextShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AWTNodeRenderer
extends NodeRenderer {
    @Override
    protected void renderNode(GraphicsRenderer graphicsRenderer, SceneNodeImpl sceneNodeImpl, int n, int n2, int n3) {
        SceneNodeRenderInfo sceneNodeRenderInfo = sceneNodeImpl.getRenderInfo();
        TextInfo textInfo = sceneNodeRenderInfo.getRenderText();
        if (textInfo == null) {
            this.renderShape(graphicsRenderer, AWTConverter.getShape(sceneNodeRenderInfo.getRenderGeom()), sceneNodeRenderInfo, n2);
        } else if (sceneNodeRenderInfo.getRenderBounds() != null) {
            this.renderShape(graphicsRenderer, new TextShape(sceneNodeRenderInfo.getRenderBounds(), textInfo, n), sceneNodeRenderInfo, n2);
        }
    }

    private void renderShape(GraphicsRenderer graphicsRenderer, Shape shape, SceneNodeRenderInfo sceneNodeRenderInfo, int n) {
        AWTBlurEffectRenderer aWTBlurEffectRenderer;
        RenderEffect renderEffect;
        if (shape == null) {
            return;
        }
        Graphics2D graphics2D = ((AWTGraphicsRenderer)graphicsRenderer).getGraphics();
        boolean bl = shape instanceof TextShape;
        RenderEffect renderEffect2 = renderEffect = sceneNodeRenderInfo.getRenderEffects() == null ? null : sceneNodeRenderInfo.getRenderEffects().getShadow();
        if (this.canRenderShadow(renderEffect, n, bl)) {
            aWTBlurEffectRenderer = new AWTBlurEffectRenderer(graphics2D, renderEffect, true);
            aWTBlurEffectRenderer.render(shape, sceneNodeRenderInfo);
        }
        if (n == 0 || n == 2) {
            Object object;
            AWTBlurEffectRenderer aWTBlurEffectRenderer2 = aWTBlurEffectRenderer = sceneNodeRenderInfo.getRenderEffects() == null ? null : sceneNodeRenderInfo.getRenderEffects().getGlow();
            if (aWTBlurEffectRenderer != null) {
                object = new AWTBlurEffectRenderer(graphics2D, (RenderEffect)((Object)aWTBlurEffectRenderer), false);
                ((AWTBlurEffectRenderer)object).render(shape, sceneNodeRenderInfo);
            }
            if ((object = AWTConverter.getFill(sceneNodeRenderInfo.getRenderFill())) != null) {
                graphics2D.setPaint((Paint)object);
                if (bl) {
                    ((TextShape)shape).render(graphics2D);
                } else {
                    try {
                        graphics2D.fill(shape);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (!bl) {
                Object object2;
                if (sceneNodeRenderInfo.getRenderImage() != null) {
                    object2 = new AWTImageRenderer(sceneNodeRenderInfo);
                    ((AWTImageRenderer)object2).renderImage(graphics2D, shape);
                }
                object2 = AWTConverter.getStroke(sceneNodeRenderInfo.getRenderStroke());
                Color color = AWTConverter.getStrokeColor(sceneNodeRenderInfo.getRenderStroke());
                if (object2 != null && color != null) {
                    graphics2D.setStroke((Stroke)object2);
                    graphics2D.setColor(color);
                    try {
                        graphics2D.draw(shape);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

