/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.render;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GraphicsUtil {
    public static int getAlpha(int n) {
        return n >> 24 & 0xFF;
    }

    public static int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    public static int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    public static int getBlue(int n) {
        return n & 0xFF;
    }

    public static int rgb(int n, int n2, int n3, int n4) {
        return (n & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF;
    }

    public static int updateAlpha(int n, int n2) {
        return GraphicsUtil.rgb(n, GraphicsUtil.getRed(n2), GraphicsUtil.getGreen(n2), GraphicsUtil.getBlue(n2));
    }

    public static void gaussianBlurBufferedImage(BufferedImage bufferedImage, int n) {
        int n2;
        if (n == 0) {
            return;
        }
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int n5 = nArray.length;
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n5];
        for (n2 = 0; n2 < n4; ++n2) {
            GraphicsUtil.boxBlur(nArray, nArray2, n2 * n3, n3, 1, n);
            GraphicsUtil.boxBlur(nArray2, nArray3, n2 * n3, n3, 1, n);
            GraphicsUtil.boxBlur(nArray3, nArray4, n2 * n3, n3, 1, n);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            GraphicsUtil.boxBlur(nArray4, nArray3, n2, n4, n3, n);
            GraphicsUtil.boxBlur(nArray3, nArray2, n2, n4, n3, n);
            GraphicsUtil.boxBlur(nArray2, nArray, n2, n4, n3, n);
        }
    }

    private static void boxBlur(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        int n5 = 2 * n4 + 1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = n5 * n3;
        int n18 = n4 * n3;
        for (int i = 0; i < n2; ++i) {
            n16 = n + i * n3;
            n15 = nArray[n16];
            n6 += GraphicsUtil.getRed(n15);
            n7 += GraphicsUtil.getGreen(n15);
            n8 += GraphicsUtil.getBlue(n15);
            n9 += GraphicsUtil.getAlpha(n15);
            if (i >= n5) {
                n14 = nArray[n16 - n17];
                n6 -= GraphicsUtil.getRed(n14);
                n7 -= GraphicsUtil.getGreen(n14);
                n8 -= GraphicsUtil.getBlue(n14);
                n9 -= GraphicsUtil.getAlpha(n14);
            }
            if (i < n4) continue;
            n10 = n6 / n5;
            n11 = n7 / n5;
            n12 = n8 / n5;
            n13 = n9 / n5;
            nArray2[n16 - n18] = GraphicsUtil.rgb(n13, n10, n11, n12);
        }
    }
}

