/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.render;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.ui.awt.internal.render.LinearGradientContext;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.lang.reflect.Constructor;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LinearGradient
implements Paint {
    public final Point2D.Float startXY;
    public final Point2D.Float endXY;
    public final float[] fractions;
    public final Color[] colors;
    private final int transparency;
    private static Constructor gradientPaintClass;

    public static Paint createLinearGradient(Point2D.Float float_, Point2D.Float float_2, float[] fArray, Color[] colorArray) {
        try {
            if (gradientPaintClass != null) {
                return (Paint)gradientPaintClass.newInstance(float_, float_2, fArray, colorArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new LinearGradient(float_, float_2, fArray, colorArray);
    }

    public static Paint createLinearGradient(float f, float f2, float f3, float f4, float[] fArray, Color[] colorArray) {
        return LinearGradient.createLinearGradient(new Point2D.Float(f, f2), new Point2D.Float(f3, f4), fArray, colorArray);
    }

    private LinearGradient(Point2D.Float float_, Point2D.Float float_2, float[] fArray, Color[] colorArray) {
        this.startXY = float_;
        this.endXY = float_2;
        this.fractions = fArray;
        this.colors = colorArray;
        int n = colorArray[0].getAlpha();
        for (Color color : colorArray) {
            n &= color.getAlpha();
        }
        this.transparency = n == 255 ? 1 : 3;
    }

    @Override
    public int getTransparency() {
        return this.transparency;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public Point2D.Float getStartPoint() {
        return this.startXY;
    }

    public Point2D.Float getEndPoint() {
        return this.endXY;
    }

    public float[] getFractions() {
        return this.fractions;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return new LinearGradientContext(this.startXY, this.endXY, this.fractions, this.colors, affineTransform);
    }

    static {
        Constructor<?> constructor;
        try {
            Class<?> clazz = Class.forName("java.awt.LinearGradientPaint");
            constructor = clazz.getConstructor(Point2D.class, Point2D.class, float[].class, Color[].class);
        }
        catch (Exception exception) {
            constructor = null;
        }
        gradientPaintClass = constructor;
    }
}

