/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.render;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import sun.awt.image.IntegerComponentRaster;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class LinearGradientContext
implements PaintContext {
    private static final ColorModel ARGB_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    private final float startX;
    private final float startY;
    private final float[] fractions;
    private final int[] r;
    private final int[] g;
    private final int[] b;
    private final int[] a;
    private final int lastColor;
    private final int firstColor;
    private final float endX;
    private final float endY;
    private final Color[] listOfColors;

    public LinearGradientContext(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, AffineTransform affineTransform) {
        float[] fArray2 = fArray;
        Color[] colorArray2 = colorArray;
        fArray2 = new float[fArray2.length + 2];
        fArray2[0] = 0.0f;
        fArray2[fArray2.length - 1] = 1.0f;
        System.arraycopy(fArray, 0, fArray2, 1, fArray.length);
        colorArray2 = new Color[colorArray2.length + 2];
        colorArray2[0] = colorArray[0];
        colorArray2[colorArray2.length - 1] = colorArray[colorArray.length - 1];
        System.arraycopy(colorArray, 0, colorArray2, 1, colorArray.length);
        this.fractions = fArray2;
        this.listOfColors = colorArray2;
        Point2D point2D3 = affineTransform.transform(point2D, null);
        this.startX = (float)point2D3.getX();
        this.startY = (float)point2D3.getY();
        Point2D point2D4 = affineTransform.transform(point2D2, null);
        this.endX = (float)point2D4.getX();
        this.endY = (float)point2D4.getY();
        Point2D.Double double_ = new Point2D.Double(1.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, 1.0);
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
            affineTransform2.deltaTransform(double_, double_);
            affineTransform2.deltaTransform(double_2, double_2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            ((Point2D)double_).setLocation(0.0, 0.0);
            ((Point2D)double_2).setLocation(0.0, 0.0);
        }
        this.r = new int[this.listOfColors.length];
        this.g = new int[this.listOfColors.length];
        this.b = new int[this.listOfColors.length];
        this.a = new int[this.listOfColors.length];
        for (int i = 0; i < this.listOfColors.length; ++i) {
            int n = this.listOfColors[i].getRGB();
            this.a[i] = n >> 24 & 0xFF;
            this.r[i] = n >> 16 & 0xFF;
            this.g[i] = n >> 8 & 0xFF;
            this.b[i] = n & 0xFF;
        }
        this.firstColor = this.listOfColors[0].getRGB();
        this.lastColor = this.listOfColors[this.listOfColors.length - 1].getRGB();
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ARGB_MODEL;
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)ARGB_MODEL.createCompatibleWritableRaster(n3, n4);
        int[] nArray = integerComponentRaster.getDataStorage();
        int n5 = integerComponentRaster.getScanlineStride() - n3;
        int n6 = integerComponentRaster.getDataOffset(0);
        float f = this.endX - this.startX;
        float f2 = this.endY - this.startY;
        double d = f * this.startX + f2 * this.startY;
        double d2 = f * this.endX + f2 * this.endY;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n7;
                double d3 = f * (float)(n + j) + f2 * (float)(n2 + i);
                if (d3 <= d) {
                    nArray[n6++] = this.firstColor;
                    continue;
                }
                if (d3 >= d2) {
                    nArray[n6++] = this.lastColor;
                    continue;
                }
                double d4 = (d3 - d) / (d2 - d);
                for (n7 = 1; n7 < this.fractions.length - 1 && (double)this.fractions[n7] < d4; ++n7) {
                }
                d4 = (d4 - (double)this.fractions[n7 - 1]) / (double)(this.fractions[n7] - this.fractions[n7 - 1]);
                int n8 = n7 - 1 < 0 ? 0 : n7 - 1;
                int n9 = Double.valueOf((double)this.a[n7 - 1] + (double)(this.a[n7] - this.a[n8]) * d4).intValue() << 24;
                int n10 = Double.valueOf((double)this.r[n7 - 1] + (double)(this.r[n7] - this.r[n8]) * d4).intValue() << 16;
                int n11 = Double.valueOf((double)this.g[n7 - 1] + (double)(this.g[n7] - this.g[n8]) * d4).intValue() << 8;
                int n12 = Double.valueOf((double)this.b[n7 - 1] + (double)(this.b[n7] - this.b[n8]) * d4).intValue();
                nArray[n6++] = n9 | n10 | n11 | n12;
            }
            n6 += n5;
        }
        return integerComponentRaster;
    }
}

