/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.render;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.ui.awt.internal.render.RadialGradientContext;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.lang.reflect.Constructor;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class RadialGradient
implements Paint {
    private static Constructor gradientPaintClass;
    public final float cx;
    public final float cy;
    public final float radius;
    public final float[] fractions;
    public final Color[] colors;
    private final int transparency;
    private Paint nativeGradientPaint;

    public RadialGradient(float f, float f2, float f3, float[] fArray, Color[] colorArray) {
        this.cx = f;
        this.cy = f2;
        this.radius = f3;
        this.fractions = fArray;
        this.colors = colorArray;
        int n = colorArray[0].getAlpha();
        for (Color color : colorArray) {
            n &= color.getAlpha();
        }
        this.transparency = n == 255 ? 1 : 3;
        try {
            if (gradientPaintClass != null) {
                this.nativeGradientPaint = (Paint)gradientPaintClass.newInstance(Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), fArray, colorArray);
            }
        }
        catch (Exception exception) {
            this.nativeGradientPaint = null;
        }
    }

    @Override
    public int getTransparency() {
        return this.transparency;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        if (this.nativeGradientPaint != null) {
            return this.nativeGradientPaint.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
        }
        return new RadialGradientContext(this.cx, this.cy, this.radius, this.fractions, this.colors, affineTransform);
    }

    static {
        Constructor<?> constructor;
        try {
            Class<?> clazz = Class.forName("java.awt.RadialGradientPaint");
            constructor = clazz.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, float[].class, Color[].class);
        }
        catch (Exception exception) {
            constructor = null;
        }
        gradientPaintClass = constructor;
    }
}

