/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.render;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import sun.awt.image.IntegerComponentRaster;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class RadialGradientContext
implements PaintContext {
    private static final ColorModel ARGB_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    private final float cx;
    private final float cy;
    private final float xscale;
    private final float yscale;
    private final float[] fractions;
    private final int[] r;
    private final int[] g;
    private final int[] b;
    private final int[] a;
    private final int lastColor;
    private final float lastFraction;
    private final int firstColor;
    private final float firstFraction;

    public RadialGradientContext(float f, float f2, float f3, float[] fArray, Color[] colorArray, AffineTransform affineTransform) {
        this.fractions = fArray;
        Point2D point2D = affineTransform.transform(new Point2D.Double(f, f2), null);
        this.cx = (float)point2D.getX();
        this.cy = (float)point2D.getY();
        if ((double)f3 <= 1.0E-6) {
            this.xscale = 0.0f;
            this.yscale = 0.0f;
        } else {
            Point2D.Double double_ = new Point2D.Double(1.0, 0.0);
            Point2D.Double double_2 = new Point2D.Double(0.0, 1.0);
            try {
                AffineTransform affineTransform2 = affineTransform.createInverse();
                affineTransform2.deltaTransform(double_, double_);
                affineTransform2.deltaTransform(double_2, double_2);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                ((Point2D)double_).setLocation(0.0, 0.0);
                ((Point2D)double_2).setLocation(0.0, 0.0);
            }
            this.xscale = (float)(double_.distance(0.0, 0.0) / (double)f3);
            this.yscale = (float)(double_2.distance(0.0, 0.0) / (double)f3);
        }
        this.r = new int[colorArray.length];
        this.g = new int[colorArray.length];
        this.b = new int[colorArray.length];
        this.a = new int[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            int n = colorArray[i].getRGB();
            this.a[i] = n >> 24 & 0xFF;
            this.r[i] = n >> 16 & 0xFF;
            this.g[i] = n >> 8 & 0xFF;
            this.b[i] = n & 0xFF;
        }
        this.firstColor = colorArray[0].getRGB();
        this.firstFraction = fArray[0];
        this.lastColor = colorArray[colorArray.length - 1].getRGB();
        this.lastFraction = fArray[colorArray.length - 1];
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ARGB_MODEL;
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)ARGB_MODEL.createCompatibleWritableRaster(n3, n4);
        int[] nArray = integerComponentRaster.getDataStorage();
        int n5 = integerComponentRaster.getScanlineStride() - n3;
        int n6 = integerComponentRaster.getDataOffset(0);
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = ((float)(n + j) - this.cx) * ((float)(n + j) - this.cx) * this.xscale * this.xscale + ((float)(n2 + i) - this.cy) * ((float)(n2 + i) - this.cy) * this.yscale * this.yscale;
                double d2 = Math.sqrt(d);
                if (d2 <= (double)this.firstFraction) {
                    nArray[n6++] = this.firstColor;
                    continue;
                }
                if (d2 >= (double)this.lastFraction) {
                    nArray[n6++] = this.lastColor;
                    continue;
                }
                int n7 = 1;
                while ((double)this.fractions[n7] < d2) {
                    ++n7;
                }
                d2 = (d2 - (double)this.fractions[n7 - 1]) / (double)(this.fractions[n7] - this.fractions[n7 - 1]);
                nArray[n6++] = (int)((double)this.a[n7 - 1] + (double)(this.a[n7] - this.a[n7 - 1]) * d2) << 24 | (int)((double)this.r[n7 - 1] + (double)(this.r[n7] - this.r[n7 - 1]) * d2) << 16 | (int)((double)this.g[n7 - 1] + (double)(this.g[n7] - this.g[n7 - 1]) * d2) << 8 | (int)((double)this.b[n7 - 1] + (double)(this.b[n7] - this.b[n7 - 1]) * d2);
            }
            n6 += n5;
        }
        return integerComponentRaster;
    }
}

