/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.render;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.FontUtil;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.provisional.TextInfo;
import com.ibm.vis.ui.awt.internal.render.AWTConverter;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TextShape
extends Rectangle2D.Double {
    private final AttributedString text;
    private final Font font;
    private final TextInfo textInfo;

    TextShape(Rect rect, TextInfo textInfo, int n) {
        super(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        this.font = AWTConverter.getFont(textInfo.getFont());
        this.textInfo = textInfo;
        String string = textInfo.getText();
        if (string.length() > 0) {
            this.text = new AttributedString(string);
            this.text.addAttribute(TextAttribute.FONT, this.font);
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    this.text.addAttribute(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                    break;
                }
                case 1: {
                    this.text.addAttribute(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                }
            }
            FontUtil.replaceLimitedFonts(this.text, textInfo.getText(), this.font);
        } else {
            this.text = null;
        }
    }

    void render(Graphics2D graphics2D) {
        if (this.text != null) {
            Point point = this.textInfo.getAnchorPoint();
            Dim dim = this.textInfo.getTextSize();
            double d = 0.0;
            if (this.textInfo.getTextAlign().equals("middle")) {
                d = dim.getWidth() / 2.0;
            } else if (this.textInfo.getTextAlign().equals("end")) {
                d = dim.getWidth();
            }
            double d2 = point.getX() - d;
            double d3 = point.getY();
            AffineTransform affineTransform = graphics2D.getTransform();
            double d4 = affineTransform.getTranslateX();
            double d5 = affineTransform.getTranslateY();
            if (affineTransform.getScaleX() == 1.0 && affineTransform.getScaleY() == 1.0 && d4 != 0.0 && d5 != 0.0 && affineTransform.getShearX() == 0.0 && affineTransform.getShearY() == 0.0) {
                double d6 = d4 % 1.0;
                double d7 = d5 % 1.0;
                graphics2D.translate(-d6, -d7);
                graphics2D.drawString(this.text.getIterator(), (float)(d2 += d6), (float)(d3 += d7));
                graphics2D.setTransform(affineTransform);
            } else {
                graphics2D.drawString(this.text.getIterator(), (float)d2, (float)d3);
            }
        }
    }
}

