/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.ui.awt.internal.render;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.ui.awt.VisControl;
import com.sun.awt.AWTUtilities;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TooltipPanel
extends JPanel {
    private static final long serialVersionUID = 7153704036775201022L;
    private final VisControl component;
    private JDialog window;
    private final JLabel label;
    private final boolean borderShapesSupported;
    private Shape borderShape;
    private static final int LABEL_PADDING = 8;
    private static final int TRIANGLE_SIZE = 12;

    public TooltipPanel(VisControl visControl) {
        super(new BorderLayout());
        this.component = visControl;
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.label = new JLabel();
        this.add((Component)this.label, "Center");
        boolean bl = false;
        try {
            JDialog jDialog = new JDialog(null, Dialog.ModalityType.MODELESS);
            AWTUtilities.setWindowShape((Window)jDialog, (Shape)this.makeShape(40, 30));
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.borderShapesSupported = bl;
        int n = 8;
        if (this.borderShapesSupported) {
            n += 12;
        }
        this.label.setBorder(BorderFactory.createEmptyBorder(8, 8, n, 8));
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        if (this.borderShape != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.draw(this.borderShape);
        }
    }

    public void showTooltipText(String string, double d, double d2) {
        if (this.window == null) {
            this.window = new JDialog(SwingUtilities.windowForComponent(this.component), Dialog.ModalityType.MODELESS);
            this.window.setUndecorated(true);
            this.window.setContentPane(this);
            this.window.setFocusableWindowState(false);
            this.window.setFocusable(false);
        }
        if (string == null) {
            this.label.setText(null);
            this.window.setVisible(false);
            this.borderShape = null;
            return;
        }
        this.label.setText(TooltipPanel.makeHTML(string));
        this.window.pack();
        this.borderShape = this.makeShape(this.window.getWidth(), this.window.getHeight());
        Point point = new Point((int)d, (int)d2);
        SwingUtilities.convertPointToScreen(point, this.component);
        if (this.borderShapesSupported) {
            AWTUtilities.setWindowShape((Window)this.window, (Shape)this.borderShape);
            this.window.setLocation(point.x - 6, point.y - this.window.getHeight() - 3);
        } else {
            this.window.setLocation(point.x, point.y - this.window.getHeight() - 3);
        }
        this.window.setVisible(true);
    }

    private static String makeHTML(String string) {
        if (string.startsWith("<html")) {
            return string;
        }
        return "<html>" + string.replaceAll("\n", "<br>") + "</html>";
    }

    private Shape makeShape(int n, int n2) {
        if (this.borderShapesSupported) {
            int[] nArray = new int[]{0, n, n, 12, 6, 0};
            int[] nArray2 = new int[]{0, 0, n2 - 12, n2 - 12, n2, n2 - 12};
            return new Polygon(nArray, nArray2, 6);
        }
        return new Rectangle(0, 0, n, n2);
    }
}

