/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.AdaptorMethodOverride;
import com.ibm.cognos.jdbc.adaptor.BaseResultSetAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class VerticaResultSetAdaptor
extends BaseResultSetAdaptor {
    private static final String TZ_FORMATER = "%1$s:%2$s";
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int MINUTES_PER_HOUR = 60;

    public VerticaResultSetAdaptor(ResultSet rs, AdaptorFactory factory) {
        super(rs, factory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AdaptorMethodOverride
    public String getExtendedData(int type, int column) throws SQLException {
        if (type != -1001 && type != -1002) {
            return super.getExtendedData(type, column);
        }
        String value = null;
        int offset = TimeZone.getDefault().getRawOffset() / 1000;
        String[] tzOffset = new String[]{String.format("%03d", offset / 3600), String.format("%02d", offset % 3600 / 60)};
        String formattedtz = String.format(TZ_FORMATER, tzOffset);
        if (type == -1001) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
            Timestamp ts = this.rs.getTimestamp(column);
            if (ts == null) return null;
            return sdf.format(ts) + formattedtz;
        }
        if (type != -1002) return value;
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSSSSS");
        Time t = this.rs.getTime(column);
        if (t == null) return null;
        return sdf.format(t) + formattedtz;
    }

    public static class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new VerticaResultSetAdaptor((ResultSet)toWrap, factory);
        }
    }
}

