/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.acrarelib.api.impl;

import com.ibm.aurora.rare.IClassificationEntry;
import com.ibm.aurora.rare.IRARE;
import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.acrarelib.api.IACQuestion;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelNodeScopeObject;
import com.ibm.aurora.rare.smdrules.input.InputScopeList;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ACQuestion
implements IACQuestion {
    private final int mRank;
    private Map<String, List<INode>> mBoundNodes = null;
    private final String caption;
    private final IClassificationEntry mEntry;
    private final IRARE mRare;
    private final IVariationsInitializationHandle mHandle;

    public ACQuestion(IRARE rare, IVariationsInitializationHandle handle, IClassificationEntry entry, int rank) throws RAREException {
        this.mEntry = entry;
        this.mRare = rare;
        this.mHandle = handle;
        this.mRank = rank;
        this.caption = this.resolveTemplate("caption").trim().replaceAll("Caption \\(", "\\(");
    }

    private void extractBoundNodes() {
        if (this.mBoundNodes == null) {
            this.mBoundNodes = new HashMap<String, List<INode>>();
            HashSet<INode> nodes = new HashSet<INode>();
            List boundScopeObjs = this.mEntry.getBoundScopes();
            Iterator i$ = boundScopeObjs.iterator();
            while (i$.hasNext()) {
                InputScopeObject scopeObj;
                InputScopeObject amScopeObject = scopeObj = (InputScopeObject)i$.next();
                if (InputScopeList.class.isInstance(scopeObj)) {
                    amScopeObject = ((InputScopeList)scopeObj).getScope("model");
                }
                if (!(amScopeObject instanceof AssociativeModelNodeScopeObject)) continue;
                nodes.add(((AssociativeModelNodeScopeObject)amScopeObject).getModelNode());
            }
            for (INode node : nodes) {
                String concept = node.getConcept().isMetric() ? IConcept.EConceptClass.metric.name() : IConcept.EConceptClass.category.name();
                if (!this.mBoundNodes.containsKey(concept)) {
                    this.mBoundNodes.put(concept, new ArrayList());
                }
                this.mBoundNodes.get(concept).add(node);
            }
            SortNodesById sorter = new SortNodesById();
            for (List<INode> list : this.mBoundNodes.values()) {
                Collections.sort(list, sorter);
            }
        }
    }

    public void encode(JSONObject jsonObject) {
        jsonObject.put((Object)"score", (Object)Float.toString(this.getScore()));
        jsonObject.put((Object)"rank", (Object)Integer.toString(this.mRank));
        jsonObject.put((Object)"caption", (Object)this.caption);
        jsonObject.put((Object)"tooltip", (Object)this.caption);
        jsonObject.put((Object)"description", (Object)this.caption);
        jsonObject.put((Object)"id", (Object)this.getQuestionId());
        jsonObject.put((Object)"intent", (Object)this.getIntent());
        JSONObject allNodes = new JSONObject();
        this.extractBoundNodes();
        for (Map.Entry<String, List<INode>> entry : this.mBoundNodes.entrySet()) {
            JSONArray nodes = new JSONArray();
            for (INode node : entry.getValue()) {
                nodes.add((Object)node.getId());
            }
            allNodes.put((Object)entry.getKey(), (Object)nodes);
        }
        jsonObject.put((Object)"nodes", (Object)allNodes);
    }

    @Override
    public String getQuestionId() {
        return this.mEntry.getClassificationId() + this.mEntry.getVariationKey();
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public String getIntent() {
        String sIntent;
        block0: {
            String intent;
            sIntent = null;
            Iterator i$ = ((Set)this.mEntry.getAttributes().get("intent")).iterator();
            if (!i$.hasNext()) break block0;
            sIntent = intent = (String)i$.next();
        }
        return sIntent;
    }

    @Override
    public float getScore() {
        return this.mEntry.getScore().floatValue();
    }

    @Override
    public Map<String, List<INode>> getBoundNodes() {
        this.extractBoundNodes();
        return this.mBoundNodes;
    }

    @Override
    public String resolveTemplate(String templateName) throws RAREException {
        return this.mRare.resolve(this.mHandle, this.mEntry, templateName).toString();
    }

    static final class SortNodesById
    implements Comparator<INode> {
        SortNodesById() {
        }

        @Override
        public int compare(INode arg0, INode arg1) {
            return arg0.getId().compareTo(arg1.getId());
        }
    }
}

