/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.acrarelib.api.impl;

import com.ibm.aurora.rare.IClassificationEntry;
import com.ibm.aurora.rare.IInputManager;
import com.ibm.aurora.rare.IOutputManager;
import com.ibm.aurora.rare.IRARE;
import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.acrarelib.api.ACParameters;
import com.ibm.aurora.rare.acrarelib.api.IACQuestion;
import com.ibm.aurora.rare.acrarelib.api.IAnalysisHandle;
import com.ibm.aurora.rare.acrarelib.api.IAnswerCoach;
import com.ibm.aurora.rare.acrarelib.api.IIntent;
import com.ibm.aurora.rare.acrarelib.api.IQuestionContext;
import com.ibm.aurora.rare.acrarelib.api.impl.ACAnalysisHandle;
import com.ibm.aurora.rare.acrarelib.api.impl.ACQuestion;
import com.ibm.aurora.rare.acrarelib.api.impl.IntentList;
import com.ibm.aurora.rare.acrarelib.api.impl.Parameters;
import com.ibm.aurora.rare.acrarelib.api.impl.QuestionContext;
import com.ibm.aurora.rare.acrarelib.api.impl.QuestionList;
import com.ibm.aurora.rare.acrarelib.input.ACInputManager;
import com.ibm.aurora.rare.acrarelib.input.IntentsInputManager;
import com.ibm.aurora.rare.acrarelib.output.ACOutputManager;
import com.ibm.aurora.rare.acrarelib.util.LoopingIterator;
import com.ibm.aurora.rare.acrarelib.util.TreeNode;
import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.logging.ILogger;
import com.ibm.aurora.rare.logging.LoggingManager;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.smd.ISmartMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ACRAREImpl
implements IAnswerCoach {
    private final IRARE mRareAC;
    private final IntentList mIntents;

    public ACRAREImpl(IRARE rareAC, Parameters params) throws RAREException {
        this.mRareAC = rareAC;
        IVariationsInitializationHandle handle = this.mRareAC.initializeHandle((IInputManager)new IntentsInputManager(), (IOutputManager)new ACOutputManager("en-us"));
        List classifications = this.mRareAC.getRanked(handle, "intent", null, null, false);
        this.mIntents = new IntentList(classifications);
    }

    @Override
    public IAnalysisHandle createNewAnalysis(Parameters params, String locale) throws RAREException {
        ILogger logger = ACParameters.PARAMETER_RARE_LOGGER.getValue(params);
        ISmartMetadata smd = ACParameters.PARAMETER_SMD.getValue(params);
        IAssociativeModel model = ACParameters.PARAMETER_MODEL.getValue(params);
        String dataSourceId = ACParameters.PARAMETER_DATASOURCE_ID.getValue(params);
        QuestionContext questionContext = new QuestionContext(smd, model, params, this.mIntents);
        ACInputManager im = new ACInputManager(model, dataSourceId, questionContext, logger);
        IVariationsInitializationHandle currentHandle = this.mRareAC.initializeHandle((IInputManager)im, (IOutputManager)new ACOutputManager(locale, logger), new LoggingManager(logger));
        return new ACAnalysisHandle(model, currentHandle, questionContext, logger);
    }

    @Override
    public IACQuestion[] getQuestions(IAnalysisHandle handle, int maxNumber) throws RAREException {
        ACAnalysisHandle acHandle = this.toACHandle(handle);
        IntentList intentList = this.getRankedIntents(acHandle);
        ArrayList<IACQuestion> questions = new ArrayList<IACQuestion>();
        if (acHandle.getQuestionContext().getIntentsFromSearchContext() != null) {
            this.extractQuestions(questions, maxNumber, acHandle, intentList, acHandle.getQuestionContext().getIntentsFromSearchContext(), null);
        }
        if ((maxNumber -= questions.size()) > 0) {
            this.extractQuestions(questions, maxNumber, acHandle, intentList, null, acHandle.getQuestionContext().getIntentsFromSearchContext());
        }
        IACQuestion[] result = new IACQuestion[questions.size()];
        questions.toArray(result);
        return result;
    }

    private IntentList getRankedIntents(ACAnalysisHandle handle) throws RAREException {
        HashMap filter = null;
        IQuestionContext ctx = handle.getQuestionContext();
        if (ctx.getSpecifiedIntents() != null && ctx.getSpecifiedIntents().size() > 0) {
            filter = new HashMap();
            HashSet<String> values = new HashSet<String>();
            filter.put("name", values);
            for (IIntent intent : ctx.getSpecifiedIntents()) {
                values.add(intent.getName());
            }
        }
        List entry = this.mRareAC.getRanked(handle.getHandle(), "intent", filter, null, false);
        return new IntentList(entry);
    }

    private void extractQuestions(List<IACQuestion> questions, int maxNumber, ACAnalysisHandle acHandle, IntentList intentList, Set<IIntent> includes, Set<IIntent> excludes) throws RAREException {
        QuestionList candidates;
        Collection<IIntent> availableIntents;
        boolean spreadResults = acHandle.getQuestionContext().getAllNodesInContext().size() == 0;
        Collection<IIntent> collection = availableIntents = includes == null ? intentList.getAllValuesOrdered() : includes;
        if (excludes != null) {
            availableIntents.removeAll(excludes);
        }
        int count = 0;
        HashMap<String, QuestionList> all = new HashMap<String, QuestionList>();
        for (IIntent intent : availableIntents) {
            HashMap attributesFilter = new HashMap();
            HashSet<String> intentAttributes = new HashSet<String>();
            intentAttributes.add(intent.getName());
            attributesFilter.put("intent", intentAttributes);
            List rankedQuestionsPerIntent = this.mRareAC.getRanked(acHandle.getHandle(), "question", attributesFilter, null, true);
            count += rankedQuestionsPerIntent.size();
            candidates = new QuestionList(spreadResults);
            all.put(intent.getName(), candidates);
            for (IClassificationEntry question : rankedQuestionsPerIntent) {
                candidates.put(question);
            }
        }
        if (count > 0) {
            int max = count > maxNumber ? maxNumber : count;
            LoopingIterator<TreeNode<IIntent>> itr = this.createIntentsIterator(intentList, includes, excludes);
            for (int i = 0; i < max; ++i) {
                IClassificationEntry question = null;
                while (question == null) {
                    IIntent intent = itr.next().getValue();
                    candidates = (QuestionList)all.get(intent.getName());
                    if (candidates == null) continue;
                    question = candidates.getNext();
                }
                if (question == null) continue;
                ACQuestion acQuestion = new ACQuestion(this.mRareAC, acHandle.getHandle(), question, questions.size());
                acHandle.addQuestion(acQuestion);
                questions.add(acQuestion);
            }
        }
    }

    private LoopingIterator<TreeNode<IIntent>> createIntentsIterator(IntentList intents, Set<IIntent> includes, Set<IIntent> excludes) {
        LoopingIterator<TreeNode<IIntent>> itr = new LoopingIterator<TreeNode<IIntent>>();
        for (TreeNode node : intents.getChildren()) {
            if (((IIntent)node.getValue()).isAbstract()) {
                ArrayList nodes = new ArrayList(node.getChildren());
                Iterator itr1 = nodes.iterator();
                while (itr1.hasNext()) {
                    IIntent anIntent = (IIntent)((TreeNode)itr1.next()).getValue();
                    if (this.includeIntent(includes, excludes, anIntent)) continue;
                    itr1.remove();
                }
                itr.add(node.getChildren());
                continue;
            }
            if (!this.includeIntent(includes, excludes, (IIntent)node.getValue())) continue;
            itr.add(node);
        }
        return itr;
    }

    private boolean includeIntent(Set<IIntent> includes, Set<IIntent> excludes, IIntent intent) {
        if (includes != null && !includes.contains(intent)) {
            return false;
        }
        return excludes == null || !excludes.contains(intent);
    }

    ACAnalysisHandle toACHandle(IAnalysisHandle handle) throws RAREException {
        ACAnalysisHandle acHandle = (ACAnalysisHandle)handle;
        return acHandle;
    }

    @Override
    public IACQuestion getQuestion(IAnalysisHandle handle, String questionId) throws RAREException {
        ACAnalysisHandle acHandle = this.toACHandle(handle);
        return acHandle.getQuestion(questionId);
    }

    @Override
    public IIntent[] getAllIntents() throws RAREException {
        List<IIntent> intents = this.mIntents.getAllValuesOrdered();
        IIntent[] array = new IIntent[intents.size()];
        return intents.toArray(array);
    }

    @Override
    public void terminate() {
    }
}

