/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.acrarelib.api.impl;

import com.ibm.aurora.rare.IClassificationEntry;
import com.ibm.aurora.rare.acrarelib.api.IIntent;
import com.ibm.aurora.rare.acrarelib.api.impl.Intent;
import com.ibm.aurora.rare.acrarelib.util.OrderedIndexedTree;
import com.ibm.aurora.rare.acrarelib.util.TreeNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IntentList
extends OrderedIndexedTree<IIntent> {
    private final Map<String, IIntent> conceptsToIntents = new HashMap<String, IIntent>();

    public IntentList(List<IClassificationEntry> intents) {
        for (int i = 0; i < intents.size(); ++i) {
            IClassificationEntry classification = intents.get(i);
            Map attributes = classification.getAttributes();
            String concept = this.getValue(attributes, "concept");
            Intent intent = new Intent(classification.getScore().floatValue(), classification.getName(), concept);
            String parentName = this.getValue(attributes, "extends");
            if (parentName != null) {
                TreeNode<IIntent> parentNode = this.getParentNode(parentName);
                this.addChildToNode(parentNode, intent);
                if (parentNode.getValue().getScore() < intent.getScore()) {
                    parentNode.getValue().setScore(intent.getScore());
                }
            } else {
                this.addChild(intent);
            }
            this.conceptsToIntents.put(concept, intent);
        }
    }

    private String getValue(Map<String, Set<String>> attributes, String name) {
        Set<String> values = attributes.get(name);
        if (values != null && values.size() > 0) {
            return values.iterator().next();
        }
        return null;
    }

    private TreeNode<IIntent> getParentNode(String parentName) {
        TreeNode<IIntent> parentNode = this.getNode(parentName);
        if (parentNode == null) {
            Intent parentIntent = new Intent(Float.MIN_VALUE, parentName, true);
            parentNode = this.addChild(parentIntent);
        }
        return parentNode;
    }

    public IIntent getIntentByConcept(String concept) {
        return this.conceptsToIntents.get(concept);
    }

    public IIntent getIntentByName(String name) {
        return (IIntent)this.getValue(name);
    }
}

