/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.acrarelib.api.impl;

import com.ibm.aurora.rare.acrarelib.api.ACParameters;
import com.ibm.aurora.rare.acrarelib.api.IIntent;
import com.ibm.aurora.rare.acrarelib.api.IQuestionContext;
import com.ibm.aurora.rare.acrarelib.api.impl.IntentList;
import com.ibm.aurora.rare.acrarelib.api.impl.Parameters;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.smd.ISmartMetadata;
import com.ibm.cognos.aurora.api.smd.SmdReqContext;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.smd.SmartMetadataImpl;
import com.ibm.cognos.smd.question.QuestionExposition;
import java.util.LinkedHashSet;
import java.util.Set;

class QuestionContext
implements IQuestionContext {
    private final QuestionExposition smdContext;
    private final Set<IIntent> specifiedIntents;
    private final Set<INode> specifiedNodes;
    private final Set<IIntent> intentsFromSearch;
    private final Set<INode> nodesFromSearch;
    private final Set<INode> exactMatchNodes;
    private final Set<INode> allNodes;
    private final Set<IIntent> allIntents = new LinkedHashSet<IIntent>();

    QuestionContext(ISmartMetadata smd, IAssociativeModel model, Parameters params, IntentList intentList) {
        String[] nodes;
        String[] intentsArray;
        this.allNodes = new LinkedHashSet<INode>();
        this.specifiedIntents = new LinkedHashSet<IIntent>();
        this.specifiedNodes = new LinkedHashSet<INode>();
        this.exactMatchNodes = new LinkedHashSet<INode>();
        this.intentsFromSearch = new LinkedHashSet<IIntent>();
        this.nodesFromSearch = new LinkedHashSet<INode>();
        String searchContext = ACParameters.PARAMETER_SEARCH_CONTEXT.getValue(params);
        if (searchContext != null) {
            System.out.println("Search Text: " + searchContext);
        }
        if (searchContext != null && !searchContext.trim().isEmpty()) {
            searchContext = QuestionContext.extractSpecifiedIntents(searchContext, intentList, this.specifiedIntents);
            SmartMetadataImpl smdImpl = (SmartMetadataImpl)smd;
            this.smdContext = smdImpl.analyzeQuestion(model, new SmdReqContext(SmdReqContext.EScope.eDecorateModel), searchContext);
            System.out.println("SMD Search Context: " + this.smdContext);
            QuestionContext.addIntents(this.smdContext, intentList, this.intentsFromSearch);
            this.nodesFromSearch.addAll(this.smdContext.getNodes());
            for (INode node : this.nodesFromSearch) {
                if (!(this.smdContext.getNodeConfidence(node) >= 1.0f)) continue;
                this.exactMatchNodes.add(node);
            }
        } else {
            this.smdContext = null;
        }
        if ((intentsArray = ACParameters.PARAMETER_SPECIFIED_INTENTS.getValue(params)) != null && intentsArray.length > 0) {
            for (String intent : intentsArray) {
                IIntent acIntent = intentList.getIntentByName(intent);
                this.specifiedIntents.add(acIntent);
            }
        }
        if ((nodes = ACParameters.PARAMETER_SPECIFIED_NODES.getValue(params)) != null && nodes.length > 0) {
            for (String node : nodes) {
                INode aNode = model.findNode(node);
                if (aNode == null) continue;
                this.specifiedNodes.add(aNode);
                this.exactMatchNodes.add(aNode);
            }
        }
        if (this.specifiedIntents.size() > 0) {
            System.out.println("Specified Intents: " + this.specifiedIntents);
        }
        if (this.intentsFromSearch.size() > 0) {
            System.out.println("Intents From Search: " + this.intentsFromSearch);
        }
        if (this.specifiedNodes.size() > 0) {
            System.out.println("Specified Nodes: " + this.specifiedNodes);
        }
        if (this.nodesFromSearch.size() > 0) {
            System.out.println("Nodes From Search: " + this.nodesFromSearch);
        }
        this.allIntents.addAll(this.specifiedIntents);
        this.allIntents.addAll(this.intentsFromSearch);
        this.allNodes.addAll(this.nodesFromSearch);
        this.allNodes.addAll(this.specifiedNodes);
    }

    private static String extractSpecifiedIntents(String searchText, IntentList intents, Set<IIntent> specifiedIntents) {
        String result = searchText;
        for (IIntent intent : intents.getAllValuesOrdered()) {
            String quoted = "\"".concat(intent.getName()).concat("\"");
            String replaced = result.replaceAll(quoted, "");
            if (!replaced.equals(result)) {
                specifiedIntents.add(intent);
            }
            result = replaced;
        }
        return result;
    }

    private static void addIntents(QuestionExposition smdContext, IntentList intents, Set<IIntent> allIntents) {
        for (IConcept smdIntent : smdContext.getOverallIntents()) {
            IIntent intent = intents.getIntentByConcept(smdIntent.getName());
            if (intent == null) continue;
            allIntents.add(intent);
        }
    }

    @Override
    public float getNodeContextConfidence(INode aNode) {
        return this.smdContext.getNodeConfidence(aNode);
    }

    @Override
    public Set<INode> getSpecifiedNodes() {
        return this.specifiedNodes;
    }

    @Override
    public Set<IIntent> getSpecifiedIntents() {
        return this.specifiedIntents;
    }

    @Override
    public Set<INode> getNodesFromSearchContext() {
        return this.nodesFromSearch;
    }

    @Override
    public Set<IIntent> getIntentsFromSearchContext() {
        return this.intentsFromSearch;
    }

    @Override
    public boolean isNodeInContext(INode node) {
        return this.allNodes.contains(node);
    }

    @Override
    public double getScore(INode node) {
        return 0.0;
    }

    @Override
    public double getScore(IIntent intent) {
        return 0.0;
    }

    @Override
    public Set<INode> getAllNodesInContext() {
        return this.allNodes;
    }

    @Override
    public Set<IIntent> getAllIntentsInContext() {
        return this.allIntents;
    }

    @Override
    public Set<INode> getExactMatchNodes() {
        return this.exactMatchNodes;
    }
}

