/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.acrarelib.api.impl;

import com.ibm.aurora.rare.IClassificationEntry;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelNodeScopeObject;
import com.ibm.aurora.rare.smdrules.input.InputScopeList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class QuestionList {
    private final List<IClassificationEntry> candidates;
    private Set<String> usedNodes = null;
    private final boolean avoidOverlap;
    private final Map<IClassificationEntry, Set<String>> cache = new HashMap<IClassificationEntry, Set<String>>();

    QuestionList(boolean checkOverlap) {
        this.candidates = new ArrayList<IClassificationEntry>();
        this.avoidOverlap = checkOverlap;
    }

    void put(IClassificationEntry node) {
        this.candidates.add(node);
    }

    IClassificationEntry getNext() {
        IClassificationEntry node = null;
        int endIndex = this.candidates.size() - 1;
        for (int index = 0; index <= endIndex; ++index) {
            if (this.isOverlapping(this.candidates.get(index))) continue;
            node = this.candidates.remove(index);
            break;
        }
        if (node == null && !this.candidates.isEmpty()) {
            node = this.candidates.remove(0);
        }
        if (node != null) {
            this.usedNodes = this.getBoundNodes(node);
        }
        return node;
    }

    boolean isOverlapping(IClassificationEntry node) {
        if (this.avoidOverlap) {
            boolean overlap = false;
            if (this.usedNodes == null) {
                return true;
            }
            for (String aNode : this.getBoundNodes(node)) {
                if (!this.usedNodes.contains(aNode)) continue;
                if (!overlap) {
                    overlap = true;
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    Set<String> getBoundNodes(IClassificationEntry node) {
        Set<String> nodeIds = this.cache.get(node);
        if (nodeIds == null) {
            nodeIds = new HashSet<String>();
            List boundScopeObjs = node.getBoundScopes();
            Iterator i$ = boundScopeObjs.iterator();
            while (i$.hasNext()) {
                InputScopeObject scopeObj;
                InputScopeObject amScopeObject = scopeObj = (InputScopeObject)i$.next();
                if (InputScopeList.class.isInstance(scopeObj)) {
                    amScopeObject = ((InputScopeList)scopeObj).getScope("model");
                }
                if (!(amScopeObject instanceof AssociativeModelNodeScopeObject)) continue;
                nodeIds.add(((AssociativeModelNodeScopeObject)amScopeObject).getNodeId());
            }
            this.cache.put(node, nodeIds);
        }
        return nodeIds;
    }
}

