/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.acrarelib.input;

import com.ibm.aurora.rare.acrarelib.api.IIntent;
import com.ibm.aurora.rare.acrarelib.api.IQuestionContext;
import com.ibm.aurora.rare.acrarelib.input.IModelInfo;
import com.ibm.aurora.rare.acrarelib.input.SortNodesByDistinctCount;
import com.ibm.aurora.rare.logging.ELogLevel;
import com.ibm.aurora.rare.logging.ILogger;
import com.ibm.aurora.rare.logging.LoggingManager;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelInputManager;
import com.ibm.aurora.rare.smdrules.utils.SmdHelper;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.core.model.NavigationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ACInputManager
extends AssociativeModelInputManager
implements IQuestionContext,
IModelInfo {
    private final String mDataSourceName;
    private final List<INode> allNodes;
    private Set<INode> actualRootNodes = null;
    private final IQuestionContext context;
    private int categoriesCount = 0;
    private int metricsCount = 0;

    public ACInputManager(IAssociativeModel model, String dataSourceName, IQuestionContext aContext) {
        this(model, dataSourceName, aContext, null);
    }

    public ACInputManager(IAssociativeModel model, String dataSourceName, IQuestionContext aContext, ILogger logger) {
        super(model, null, logger);
        LoggingManager loggingManager = this.getLoggingManager();
        if (loggingManager.canLog(ELogLevel.INFO)) {
            loggingManager.getLogger().beginSection((Object)"ACInputManager Initializing");
            loggingManager.getLogger().info((Object)("Data Source name: " + dataSourceName));
        }
        this.mDataSourceName = dataSourceName;
        NavigationHelper hlpNVG = new NavigationHelper(model);
        List excludedConcepts = NavigationHelper.getSpeciallyTreatedConcepts();
        this.allNodes = hlpNVG.getCategoryAndMetricNodesFiltered(excludedConcepts);
        for (INode aNode : this.allNodes) {
            if (aNode.isCategory()) {
                ++this.categoriesCount;
                continue;
            }
            if (!aNode.isMetric()) continue;
            ++this.metricsCount;
        }
        Collections.sort(this.allNodes, new SortNodesByDistinctCount(this, true));
        ArrayList rootNodes = new ArrayList(SmdHelper.extractRootNodes(this.allNodes, (List)excludedConcepts));
        Collections.sort(rootNodes, new SortNodesByDistinctCount(this));
        this.actualRootNodes = new LinkedHashSet<INode>();
        this.context = aContext;
        this.actualRootNodes.addAll(this.context.getAllNodesInContext());
        this.actualRootNodes.addAll(rootNodes);
        if (loggingManager.canLog(ELogLevel.INFO)) {
            loggingManager.getLogger().beginSection((Object)"Actual root nodes");
            for (INode node : this.actualRootNodes) {
                loggingManager.getLogger().info((Object)("Node: " + node.getId() + " (" + node.getLabel() + ")"));
            }
            loggingManager.getLogger().endSection((Object)"Actual root nodes");
            loggingManager.getLogger().endSection((Object)"ACInputManager Initializing");
        }
    }

    public String getDataSourceName() {
        return this.mDataSourceName;
    }

    public Set<INode> getRootNodes() {
        return this.actualRootNodes;
    }

    public List<INode> getAllNodes() {
        return this.allNodes;
    }

    @Override
    public Set<INode> getSpecifiedNodes() {
        return this.context.getSpecifiedNodes();
    }

    @Override
    public Set<IIntent> getSpecifiedIntents() {
        return this.context.getSpecifiedIntents();
    }

    @Override
    public Set<INode> getNodesFromSearchContext() {
        return this.context.getNodesFromSearchContext();
    }

    @Override
    public Set<IIntent> getIntentsFromSearchContext() {
        return this.context.getIntentsFromSearchContext();
    }

    @Override
    public boolean isNodeInContext(INode node) {
        return this.context.isNodeInContext(node);
    }

    @Override
    public double getScore(INode node) {
        return this.context.getScore(node);
    }

    @Override
    public double getScore(IIntent intent) {
        return this.context.getScore(intent);
    }

    @Override
    public Set<INode> getAllNodesInContext() {
        return this.context.getAllNodesInContext();
    }

    @Override
    public Set<IIntent> getAllIntentsInContext() {
        return this.context.getAllIntentsInContext();
    }

    @Override
    public float getNodeContextConfidence(INode aNode) {
        return this.context.getNodeContextConfidence(aNode);
    }

    @Override
    public Set<INode> getExactMatchNodes() {
        return this.context.getExactMatchNodes();
    }

    @Override
    public int getCategoriesCount() {
        return this.categoriesCount;
    }

    @Override
    public int getMetricsCount() {
        return this.metricsCount;
    }
}

