/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.acrarelib.lib;

import com.ibm.aurora.rare.IClassificationStreamer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClassificationStreamer
implements IClassificationStreamer {
    private final String _sTemplatesFolder;
    private final String _sRootPath;
    private final String _sClassificationFile;

    public ClassificationStreamer(String rootPath, String classificationFile) {
        this(rootPath, null, classificationFile);
    }

    public ClassificationStreamer(String rootPath, String templatesFolder, String classificationRoot) {
        this._sRootPath = rootPath;
        this._sTemplatesFolder = templatesFolder;
        this._sClassificationFile = classificationRoot;
    }

    protected String getRootPath() {
        return this._sRootPath;
    }

    public InputStream getClassificationStream() throws IOException {
        File classificationFile = new File(this.getRootPath() + this._sClassificationFile);
        if (classificationFile.exists()) {
            return new FileInputStream(classificationFile);
        }
        return this.getClass().getResourceAsStream("/classification/" + this._sClassificationFile);
    }

    public InputStream getTemplateStream(String name) throws IOException {
        if (this._sTemplatesFolder != null) {
            File templateFile = new File(this.getRootPath() + this._sTemplatesFolder + name + ".xml");
            if (templateFile.exists()) {
                return new FileInputStream(templateFile);
            }
            return this.getClass().getResourceAsStream("/classification/" + this._sTemplatesFolder + name + ".xml");
        }
        throw new UnsupportedOperationException("ACRARELib has no templates (template requested: " + name + ')');
    }
}

