/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.acrarelib.rules;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.acrarelib.api.IQuestionContext;
import com.ibm.aurora.rare.acrarelib.rules.ACBaseRule;
import com.ibm.aurora.rare.acrarelib.rules.util.InputNode;
import com.ibm.aurora.rare.acrarelib.rules.util.InputNodeIterator;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.rule.INumericRule;
import com.ibm.aurora.rare.smdrules.utils.RulesUtil;
import com.ibm.cognos.aurora.api.model.INode;
import java.util.List;
import java.util.Map;

public class ScoreByQuestionContext
extends ACBaseRule
implements INumericRule {
    static final String ATTR_SCORE = "score";
    private double score = 40.0;

    @Override
    public void setProperties(Map<String, String> properties) {
        super.setProperties(properties);
        this.score = RulesUtil.getAttribute((String)ATTR_SCORE, properties, (double)this.score);
    }

    @Override
    protected boolean skipNodeInContext() {
        return false;
    }

    public Number apply(List<? extends InputScopeObject> inputs, Map<String, String> attributes, IVariationsInitializationHandle handle) throws RuleException {
        double theScore = RulesUtil.getAttribute((String)ATTR_SCORE, attributes, (double)this.score);
        IQuestionContext context = (IQuestionContext)handle.getInputManager();
        double total = 0.0;
        if (context.getAllNodesInContext().size() > 0) {
            InputNodeIterator itr = this.getIterator(inputs);
            while (itr.hasNext()) {
                InputNode node = itr.next();
                INode modelNode = node.getModelNode();
                float searchConfidence = context.getNodeContextConfidence(modelNode);
                if (node.isInContext() && searchConfidence >= 1.0f) {
                    total += theScore * 4.0 * (double)searchConfidence;
                    continue;
                }
                if (searchConfidence > 0.0f) {
                    total -= theScore * (double)((1.0f - searchConfidence) * 3.0f);
                    continue;
                }
                total -= theScore * 2.0;
            }
        }
        return total;
    }
}

