/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.acrarelib.rules;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.acrarelib.input.IModelInfo;
import com.ibm.aurora.rare.acrarelib.rules.ACBaseRule;
import com.ibm.aurora.rare.acrarelib.rules.util.InputNode;
import com.ibm.aurora.rare.acrarelib.rules.util.InputNodeIterator;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.rule.IBooleanRule;
import com.ibm.aurora.rare.smdrules.utils.SmdHelper;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.INode;
import java.util.List;
import java.util.Map;

public class ValidateCategoryNotLikeRowID
extends ACBaseRule
implements IBooleanRule {
    @Override
    protected boolean skipNodeInContext() {
        return true;
    }

    public Boolean apply(List<? extends InputScopeObject> inputs, Map<String, String> attributes, IVariationsInitializationHandle handle) throws RuleException {
        IModelInfo modelInfo;
        if (!this.disabled() && (modelInfo = (IModelInfo)handle.getInputManager()).getCategoriesCount() > 1) {
            InputNodeIterator itr = this.getIterator(inputs);
            while (itr.hasNext()) {
                InputNode scopeObj = itr.next();
                INode node = scopeObj.getModelNode();
                if (!node.isCategory()) continue;
                INode attrNode = SmdHelper.getIdAttribute((INode)node);
                IDataItem dataItem = attrNode.getDataItem();
                long nbrRows = dataItem.getStats().totalCount();
                long nbrDistinctValues = dataItem.getStats().distinctCount();
                if (nbrDistinctValues < nbrRows) continue;
                return false;
            }
        }
        return true;
    }
}

