/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.acrarelib.rules;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.acrarelib.rules.ACBaseRule;
import com.ibm.aurora.rare.acrarelib.rules.util.InputNode;
import com.ibm.aurora.rare.acrarelib.rules.util.InputNodeIterator;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.rule.IBooleanRule;
import com.ibm.aurora.rare.smdrules.utils.SmdHelper;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidateTemporalNodeForPareto
extends ACBaseRule
implements IBooleanRule {
    private static final long MIN_DISTINCT_COUNT = 5L;

    @Override
    protected boolean skipNodeInContext() {
        return true;
    }

    public Boolean apply(List<? extends InputScopeObject> inputs, Map<String, String> attributes, IVariationsInitializationHandle handle) throws RuleException {
        InputNodeIterator itr = this.getIterator(inputs);
        while (itr.hasNext()) {
            INode root;
            INode selectedNode;
            Map<INode, INode> selectedTemporalNodePerHierarchyRoot;
            InputNode node = itr.next();
            if (!node.getConcept().isTemporal() || null == (selectedTemporalNodePerHierarchyRoot = ValidateTemporalNodeForPareto.selectSecondHighestLevelTemporalNodeWithEnoughDistinctValues(node.getModelNode().getModel(), 5L, handle)) || (selectedNode = selectedTemporalNodePerHierarchyRoot.get(root = MetadataHelper.getWholePartHierarchyRoot((INode)node.getModelNode()))) == node.getModelNode()) continue;
            return false;
        }
        return true;
    }

    static Map<INode, INode> selectSecondHighestLevelTemporalNodeWithEnoughDistinctValues(IAssociativeModel model, long minDistinctCount, IVariationsInitializationHandle handle) {
        TemporalNodesMap bestTemporalNodeMap = (TemporalNodesMap)handle.getResource(TemporalNodesMap.class);
        if (bestTemporalNodeMap == null) {
            bestTemporalNodeMap = new TemporalNodesMap();
            for (INode node : model.getNodes()) {
                INode bestTemporalNode;
                IConcept concept = node.getConcept();
                if (!concept.isTemporal() || "cYear".equals(concept.getName())) continue;
                boolean select = false;
                INode root = MetadataHelper.getWholePartHierarchyRoot((INode)node);
                if (null != root) {
                    if (ValidateTemporalNodeForPareto.getDistinctCount(node) >= minDistinctCount) {
                        bestTemporalNode = (INode)bestTemporalNodeMap.get(root);
                        if (null == bestTemporalNode) {
                            select = true;
                        } else if (MetadataHelper.isWholePartHierarchyAncestor((INode)node, (INode)bestTemporalNode)) {
                            select = true;
                        }
                    }
                } else {
                    bestTemporalNode = (INode)bestTemporalNodeMap.get(root);
                    long min = null == bestTemporalNode ? minDistinctCount : ValidateTemporalNodeForPareto.getDistinctCount(bestTemporalNode);
                    if (ValidateTemporalNodeForPareto.getDistinctCount(node) >= min) {
                        select = true;
                    }
                }
                if (!select) continue;
                bestTemporalNodeMap.put(root, node);
            }
            if (bestTemporalNodeMap.size() > 1) {
                bestTemporalNodeMap.remove(null);
            }
            handle.setResource(TemporalNodesMap.class, (Object)bestTemporalNodeMap);
        }
        return bestTemporalNodeMap;
    }

    private static long getDistinctCount(INode node) {
        INode attr = SmdHelper.getDefaultAttribute((INode)node);
        return attr.getDataItem().getStats().distinctCount();
    }

    private static final class TemporalNodesMap
    extends HashMap<INode, INode> {
        private static final long serialVersionUID = 1L;

        private TemporalNodesMap() {
        }
    }
}

