/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.acrarelib.rules;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.acrarelib.rules.ACBaseRule;
import com.ibm.aurora.rare.acrarelib.rules.util.InputNode;
import com.ibm.aurora.rare.acrarelib.rules.util.InputNodeIterator;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.rule.IBooleanRule;
import com.ibm.aurora.rare.smdrules.utils.SmdHelper;
import com.ibm.cognos.aurora.api.model.INode;
import com.ibm.cognos.aurora.api.smd.kb.IConcept;
import com.ibm.cognos.aurora.core.model.MetadataHelper;
import java.util.List;
import java.util.Map;

public class ValidateTemporalNodeForTrend
extends ACBaseRule
implements IBooleanRule {
    private static final long MAX_DISTINCT_COUNT = 12L;

    @Override
    protected boolean skipNodeInContext() {
        return true;
    }

    public Boolean apply(List<? extends InputScopeObject> inputs, Map<String, String> attributes, IVariationsInitializationHandle handle) throws RuleException {
        InputNodeIterator itr = this.getIterator(inputs);
        while (itr.hasNext()) {
            InputNode node = itr.next();
            INode root = MetadataHelper.getWholePartHierarchyRoot((INode)node.getModelNode());
            if (!node.getConcept().isTemporal() || root == null) continue;
            for (INode modelNode : node.getModelNode().getModel().getNodes()) {
                INode modelRoot;
                IConcept concept = modelNode.getConcept();
                if (!concept.isTemporal() || null == (modelRoot = MetadataHelper.getWholePartHierarchyRoot((INode)modelNode)) || modelRoot != root || ValidateTemporalNodeForTrend.getDistinctCount(modelNode) <= ValidateTemporalNodeForTrend.getDistinctCount(node.getModelNode()) || ValidateTemporalNodeForTrend.getDistinctCount(modelNode) > 12L) continue;
                return false;
            }
        }
        return true;
    }

    private static long getDistinctCount(INode node) {
        INode attr = SmdHelper.getDefaultAttribute((INode)node);
        return attr.getDataItem().getStats().distinctCount();
    }
}

