/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.acrarelib.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LoopingIterator<T>
implements Iterator<T> {
    private final List<Iterable<T>> entries = new ArrayList<Iterable<T>>();
    private List<Iterator<T>> current = null;
    private int index = -1;

    public void add(T obj) {
        this.entries.add(new SingleLoopingIterable<T>(obj));
    }

    public void add(Iterable<T> entry) {
        this.entries.add(entry);
    }

    @Override
    public T next() {
        if (this.current == null && this.entries.size() > 0) {
            this.current = new ArrayList<Iterator<T>>();
            for (Iterable<T> entry : this.entries) {
                this.current.add(entry.iterator());
            }
            this.index = 0;
        }
        T next = null;
        if (this.current != null) {
            Iterator<T> itr = this.current.get(this.index);
            if (!itr.hasNext()) {
                itr = this.entries.get(this.index).iterator();
                this.current.set(this.index, itr);
            }
            next = itr.next();
            ++this.index;
            if (this.index >= this.current.size()) {
                this.index = 0;
            }
        }
        return next;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("unsupported operation");
    }

    static final class SingleLoopingIterable<K>
    implements Iterable<K> {
        private final SingleObjectIterator itr;

        public SingleLoopingIterable(K object) {
            this.itr = new SingleObjectIterator(object);
        }

        @Override
        public Iterator<K> iterator() {
            this.itr.reset();
            return this.itr;
        }

        private class SingleObjectIterator
        implements Iterator<K> {
            private final K obj;
            private K next;

            public SingleObjectIterator(K object) {
                this.obj = object;
                this.next = object;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public K next() {
                Object obj = this.next;
                this.next = null;
                return obj;
            }

            @Override
            public void remove() {
                this.next = null;
            }

            public void reset() {
                this.next = this.obj;
            }
        }
    }
}

