/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.acrarelib.util;

import com.ibm.aurora.rare.acrarelib.util.IScoredUniqueValue;
import com.ibm.aurora.rare.acrarelib.util.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OrderedIndexedTree<T extends IScoredUniqueValue>
extends TreeNode<T> {
    private final Map<String, TreeNode<T>> index = new LinkedHashMap<String, TreeNode<T>>();

    public OrderedIndexedTree() {
        super(null);
    }

    @Override
    public TreeNode<T> addChild(T child) {
        TreeNode<T> node = super.addChild(child);
        if (child != null) {
            String key = child.getUniqueKey();
            this.index.put(key, node);
        }
        return node;
    }

    public TreeNode<T> getNode(String key) {
        return this.index.get(key);
    }

    public T getValue(String key) {
        TreeNode<T> node = this.index.get(key);
        if (node != null) {
            return (T)((IScoredUniqueValue)node.getValue());
        }
        return null;
    }

    public void addChildToNode(TreeNode<T> parent, T child) {
        parent.addChild(child);
        String key = child.getUniqueKey();
        this.index.put(key, new TreeNode<T>(child));
    }

    public List<T> getAllValues() {
        ArrayList<T> values = new ArrayList<T>(this.index.size());
        for (TreeNode<T> node : this.index.values()) {
            if (node.getValue() == null || ((IScoredUniqueValue)node.getValue()).isAbstract()) continue;
            values.add(node.getValue());
        }
        return values;
    }

    public List<T> getAllValuesOrdered() {
        List<T> values = this.getAllValues();
        Collections.sort(values, new ScoreComparator());
        return values;
    }

    static final class ScoreComparator<K extends IScoredUniqueValue>
    implements Comparator<K> {
        ScoreComparator() {
        }

        @Override
        public int compare(K o1, K o2) {
            if (o1.getScore() > o2.getScore()) {
                return -1;
            }
            if (o1.getScore() < o2.getScore()) {
                return 1;
            }
            return 0;
        }
    }
}

