/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.wsif.schema.Attribute;
import org.apache.wsif.schema.ComplexContent;
import org.apache.wsif.schema.ComplexType;
import org.apache.wsif.schema.ElementType;
import org.apache.wsif.schema.Extension;
import org.apache.wsif.schema.Restriction;
import org.apache.wsif.schema.SchemaType;
import org.apache.wsif.schema.SequenceElement;
import org.apache.wsif.schema.SimpleType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ASVComplexTypeHolder {
    private static final String OPEN_ELEMENT_START = "<";
    private static final String ELEMENT_END = ">";
    private static final String CLOSE_ELEMENT_EMPTY = "/>";
    private static final String CLOSE_ELEMENT_START = "</";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String EQUALS = "=";
    private static final String QUOTE = "\"";
    private static final String SPACE = " ";
    private static final String PARAMETER = "Parameter";
    private static final String PNAME = "Name";
    private static final String PTYPE = "Type";
    private static final String ENUMERATION = "enumeration";
    private static final String ISSIMPLEJAVATYPE = "SimpleJavaType";
    private static final String ISARRAY = "isArray";
    private static final String DATATYPE = "Datatype";
    private static final String NAMESPACE = "Namespace";
    private static final String ABSTRACT = "abstract";
    private static final int MAX_RECURSION_LEVELS = 8;
    private String m_name = null;
    private String m_type = null;
    private boolean m_isArray = false;
    private boolean m_isSimpleJavaType = false;
    private boolean m_isAbstract = false;
    private boolean m_hasChildren = false;
    private List m_children = new ArrayList();
    private Integer m_arrayDimension = new Integer(0);
    private String m_arrayType = "string";
    private SchemaType m_schemaType = null;
    private Map m_restrictions = new HashMap();
    private boolean m_hasRestrictions = false;
    private List m_complexTypes = null;
    private String m_namespace = "";
    private boolean m_addDetails = true;

    public ASVComplexTypeHolder(SimpleType type, List schemaTypes) {
        QName name = type.getTypeName();
        if (name == null) {
            throw new RuntimeException("QName must have type name declared");
        }
        this.m_namespace = name.getNamespaceURI();
        this.initializeType(schemaTypes, name.getLocalPart(), name.getLocalPart());
    }

    public ASVComplexTypeHolder(Part part, List schemaTypes) {
        QName partType = part.getTypeName();
        if (partType == null) {
            partType = part.getElementName();
        }
        if (partType == null) {
            throw new RuntimeException("part " + part.getName() + " must have type name declared");
        }
        this.m_namespace = partType.getNamespaceURI();
        this.initializeType(schemaTypes, part.getName(), partType.getLocalPart());
    }

    public ASVComplexTypeHolder(Restriction r, List schemaTypes) {
        this.m_complexTypes = schemaTypes;
        this.processRestriction(r);
        this.m_name = "restriction";
        if (this.m_isArray) {
            this.m_type = this.m_arrayType;
        } else {
            this.m_type = r.getBase().getLocalPart();
            this.m_namespace = r.getBase().getNamespaceURI();
        }
    }

    public ASVComplexTypeHolder(NamedNodeMap nnm, List schemaTypes) {
        String name = null;
        name = nnm.getNamedItem(NAME) != null ? nnm.getNamedItem(NAME).getNodeValue() : (nnm.getNamedItem("ref") != null ? nnm.getNamedItem("ref").getNodeValue() : "nameIsNull");
        String value = null;
        if (nnm.getNamedItem(TYPE) != null) {
            value = nnm.getNamedItem(TYPE).getNodeValue();
            int x = value.indexOf(":");
            if (x != -1) {
                value = value.substring(x + 1);
            }
        } else {
            value = name;
        }
        this.initializeType(schemaTypes, name, value);
    }

    public ASVComplexTypeHolder(Extension st, List schemaTypes) {
        Node n;
        Element e = st.getElement();
        ArrayList<NamedNodeMap> children = new ArrayList<NamedNodeMap>();
        String name = e.getLocalName();
        NodeList nl2 = e.getChildNodes();
        for (int k = 0; k < nl2.getLength(); ++k) {
            if (nl2.item(k).getNodeType() != 1) continue;
            Element xsall = (Element)nl2.item(k);
            NodeList nl3 = xsall.getChildNodes();
            for (int y = 0; y < nl3.getLength(); ++y) {
                short nodeType = nl3.item(y).getNodeType();
                if (nodeType != 1) continue;
                NamedNodeMap nnl = nl3.item(y).getAttributes();
                children.add(nnl);
            }
        }
        NamedNodeMap nl = e.getAttributes();
        if (nl != null && (n = nl.getNamedItem("base")) != null) {
            String value = n.getNodeValue();
            int x = value.indexOf(":");
            if (x != -1) {
                value = value.substring(x + 1);
            }
            this.initializeTypeAndChildren(schemaTypes, name, value, children);
        }
    }

    public ASVComplexTypeHolder(QName q, List schemaTypes) {
        String name = q.getLocalPart();
        this.m_namespace = q.getNamespaceURI();
        this.initializeType(schemaTypes, name, name);
    }

    public ASVComplexTypeHolder(ElementType st, List schemaTypes) {
        QName name = st.getTypeName();
        QName partType = st.getElementType();
        this.m_namespace = partType.getNamespaceURI();
        String max = st.getMaxOccurs();
        if (max.compareTo("unbounded") == 0) {
            this.m_isArray = true;
            this.m_arrayType = partType.getLocalPart();
            this.m_arrayDimension = new Integer(Integer.MAX_VALUE);
        } else {
            try {
                int m = Integer.parseInt(max);
                if (m > 1) {
                    this.m_isArray = true;
                    this.m_arrayType = partType.getLocalPart();
                    this.m_arrayDimension = new Integer(m);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.initializeType(schemaTypes, name.getLocalPart(), partType.getLocalPart());
    }

    public ASVComplexTypeHolder(String name, SchemaType st, List schemaTypes) {
        QName partType = st.getTypeName();
        if (partType == null || partType.getLocalPart().length() == 0) {
            partType = st.getArrayType();
        }
        this.m_namespace = partType.getNamespaceURI();
        this.initializeType(schemaTypes, name, partType.getLocalPart());
    }

    public ASVComplexTypeHolder(String name, String type, List schemaTypes) {
        this.initializeType(schemaTypes, name, type);
    }

    public String appendParameter(StringBuffer resultStartBuf) {
        this.appendObject(PARAMETER, resultStartBuf, 0);
        return "";
    }

    public String getName() {
        return this.m_name;
    }

    public String getType() {
        return this.m_type;
    }

    public String getArrayType() {
        return this.m_arrayType;
    }

    public String toString() {
        if (this.isArray()) {
            return this.m_type + "[" + this.m_arrayDimension + "]";
        }
        return this.m_type;
    }

    public boolean isArray() {
        return this.m_isArray;
    }

    public boolean isArrayOfSimpleJavaTypes() {
        return this.computeSimple(this.m_arrayType);
    }

    public boolean isSimpleJavaType() {
        return this.m_isSimpleJavaType;
    }

    public boolean hasRestrictions() {
        return this.m_hasRestrictions;
    }

    public Map getRestrictions() {
        return this.m_restrictions;
    }

    public boolean hasChildren() {
        return this.m_hasChildren;
    }

    public List getChildren() {
        return this.m_children;
    }

    public SchemaType getSchemaType() {
        return this.m_schemaType;
    }

    public boolean isAbstract() {
        return this.m_isAbstract;
    }

    private void initializeTypeAndChildren(List complexTypes, String name, String type, List children) {
        if (children != null && !children.isEmpty()) {
            this.m_hasChildren = true;
            this.m_children.addAll(children);
        }
        this.initializeType(complexTypes, name, type);
    }

    private void initializeType(List complexTypes, String name, String type) {
        this.m_name = name;
        this.m_type = type;
        this.m_complexTypes = complexTypes;
        this.m_isSimpleJavaType = this.computeSimple(type);
        if (!this.m_isSimpleJavaType) {
            this.m_schemaType = this.findType(type);
        }
        if (this.m_schemaType != null) {
            List someChildren;
            if (!this.m_isArray) {
                this.m_isArray = this.m_schemaType.isArray();
                if (this.m_isArray) {
                    this.m_arrayDimension = new Integer(this.m_schemaType.getArrayDimension());
                    this.m_arrayType = this.m_schemaType.getArrayType().getLocalPart();
                }
            }
            if ((someChildren = this.m_schemaType.getChildren()) != null && !someChildren.isEmpty()) {
                this.m_hasChildren = true;
                this.m_children.addAll(someChildren);
            }
            if (this.m_schemaType instanceof ComplexType) {
                List l;
                SequenceElement[] se;
                ComplexContent cc;
                ArrayList childNodes;
                if (((ComplexType)this.m_schemaType).getAbstractAttribute().compareToIgnoreCase("true") == 0) {
                    this.m_isAbstract = true;
                }
                if (!(childNodes = ((ComplexType)this.m_schemaType).getChildElements()).isEmpty()) {
                    this.m_hasChildren = true;
                    this.m_children.addAll(childNodes);
                }
                if ((cc = ((ComplexType)this.m_schemaType).getComplexContent()) != null) {
                    this.processRestriction(cc.getRestriction());
                    Extension e = cc.getExtension();
                    if (e != null) {
                        this.m_hasChildren = true;
                        this.m_children.add(e);
                    }
                }
                if ((se = ((ComplexType)this.m_schemaType).getSequenceElements()).length > 0) {
                    this.m_hasChildren = true;
                    for (int i = 0; i < se.length; ++i) {
                        if (se[i].getElementType() == null) {
                            SchemaType refSchemaType = this.findType(se[i].getTypeName().getLocalPart());
                            if (refSchemaType == null) continue;
                            this.m_children.add(refSchemaType);
                            continue;
                        }
                        this.m_children.add(se[i]);
                    }
                }
                if ((l = ((ComplexType)this.m_schemaType).getChildren()) != null) {
                    this.m_hasChildren = true;
                    this.m_children.addAll(l);
                }
            }
            if (this.m_schemaType instanceof SimpleType) {
                Restriction r = ((SimpleType)this.m_schemaType).getRestriction();
                this.processRestriction(r);
            }
        }
    }

    private void processRestriction(Restriction r) {
        if (r != null) {
            QName base = r.getBase();
            if (base.getLocalPart().compareToIgnoreCase("array") == 0) {
                this.m_isArray = true;
                Attribute[] a = r.getAttributes();
                block0: for (int i = 0; i < a.length; ++i) {
                    Hashtable t = a[i].getAllAttributes();
                    if (t == null) continue;
                    Set ks = t.keySet();
                    for (QName key : ks) {
                        if (key.getLocalPart().compareToIgnoreCase("arrayType") != 0) continue;
                        QName value = (QName)t.get(key);
                        int bracket = value.getLocalPart().indexOf("[]");
                        this.m_arrayType = bracket == -1 ? value.getLocalPart() : value.getLocalPart().substring(0, bracket);
                        this.m_arrayDimension = new Integer(Integer.MAX_VALUE);
                        if (this.computeSimple(this.m_arrayType)) continue block0;
                        SchemaType newSchemaType = this.findType(this.m_arrayType);
                        List newKids = newSchemaType.getChildren();
                        if (newKids != null) {
                            this.m_hasChildren = true;
                            this.m_children.add(newSchemaType.getChildren());
                        }
                        if (newSchemaType instanceof ComplexType) {
                            ComplexType ct = (ComplexType)newSchemaType;
                            ArrayList childElements = ct.getChildElements();
                            ComplexContent cc = ct.getComplexContent();
                            SequenceElement[] se = ct.getSequenceElements();
                            if (childElements != null && !childElements.isEmpty()) {
                                this.m_hasChildren = true;
                                this.m_children.addAll(childElements);
                            }
                            if (cc != null) {
                                if (cc.getExtension() != null) {
                                    this.m_hasChildren = true;
                                    this.m_children.add(cc.getExtension());
                                }
                                this.processRestriction(cc.getRestriction());
                            }
                        }
                        if (!(newSchemaType instanceof SimpleType)) continue block0;
                        SimpleType st = (SimpleType)newSchemaType;
                        this.processRestriction(st.getRestriction());
                        if (st.getExtension() == null) continue block0;
                        this.m_hasChildren = true;
                        this.m_children.add(st.getExtension());
                        continue block0;
                    }
                }
            } else if (!r.getRestrictionElements().isEmpty()) {
                this.m_hasRestrictions = true;
                this.m_restrictions.put("base", base);
                this.m_restrictions.putAll(r.getRestrictionElements());
            }
        }
    }

    private boolean computeSimple(String type) {
        if (type == null) {
            return false;
        }
        if (type.compareToIgnoreCase("string") == 0) {
            return true;
        }
        if (type.compareToIgnoreCase("double") == 0) {
            return true;
        }
        if (type.compareToIgnoreCase("decimal") == 0) {
            return true;
        }
        if (type.compareToIgnoreCase("float") == 0) {
            return true;
        }
        if (type.compareToIgnoreCase("int") == 0) {
            return true;
        }
        if (type.compareToIgnoreCase("integer") == 0) {
            return true;
        }
        if (type.compareToIgnoreCase("boolean") == 0) {
            return true;
        }
        if (type.compareToIgnoreCase("long") == 0) {
            return true;
        }
        if (type.compareToIgnoreCase("dateTime") == 0) {
            return true;
        }
        return type.compareToIgnoreCase("nonNegativeInteger") == 0;
    }

    private void appendBooleanType(StringBuffer resultStartBuf, String theName, boolean theType) {
        resultStartBuf.append(SPACE);
        resultStartBuf.append(theName);
        resultStartBuf.append(EQUALS);
        resultStartBuf.append(QUOTE);
        resultStartBuf.append(theType);
        resultStartBuf.append(QUOTE);
    }

    private void appendObject(String theThing, StringBuffer resultStartBuf, int currentRecursionLevel) {
        resultStartBuf.append(OPEN_ELEMENT_START);
        resultStartBuf.append(theThing);
        resultStartBuf.append(SPACE);
        resultStartBuf.append(PNAME);
        resultStartBuf.append(EQUALS);
        resultStartBuf.append(QUOTE);
        resultStartBuf.append(this.getName());
        resultStartBuf.append(QUOTE);
        resultStartBuf.append(SPACE);
        resultStartBuf.append(PTYPE);
        resultStartBuf.append(EQUALS);
        resultStartBuf.append(QUOTE);
        resultStartBuf.append(this.getType());
        resultStartBuf.append(QUOTE);
        this.appendBooleanType(resultStartBuf, ISSIMPLEJAVATYPE, this.m_isSimpleJavaType);
        this.appendBooleanType(resultStartBuf, ISARRAY, this.m_isArray);
        if (this.m_isArray) {
            resultStartBuf.append(SPACE);
            resultStartBuf.append("arrayMax");
            resultStartBuf.append(EQUALS);
            resultStartBuf.append(QUOTE);
            resultStartBuf.append(this.getArrayDimension());
            resultStartBuf.append(QUOTE);
        }
        if (this.m_isAbstract) {
            this.appendBooleanType(resultStartBuf, ABSTRACT, this.m_isAbstract);
        }
        if (this.m_isSimpleJavaType) {
            resultStartBuf.append(CLOSE_ELEMENT_EMPTY);
        } else {
            resultStartBuf.append(SPACE);
            resultStartBuf.append(NAMESPACE);
            resultStartBuf.append(EQUALS);
            resultStartBuf.append(QUOTE);
            resultStartBuf.append(this.getNamespace());
            resultStartBuf.append(QUOTE);
            resultStartBuf.append(ELEMENT_END);
            if (this.m_addDetails) {
                if (!this.hasChildren()) {
                    Map restrictions = this.getRestrictions();
                    if (this.hasRestrictions()) {
                        String theType = this.getType();
                        for (String key : restrictions.keySet()) {
                            if (key.equalsIgnoreCase(ENUMERATION)) {
                                ArrayList enumeration = (ArrayList)restrictions.get(key);
                                if (enumeration == null) continue;
                                this.appendEnumerationType(resultStartBuf, enumeration);
                                continue;
                            }
                            Object restrictionObj = restrictions.get(key);
                            String value = null;
                            value = restrictionObj instanceof QName ? ((QName)restrictions.get(key)).getLocalPart() : (String)restrictions.get(key);
                            if (value == null) continue;
                            this.appendNameValuePair(resultStartBuf, key, value);
                        }
                    } else if (this.isArray() && !this.isArrayOfSimpleJavaTypes()) {
                        resultStartBuf.append(OPEN_ELEMENT_START);
                        resultStartBuf.append(DATATYPE);
                        resultStartBuf.append(SPACE);
                        resultStartBuf.append(PNAME);
                        resultStartBuf.append(EQUALS);
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(this.getName());
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(SPACE);
                        resultStartBuf.append(PTYPE);
                        resultStartBuf.append(EQUALS);
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(this.getArrayType());
                        resultStartBuf.append(QUOTE);
                        this.appendBooleanType(resultStartBuf, ISSIMPLEJAVATYPE, this.isSimpleJavaType());
                        this.appendBooleanType(resultStartBuf, ISARRAY, true);
                        resultStartBuf.append(SPACE);
                        resultStartBuf.append("arrayMax");
                        resultStartBuf.append(EQUALS);
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(this.getArrayDimension());
                        resultStartBuf.append(QUOTE);
                        if (this.m_isAbstract) {
                            this.appendBooleanType(resultStartBuf, ABSTRACT, this.m_isAbstract);
                        }
                        if (!this.isSimpleJavaType()) {
                            resultStartBuf.append(SPACE);
                            resultStartBuf.append(NAMESPACE);
                            resultStartBuf.append(EQUALS);
                            resultStartBuf.append(QUOTE);
                            resultStartBuf.append(this.getNamespace());
                            resultStartBuf.append(QUOTE);
                        }
                        resultStartBuf.append(ELEMENT_END);
                        if (currentRecursionLevel < 8) {
                            ArrayList<Object> kids = new ArrayList<Object>();
                            SchemaType ct = this.findType(this.getArrayType());
                            if (ct != null) {
                                if (ct.isComplex()) {
                                    kids.add((ComplexType)ct);
                                } else if (ct.isElement()) {
                                    kids.add((ElementType)ct);
                                } else if (ct.isSimple()) {
                                    kids.add((SimpleType)ct);
                                }
                                this.appendChildren(DATATYPE, kids, resultStartBuf, currentRecursionLevel);
                            }
                        }
                        resultStartBuf.append(CLOSE_ELEMENT_START);
                        resultStartBuf.append(DATATYPE);
                        resultStartBuf.append(ELEMENT_END);
                    } else if (this.isArray() && this.isArrayOfSimpleJavaTypes()) {
                        resultStartBuf.append(OPEN_ELEMENT_START);
                        resultStartBuf.append(DATATYPE);
                        resultStartBuf.append(SPACE);
                        resultStartBuf.append(PNAME);
                        resultStartBuf.append(EQUALS);
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(this.getType());
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(SPACE);
                        resultStartBuf.append(PTYPE);
                        resultStartBuf.append(EQUALS);
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(this.getArrayType());
                        resultStartBuf.append(QUOTE);
                        this.appendBooleanType(resultStartBuf, ISSIMPLEJAVATYPE, true);
                        this.appendBooleanType(resultStartBuf, ISARRAY, true);
                        resultStartBuf.append(SPACE);
                        resultStartBuf.append("arrayMax");
                        resultStartBuf.append(EQUALS);
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(this.getArrayDimension());
                        resultStartBuf.append(QUOTE);
                        if (this.m_isAbstract) {
                            this.appendBooleanType(resultStartBuf, ABSTRACT, this.m_isAbstract);
                        }
                        if (!this.isSimpleJavaType()) {
                            resultStartBuf.append(SPACE);
                            resultStartBuf.append(NAMESPACE);
                            resultStartBuf.append(EQUALS);
                            resultStartBuf.append(QUOTE);
                            resultStartBuf.append(this.getNamespace());
                            resultStartBuf.append(QUOTE);
                        }
                        resultStartBuf.append(CLOSE_ELEMENT_EMPTY);
                    } else {
                        resultStartBuf.append(OPEN_ELEMENT_START);
                        resultStartBuf.append(DATATYPE);
                        resultStartBuf.append(SPACE);
                        resultStartBuf.append(PNAME);
                        resultStartBuf.append(EQUALS);
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(this.getName());
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(SPACE);
                        resultStartBuf.append(PTYPE);
                        resultStartBuf.append(EQUALS);
                        resultStartBuf.append(QUOTE);
                        resultStartBuf.append(this.getType());
                        resultStartBuf.append(QUOTE);
                        this.appendBooleanType(resultStartBuf, ISSIMPLEJAVATYPE, this.isSimpleJavaType());
                        this.appendBooleanType(resultStartBuf, ISARRAY, this.isArray());
                        if (this.isArray()) {
                            resultStartBuf.append(SPACE);
                            resultStartBuf.append("arrayMax");
                            resultStartBuf.append(EQUALS);
                            resultStartBuf.append(QUOTE);
                            resultStartBuf.append(this.getArrayDimension());
                            resultStartBuf.append(QUOTE);
                        }
                        if (this.m_isAbstract) {
                            this.appendBooleanType(resultStartBuf, ABSTRACT, this.m_isAbstract);
                        }
                        if (!this.isSimpleJavaType()) {
                            resultStartBuf.append(SPACE);
                            resultStartBuf.append(NAMESPACE);
                            resultStartBuf.append(EQUALS);
                            resultStartBuf.append(QUOTE);
                            resultStartBuf.append(this.getNamespace());
                            resultStartBuf.append(QUOTE);
                        }
                        resultStartBuf.append(CLOSE_ELEMENT_EMPTY);
                    }
                } else {
                    List kids = this.getChildren();
                    if (!kids.isEmpty() && currentRecursionLevel < 8) {
                        this.appendChildren(DATATYPE, kids, resultStartBuf, currentRecursionLevel);
                    }
                }
            }
            resultStartBuf.append(CLOSE_ELEMENT_START);
            resultStartBuf.append(theThing);
            resultStartBuf.append(ELEMENT_END);
        }
    }

    private void appendNameValuePair(StringBuffer resultStartBuf, String key, String value) {
        if (key != null && value != null) {
            resultStartBuf.append(OPEN_ELEMENT_START);
            resultStartBuf.append(key);
            resultStartBuf.append(ELEMENT_END);
            resultStartBuf.append(value);
            resultStartBuf.append(CLOSE_ELEMENT_START);
            resultStartBuf.append(key);
            resultStartBuf.append(ELEMENT_END);
        }
    }

    private void appendEnumerationType(StringBuffer resultStartBuf, ArrayList enumeration) {
        Iterator i = enumeration.iterator();
        resultStartBuf.append(OPEN_ELEMENT_START);
        resultStartBuf.append(ENUMERATION);
        resultStartBuf.append(ELEMENT_END);
        if (i.hasNext()) {
            resultStartBuf.append((String)i.next());
        }
        while (i.hasNext()) {
            resultStartBuf.append("," + (String)i.next());
        }
        resultStartBuf.append(CLOSE_ELEMENT_START);
        resultStartBuf.append(ENUMERATION);
        resultStartBuf.append(ELEMENT_END);
    }

    private SchemaType findType(String type) {
        ComplexType schemaType = null;
        for (SchemaType o : this.m_complexTypes) {
            ComplexType s;
            if (o instanceof ComplexType) {
                s = (ComplexType)o;
                if (s.getTypeName().getLocalPart().compareToIgnoreCase(type) != 0) continue;
                schemaType = s;
                break;
            }
            if (o instanceof ElementType) {
                s = (ElementType)o;
                if (s.getTypeName().getLocalPart().compareToIgnoreCase(type) != 0) continue;
                schemaType = s;
                break;
            }
            if (!(o instanceof SimpleType) || (s = (SimpleType)o).getTypeName().getLocalPart().compareToIgnoreCase(type) != 0) continue;
            schemaType = s;
            break;
        }
        return schemaType;
    }

    private void appendChildren(String theThing, List kids, StringBuffer resultStartBuf, int currentRecursionLevel) {
        if (kids != null) {
            ++currentRecursionLevel;
            for (int j = 0; j < kids.size(); ++j) {
                ASVComplexTypeHolder cth;
                Object st = kids.get(j);
                if (st instanceof ComplexType) {
                    Extension e;
                    ComplexContent cc;
                    ASVComplexTypeHolder cth2;
                    SequenceElement[] se = ((ComplexType)st).getSequenceElements();
                    if (se != null) {
                        for (int k = 0; k < se.length; ++k) {
                            SequenceElement e2 = se[k];
                            cth2 = new ASVComplexTypeHolder((ElementType)e2, this.m_complexTypes);
                            cth2.appendObject(theThing, resultStartBuf, currentRecursionLevel);
                        }
                    }
                    if ((cc = ((ComplexType)st).getComplexContent()) == null) continue;
                    Restriction r = cc.getRestriction();
                    if (r != null) {
                        cth2 = new ASVComplexTypeHolder(r, this.m_complexTypes);
                        cth2.appendObject(theThing, resultStartBuf, currentRecursionLevel);
                    }
                    if ((e = cc.getExtension()) == null) continue;
                    ASVComplexTypeHolder cth3 = new ASVComplexTypeHolder(e, this.m_complexTypes);
                    cth3.appendObject(theThing, resultStartBuf, currentRecursionLevel);
                    continue;
                }
                if (st instanceof ElementType) {
                    cth = new ASVComplexTypeHolder((ElementType)st, this.m_complexTypes);
                    cth.appendObject(theThing, resultStartBuf, currentRecursionLevel);
                    continue;
                }
                if (st instanceof QName) {
                    cth = new ASVComplexTypeHolder((QName)st, this.m_complexTypes);
                    cth.appendObject(theThing, resultStartBuf, currentRecursionLevel);
                    continue;
                }
                if (st instanceof Extension) {
                    cth = new ASVComplexTypeHolder((Extension)st, this.m_complexTypes);
                    cth.appendObject(theThing, resultStartBuf, currentRecursionLevel);
                    continue;
                }
                if (st instanceof NamedNodeMap) {
                    cth = new ASVComplexTypeHolder((NamedNodeMap)st, this.m_complexTypes);
                    cth.appendObject(theThing, resultStartBuf, currentRecursionLevel);
                    continue;
                }
                if (st instanceof Part) {
                    cth = new ASVComplexTypeHolder((Part)st, this.m_complexTypes);
                    cth.appendObject(theThing, resultStartBuf, currentRecursionLevel);
                    continue;
                }
                if (st instanceof SimpleType) {
                    cth = new ASVComplexTypeHolder((SimpleType)st, this.m_complexTypes);
                    cth.appendObject(theThing, resultStartBuf, currentRecursionLevel);
                    continue;
                }
                System.out.println("unknown class" + st);
            }
        }
    }

    private String getNamespace() {
        return this.m_namespace;
    }

    private void setNamespace(String namespace) {
        this.m_namespace = namespace;
    }

    private Integer getArrayDimension() {
        return this.m_arrayDimension;
    }
}

