/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.AgentTask;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.ResolveOptionsUtil;
import com.cognos.asv.ResolveParametersUtil;
import com.cognos.asv.TaskRun;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.parameters.MissingParameterHandler;
import com.cognos.asv.parameters.TaskParameterInfo;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseParameter;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.MultilingualTokenProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RunConditionEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.event.EventStatusUtil;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.AsyncConversation;
import com.cognos.jsmcommon.soap.util.AsyncConversationStatusListener;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.tse.run.commands.SaveReportPathCmdSpec;
import com.cognos.jsmcommon.tse.run.commands.SaveTaskInfoCmdSpec;
import com.cognos.jsmcommon.tse.run.commands.SetHistoryParametersCmdSpec;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class BaseAgentTaskTarget
extends BaseStepObject
implements AsyncConversationStatusListener {
    private AsyncConversation m_conversation = new AsyncConversation();
    private ArrayList<CmdSpec> tseRunCommands;
    private static int reportVarCounter = 1000;

    public BaseAgentTaskTarget(BaseClass base, BaseStepObject parent, JobBiBusHeaders headers) {
        super(base, parent, headers);
        this.m_conversation.addStatusListener((AsyncConversationStatusListener)this);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.getConversation().cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.getConversation().isCancelled();
    }

    @Override
    public void run(AgentAction action) throws AgentServiceException {
        if (this.isCancelled()) {
            this.setStatus(EventStatus.CANCELLED);
            return;
        }
        Option[] options = ResolveOptionsUtil.resolveOptions(this);
        ParameterValue[] parameters = ResolveParametersUtil.resolveParameters(this);
        parameters = ResolveParametersUtil.trimToTargetParams(parameters, this, this.getResultSet());
        try {
            action.runAgentTaskTarget(Client.ServiceEnum.MONITOR_SERVICE, this.getSearchPath(), parameters, options);
        }
        catch (LocalizableException ase) {
            throw new AgentServiceException(ase);
        }
    }

    public BaseAgent getBaseAgent() {
        for (BaseStepObject step = this; step != null; step = step.getParent()) {
            if (!(step instanceof BaseAgent)) continue;
            return (BaseAgent)step;
        }
        return null;
    }

    public AgentTask getBaseTask() {
        for (BaseStepObject step = this; step != null; step = step.getParent()) {
            if (!(step instanceof AgentTask)) continue;
            return (AgentTask)step;
        }
        return null;
    }

    public boolean getByPassExecution() {
        boolean bypassed = false;
        for (BaseStepObject stepObj = this; stepObj != null; stepObj = stepObj.getParent()) {
            if (!(stepObj instanceof AgentTask)) continue;
            bypassed = ((AgentTask)stepObj).byPassedExecution();
        }
        return bypassed;
    }

    public ResultSet getResultSet() {
        ResultSet result = null;
        for (BaseStepObject stepObj = this; result == null && stepObj != null; stepObj = stepObj.getParent()) {
            if (!(stepObj instanceof AgentTask)) continue;
            result = ((AgentTask)stepObj).getResultSet();
        }
        return result;
    }

    public AsyncConversation getConversation() {
        return this.m_conversation;
    }

    protected String getName() {
        return this.getParent().getBaseClass().getDefaultName() != null ? this.getParent().getBaseClass().getDefaultName().getValue() : "";
    }

    public void updateConversationStatus(AsynchReply reply, AsynchReplyStatusEnum replyStatus) {
        if (replyStatus != null) {
            this.setStatus(EventStatusUtil.getEventStatus((AsynchReplyStatusEnum)replyStatus));
        } else {
            this.setStatus(EventStatus.FAILED);
        }
    }

    public void onConversationCancel() {
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        try {
            Option[] options = ResolveOptionsUtil.resolveOptions(this);
            ParameterValue[] parameters = ResolveParametersUtil.resolveParameters(this);
            parameters = ResolveParametersUtil.trimToTargetParams(parameters, this, this.getResultSet());
            TaskRunInfo taskRunInfo = new TaskRunInfo(options, parameters);
            previewResult.addTaskRun(new TaskRun((BaseStepObject)this, new TaskRunInfo[]{taskRunInfo}));
        }
        catch (AgentServiceException e) {
            previewResult.addTaskRun(new TaskRun((BaseStepObject)this, true));
            throw e;
        }
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        try {
            ParameterValue[] parameters = ResolveParametersUtil.resolveParameters(this);
            parameters = ResolveParametersUtil.trimToTargetParams(parameters, this, this.getResultSet());
            TaskParameterInfo taskParameterInfo = this.getBaseTask().getParameterInfo();
            MissingParameterHandler mph = new MissingParameterHandler(validateResult, taskParameterInfo.getTargetParameters());
            mph.validateMissingParameters(this.getBaseTask(), taskParameterInfo.getTargetParameters(), parameters, this.getResultSet());
        }
        catch (AgentServiceException e) {
            validateResult.addValidationMessage(new I18NMessage(e.getI18NCode(), e.getParams(), e.getSeverity()));
        }
    }

    public SeverityEnum getMaximumValidationSeverity() {
        return SeverityEnum.warn;
    }

    public void clearTseCommand() {
        if (this.tseRunCommands != null) {
            this.tseRunCommands.clear();
        }
    }

    public void addTseCommands(CmdSpec[] cmds) {
        if (this.tseRunCommands == null) {
            this.tseRunCommands = new ArrayList();
        }
        for (int i = 0; i != cmds.length; ++i) {
            this.tseRunCommands.add(cmds[i]);
        }
    }

    public void preQueueTask(BiBusRunSpec spec) {
        RunConditionEnum rc = this.getBaseTask().getTaskRunCondition();
        if (rc.equals((Object)RunConditionEnum.runOnFailure)) {
            this.addTseFailCommands();
        }
        if (this.tseRunCommands != null) {
            ArrayList<CmdSpec> mergedCmds = new ArrayList<CmdSpec>();
            mergedCmds.addAll(this.tseRunCommands);
            if (spec.runCommands != null) {
                mergedCmds.addAll(Arrays.asList(spec.runCommands));
            }
            spec.runCommands = mergedCmds.toArray(new CmdSpec[0]);
        }
    }

    protected void addTseFailCommands() {
        this.addTseCommands(new CmdSpec[]{new SetHistoryParametersCmdSpec()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTargetName(String locale) {
        if (locale == null) {
            return null;
        }
        String reportName = null;
        PropEnum[] props = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName, PropEnum.name};
        ContentManagerServiceClientPort cmPort = null;
        try {
            cmPort = Client.instance().getContentManagerServiceClient(this.getHeaders());
            BaseClass[] reports = cmPort.query(this.getBaseClass().getSearchPath().getValue(), props, null, null);
            if (reports != null && reports.length > 0) {
                MultilingualTokenProp name = reports[0].getName();
                MultilingualToken[] names = name.getValue();
                if (names != null) {
                    for (int i = 0; i < names.length; ++i) {
                        if (!names[i].getLocale().equals(locale)) continue;
                        reportName = names[i].getValue();
                        break;
                    }
                }
                if (reportName == null) {
                    reportName = reports[0].getDefaultName().getValue();
                }
            }
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("Cannot resolve reportName");
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug((Throwable)e);
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("Cannot resolve reportName");
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug((Throwable)e);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return reportName;
    }

    public String saveOutputToVariable() {
        String reportSPVarName = "report" + ++reportVarCounter + "sp";
        SaveReportPathCmdSpec cmd = new SaveReportPathCmdSpec(reportSPVarName, this.getBaseAgent().getParentTaskID());
        this.addTseCommands(new CmdSpec[]{cmd});
        return reportSPVarName;
    }

    public boolean SaveReportPathCmdExistsForTaskID() {
        if (this.tseRunCommands != null) {
            for (CmdSpec specNext : this.tseRunCommands) {
                TaskID theTaskID;
                if (!(specNext instanceof SaveReportPathCmdSpec) || !((SaveReportPathCmdSpec)specNext).taskID.equals((theTaskID = this.getBaseAgent().getParentTaskID()).toString())) continue;
                return true;
            }
        }
        return false;
    }

    public SaveReportPathCmdSpec getSaveReportPathCmdForTaskID() {
        SaveReportPathCmdSpec ret_value = null;
        if (this.tseRunCommands != null) {
            for (CmdSpec specNext : this.tseRunCommands) {
                TaskID theTaskID;
                if (!(specNext instanceof SaveReportPathCmdSpec) || !((SaveReportPathCmdSpec)specNext).taskID.equals((theTaskID = this.getBaseAgent().getParentTaskID()).toString())) continue;
                ret_value = (SaveReportPathCmdSpec)specNext;
                break;
            }
        }
        return ret_value;
    }

    public String saveTaskInfoVariable() {
        String reportVarName = "taskInfo" + this.getStoreID().get_value();
        SaveTaskInfoCmdSpec cmd = new SaveTaskInfoCmdSpec(reportVarName, this.getBaseAgent().getParentTaskID());
        this.addTseCommands(new CmdSpec[]{cmd});
        return reportVarName;
    }

    public boolean SaveTaskInfoCmdExistsForTaskID() {
        if (this.tseRunCommands != null) {
            for (CmdSpec specNext : this.tseRunCommands) {
                TaskID theTaskID;
                if (!(specNext instanceof SaveTaskInfoCmdSpec) || !((SaveTaskInfoCmdSpec)specNext).taskID.equals((theTaskID = this.getBaseAgent().getParentTaskID()).toString())) continue;
                return true;
            }
        }
        return false;
    }

    public SaveTaskInfoCmdSpec getSaveTaskInfoCmdSpecForTaskID() {
        SaveTaskInfoCmdSpec ret_value = null;
        if (this.tseRunCommands != null) {
            for (CmdSpec specNext : this.tseRunCommands) {
                TaskID theTaskID;
                if (!(specNext instanceof SaveTaskInfoCmdSpec) || !((SaveTaskInfoCmdSpec)specNext).taskID.equals((theTaskID = this.getBaseAgent().getParentTaskID()).toString())) continue;
                ret_value = (SaveTaskInfoCmdSpec)specNext;
                break;
            }
        }
        return ret_value;
    }

    public BaseParameter[] getTargetParameters(ResultSet agentResultSet) throws AgentServiceException {
        BaseParameter[] targetParameters = null;
        AgentTask agentTask = this.getBaseTask();
        ParameterValue[] connectionParams = ResolveParametersUtil.resolveConnectionParameters(this, agentResultSet);
        targetParameters = this.getTargetParametersImpl(connectionParams);
        return targetParameters;
    }

    protected BaseParameter[] getTargetParametersImpl(ParameterValue[] connectionParameters) throws AgentServiceException {
        return null;
    }
}

