/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.TaskRun;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.xhtml.descriptors.AttachmentDescriptor;
import com.cognos.asv.xhtml.descriptors.DeliveryOptionDescriptor;
import com.cognos.asv.xhtml.descriptors.RssOptionDescriptor;
import com.cognos.asv.xhtml.descriptors.TaskRunDescriptor;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.BaseRSSTask;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.HistoryDetailReportService;
import com.cognos.developer.schemas.bibus._3.Memo;
import com.cognos.developer.schemas.bibus._3.MemoPartAgentObject;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.MultilingualTokenProp;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportVersion;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.AxisUtils;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.TaskHistoryDetailRecord;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.spec.previewAgent.castor.AgentPreview;
import com.cognos.spec.previewAgent.castor.AgentTaskPreview;
import com.cognos.spec.previewAgent.castor.Attachment;
import com.cognos.spec.previewAgent.castor.Attachments;
import com.cognos.spec.previewAgent.castor.Link;
import com.cognos.spec.previewAgent.castor.Links;
import com.cognos.spec.previewAgent.castor.MemoPreview;
import com.cognos.spec.previewAgent.castor.NewsitemPreview;
import com.cognos.spec.previewAgent.castor.OutputInfo;
import com.cognos.spec.previewAgent.castor.OutputInfos;
import com.cognos.spec.previewAgent.castor.TaskOptions;
import com.cognos.spec.previewAgent.castor.TaskParameters;
import com.cognos.spec.previewAgent.castor.TaskRunPreview;
import com.cognos.spec.previewAgent.castor.TaskRunPreviewChoice;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

public class InactiveAgentPreview {
    private JobBiBusHeaders m_headers;
    private Locale m_locale;
    private static final String PARAMETERS = "parameters";
    private static final String OPTIONS = "options";

    public InactiveAgentPreview(JobBiBusHeaders headers) {
        this.m_headers = headers;
        this.m_locale = LocaleUtil.getProductLocale((BiBusHeader)headers.getBiBusHeader());
    }

    public String buildAgentPreviewXml(BaseAgent agent, List taskRuns) throws AgentServiceException {
        if (agent == null) {
            return "<agentPreview/>";
        }
        AgentPreview agentPreview = new AgentPreview();
        agentPreview.setAgentStoreId(agent == null ? null : agent.getBaseClass().getStoreID().getValue().get_value());
        agentPreview.setName(agent == null ? null : agent.getBaseClass().getDefaultName().getValue());
        for (int i = 0; i < taskRuns.size(); ++i) {
            TaskRunDescriptor taskRunDescriptor = new TaskRunDescriptor((TaskRun)taskRuns.get(i));
            agentPreview.addAgentTaskPreview(this.buildAgentTaskPreview(taskRunDescriptor));
        }
        StringWriter writer = new StringWriter();
        try {
            Marshaller marsh = new Marshaller((Writer)writer);
            marsh.setMarshalAsDocument(false);
            marsh.marshal((Object)agentPreview);
        }
        catch (IOException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
        }
        catch (MarshalException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
        }
        catch (ValidationException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
        }
        return writer.toString();
    }

    private AgentTaskPreview buildAgentTaskPreview(TaskRunDescriptor taskRunDescriptor) throws AgentServiceException {
        BaseClass baseClass = taskRunDescriptor.getTaskRun().task().getBaseClass();
        AgentTaskPreview task = new AgentTaskPreview();
        task.setName(taskRunDescriptor.buildTaskName());
        task.setTargetStoreId(baseClass.getStoreID().getValue().get_value());
        task.setFailed(taskRunDescriptor.getTaskRun().failed());
        TaskRunInfo[] taskRunInfos = taskRunDescriptor.getTaskRun().runInfo();
        for (int i = 0; taskRunInfos != null && i < taskRunInfos.length; ++i) {
            task.addTaskRunPreview(this.getTaskRunPreview(baseClass, taskRunInfos[i]));
        }
        return task;
    }

    private OutputInfo[] buildAgentTaskOutput(BaseClass baseClass, TaskRunInfo info) throws AgentServiceException {
        if (baseClass instanceof ReportView && baseClass.getDefaultName() != null && baseClass.getDefaultName().getValue().equals("Condition")) {
            return null;
        }
        String eventId = info.getEventId();
        if (eventId == null) {
            return null;
        }
        String name = null;
        Locale locale = this.m_headers.getLocale();
        MultilingualTokenProp mltp = baseClass.getName();
        if (mltp != null && mltp.getValue() != null) {
            MultilingualToken[] mltArray = mltp.getValue();
            for (int i = 0; i < mltArray.length; ++i) {
                if (!mltArray[i].getLocale().equalsIgnoreCase(locale.toString())) continue;
                name = mltArray[i].getValue();
                break;
            }
        }
        if (name == null) {
            name = baseClass.getDefaultName().getValue();
        }
        ArrayList<OutputInfo> outputInfoList = new ArrayList<OutputInfo>();
        TaskID taskId = TaskID.create((String)eventId);
        TaskHistoryDetailRecord thdr = new TaskHistoryDetailRecord(taskId);
        try {
            BaseHistoryDetail[] details = thdr.readAll();
            for (int i = 0; i < details.length; ++i) {
                HistoryDetailReportService hdrs;
                BaseClassArrayProp bcap;
                BaseClass[] value;
                if (!(details[i] instanceof HistoryDetailReportService) || !((value = (bcap = (hdrs = (HistoryDetailReportService)details[i]).getOutput()).getValue())[0] instanceof ReportVersion)) continue;
                ReportVersion reportVersion = (ReportVersion)value[0];
                Output[] outputs = this.getOutputs(reportVersion);
                for (int j = 0; j < outputs.length; ++j) {
                    OutputInfo outputInfo = new OutputInfo();
                    outputInfo.setId(outputs[j].getStoreID().getValue().get_value());
                    outputInfo.setFormat(outputs[j].getFormat().getValue());
                    outputInfo.setLocale(outputs[j].getLocale().getValue());
                    outputInfo.setName(name);
                    outputInfoList.add(outputInfo);
                }
            }
        }
        catch (TaskPersistLayerException e) {
            throw new AgentServiceException((LocalizableException)((Object)e));
        }
        return outputInfoList.toArray(new OutputInfo[0]);
    }

    private Output[] getOutputs(ReportVersion reportVersion) throws AgentServiceException {
        ArrayList<Output> outputsList = new ArrayList<Output>();
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(this.m_headers);
        cmPort.setLogCategory(ASVCategory.RUNTIME);
        try {
            String outputStoreIdPath = reportVersion.getSearchPath().getValue() + "/output";
            PropEnum[] options = new PropEnum[]{PropEnum.storeID, PropEnum.defaultName, PropEnum.name, PropEnum.defaultOutputFormat, PropEnum.format, PropEnum.locale};
            QueryOptions queryOptions = new QueryOptions();
            BaseClass[] bases = cmPort.query(outputStoreIdPath, options, null, queryOptions);
            if (bases != null && bases.length > 0) {
                for (int i = 0; i < bases.length; ++i) {
                    outputsList.add((Output)bases[i]);
                }
            }
        }
        catch (SDKClientException e) {
            throw new AgentServiceException((LocalizableException)((Object)e));
        }
        catch (EMFSecurityException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        finally {
            cmPort.close();
        }
        return outputsList.toArray(new Output[0]);
    }

    private TaskRunPreview getTaskRunPreview(BaseClass baseClass, TaskRunInfo info) throws AgentServiceException {
        try {
            OutputInfo[] outputInfoArray;
            TaskRunPreview taskRunPreview = new TaskRunPreview();
            taskRunPreview.setEventId(info.getEventId());
            String options = AxisUtils.getInstance().serialize((Object)info.options(), new QName(OPTIONS));
            String parameters = AxisUtils.getInstance().serialize((Object)info.parameters(), new QName(PARAMETERS));
            TaskOptions optionsAny = (TaskOptions)Unmarshaller.unmarshal(TaskOptions.class, (Reader)new StringReader("<options>" + options + "</" + OPTIONS + ">"));
            TaskParameters parametersAny = (TaskParameters)Unmarshaller.unmarshal(TaskParameters.class, (Reader)new StringReader("<parameters>" + parameters + "</" + PARAMETERS + ">"));
            taskRunPreview.setTaskParameters(parametersAny);
            taskRunPreview.setTaskOptions(optionsAny);
            TaskRunPreviewChoice previewChoice = new TaskRunPreviewChoice();
            if (baseClass instanceof Memo) {
                DeliveryOptionDescriptor delDesc = new DeliveryOptionDescriptor(this.m_headers, info.options());
                MemoPreview memo = new MemoPreview();
                memo.setEmail_bcc(delDesc.getEmailBCC());
                memo.setEmail_cc(delDesc.getEmailCC());
                memo.setEmail_to(delDesc.getEmailTo());
                memo.setHtml_body(delDesc.getHTMLBody());
                memo.setTxt_body(delDesc.getEmailTxtBody());
                memo.setSubject(delDesc.getEmailSubject());
                memo.addLinks(this.makeLinks(delDesc.getLinks()));
                memo.addAttachments(this.makeAttachments(delDesc.getAttachments()));
                previewChoice.setMemoPreview(memo);
                taskRunPreview.setTaskRunPreviewChoice(previewChoice);
            } else if (baseClass instanceof BaseRSSTask) {
                RssOptionDescriptor rssdesc = new RssOptionDescriptor(info.options());
                NewsitemPreview rssPreview = new NewsitemPreview();
                rssPreview.setCreate(rssdesc.isCreate());
                rssPreview.setDelete(rssdesc.isDelete());
                rssPreview.setDescription(rssdesc.getDescription());
                rssPreview.setHeadline(rssdesc.getHeadline());
                rssPreview.setScreenTip(rssdesc.getScreenTip());
                rssPreview.setTarget(rssdesc.getTarget());
                rssPreview.setURI(rssdesc.getURI());
                previewChoice.setNewsitemPreview(rssPreview);
                taskRunPreview.setTaskRunPreviewChoice(previewChoice);
            } else if ((baseClass instanceof Report || baseClass instanceof ReportView) && (outputInfoArray = this.buildAgentTaskOutput(baseClass, info)) != null && outputInfoArray.length > 0) {
                OutputInfos outputInfos = new OutputInfos();
                outputInfos.setOutputInfo(outputInfoArray);
                taskRunPreview.setOutputInfos(outputInfos);
                taskRunPreview.setStatus("COMPLETED");
            }
            return taskRunPreview;
        }
        catch (Exception e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
        }
    }

    private Links makeLinks(List linksObjects) {
        Links links = new Links();
        for (int i = 0; i < linksObjects.size(); ++i) {
            Link link = new Link();
            ObjectLink objectLink = (ObjectLink)linksObjects.get(i);
            link.setLabel(objectLink.getLabel());
            link.setSearchPath(objectLink.getSearchPath().get_value());
            links.addLink(link);
        }
        return links;
    }

    private Attachments makeAttachments(List memoPartObjects) {
        Attachments attachments = new Attachments();
        for (int i = 0; i < memoPartObjects.size(); ++i) {
            AttachmentDescriptor attachmentDescriptor = new AttachmentDescriptor((MemoPartAgentObject)memoPartObjects.get(i), this.m_locale, this.m_headers.getBiBusHeader());
            Attachment attach = new Attachment();
            attach.setImage(attachmentDescriptor.getAttachmentImage());
            attach.setName(attachmentDescriptor.getAttachmentName());
            attachments.addAttachment(attach);
        }
        return attachments;
    }
}

