/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.TaskRun;
import com.cognos.asv.agent.Agent;
import com.cognos.asv.formatters.XMLDecodeFormatter;
import com.cognos.asv.formatters.XMLEncodeFormatter;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.reportTemplates.TemplateBuilder;
import com.cognos.asv.reportTemplates.TemplateTransformer;
import com.cognos.asv.resultset.ResultSetPartition;
import com.cognos.asv.xhtml.XHTML;
import com.cognos.asv.xhtml.XHTMLGetTextResult;
import com.cognos.asv.xhtml.XHTMLNode;
import com.cognos.asv.xhtml.XHTMLSAXHandler;
import com.cognos.asv.xhtml.XHTML_PreviewVisitor;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.Base64BinaryMIMEProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.LanguageProp;
import com.cognos.developer.schemas.bibus._3.NmtokenProp;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ZipUtils;
import com.cognos.jsmcommon.util.datasource.DataSourceFactory;
import com.cognos.jsmcommon.util.datasource.NCDataSource;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Locale;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axis.attachments.AttachmentPart;

public class PreviewResultHandler {
    private Agent m_agent;
    private ArrayList m_taskRuns = new ArrayList();
    private int m_maxRows;

    public PreviewResultHandler(Agent agent) {
        this.m_agent = agent;
        this.m_maxRows = CRNProperties.getInstance().getIntProperty("asv.preview.maxRows", 500);
    }

    public void addTaskRun(TaskRun taskRun) {
        this.m_taskRuns.add(taskRun);
    }

    public String generatePreview(JobBiBusHeaders headers) throws AgentServiceException {
        int numRows = this.m_agent.getResultSet().numDataItems();
        Integer truncatedTo = null;
        Integer truncatedFrom = null;
        if (numRows > this.m_maxRows) {
            ArrayList truncated = (ArrayList)this.m_agent.getResultSet().asCollection(new ArrayList());
            truncated.subList(this.m_maxRows, truncated.size()).clear();
            truncated.trimToSize();
            ResultSetPartition partition = new ResultSetPartition(this.m_agent.getResultSet(), "", truncated);
            this.m_agent.setResultSet(partition);
            truncatedFrom = new Integer(numRows);
            truncatedTo = new Integer(this.m_maxRows);
        }
        String intermediateXMLTemplate = TemplateBuilder.instance().build("/com/cognos/asv/reportTemplates/previewReport.xml", headers);
        Locale userPrefLocale = headers.getProductLocale();
        intermediateXMLTemplate = this.localizePreview(new StringBuffer(intermediateXMLTemplate), userPrefLocale);
        XHTMLNode previewRootNode = null;
        String previewPath = null;
        if (intermediateXMLTemplate != null) {
            XHTMLSAXHandler handler = new XHTMLSAXHandler();
            XHTML XHTML_processor = new XHTML(new StringReader(intermediateXMLTemplate), handler);
            XHTML_processor.parse();
            previewRootNode = handler.getRoot();
            previewRootNode.visit(new XHTML_PreviewVisitor(this.m_agent, this.m_taskRuns, headers, truncatedTo, truncatedFrom));
        }
        if (previewRootNode != null) {
            XHTMLGetTextResult previewGetTextResult = previewRootNode.getText(new XMLEncodeFormatter(), new XMLDecodeFormatter());
            TemplateTransformer templateTransformer = new TemplateTransformer();
            String previewContent = templateTransformer.transformData(previewGetTextResult.getReader());
            previewPath = this.savePreview(headers, previewContent);
        }
        return previewPath;
    }

    private String localizePreview(StringBuffer convertStrBfr, Locale userPrefLocale) {
        String convertStr = convertStrBfr.toString();
        String toStr = I18NUtil.getMessage((I18NCode)I18NCode.MSG_PREVIEW_EMAIL_TO, null, (Locale)LocaleUtil.createProductLocale((String)userPrefLocale.toString()));
        String ccStr = I18NUtil.getMessage((I18NCode)I18NCode.MSG_PREVIEW_EMAIL_CC, null, (Locale)LocaleUtil.createProductLocale((String)userPrefLocale.toString()));
        String bccStr = I18NUtil.getMessage((I18NCode)I18NCode.MSG_PREVIEW_EMAIL_BCC, null, (Locale)LocaleUtil.createProductLocale((String)userPrefLocale.toString()));
        String subjStr = I18NUtil.getMessage((I18NCode)I18NCode.MSG_PREVIEW_EMAIL_SUBJECT, null, (Locale)LocaleUtil.createProductLocale((String)userPrefLocale.toString()));
        try {
            convertStr = convertStr.replaceAll("To:", toStr);
            convertStr = convertStr.replaceAll("Cc:", ccStr);
            convertStr = convertStr.replaceAll("Bcc:", bccStr);
            convertStr = convertStr.replaceAll("Subject:", subjStr);
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_STORE_PREVIEW_ERROR, new Object[]{e.getMessage()});
        }
        return convertStr;
    }

    private String savePreview(JobBiBusHeaders headers, String previewContent) throws AgentServiceException {
        BaseClass addedOutput = null;
        ContentManagerServiceClientPort cmsp = Client.instance().getContentManagerServiceClient(headers);
        try {
            AddOptions addOptions = new AddOptions();
            addOptions.setDataEncoding(EncodingEnum.MIME);
            addOptions.setReturnProperties(new PropEnum[]{PropEnum.searchPath});
            addOptions.setUpdateAction(UpdateActionEnum.fail);
            Output previewOutput = new Output();
            NmtokenProp format = new NmtokenProp();
            format.setValue("HTML");
            previewOutput.setFormat(format);
            LanguageProp language = new LanguageProp();
            String languageString = headers.getLocale().toString();
            languageString = languageString.replace('_', '-').toLowerCase();
            language.setValue(languageString);
            previewOutput.setLocale(language);
            AttachmentPart ap = this.getZippedAttachmentPart(previewContent);
            Base64BinaryMIMEProp data = new Base64BinaryMIMEProp();
            try {
                String content = "[attribute]" + ap.getContentIdRef();
                data.setValue(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            previewOutput.setData(data);
            cmsp.addAttachment((Object)ap);
            addedOutput = cmsp.add("~~", (BaseClass)previewOutput, addOptions);
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_STORE_PREVIEW_ERROR, new Object[]{e.getMessage()});
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_STORE_PREVIEW_ERROR, new Object[]{e.getMessage()});
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_STORE_PREVIEW_ERROR, new Object[]{e.getMessage()});
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_STORE_PREVIEW_ERROR, new Object[]{e.getMessage()});
        }
        catch (UnsupportedEncodingException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_STORE_PREVIEW_ERROR, new Object[]{e.getMessage()});
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_STORE_PREVIEW_ERROR, new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_STORE_PREVIEW_ERROR, new Object[]{e.getMessage()});
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_STORE_PREVIEW_ERROR, new Object[]{e.getMessage()});
        }
        finally {
            cmsp.close();
        }
        return addedOutput.getSearchPath().getValue();
    }

    private AttachmentPart getZippedAttachmentPart(String content) throws UnsupportedEncodingException, IOException {
        NCDataSource ds = DataSourceFactory.getGZippedDataSource((byte[])ZipUtils.gzip((String)content), (String)"text/html; charset=utf-8", (String)"gzip");
        DataHandler dh = new DataHandler((DataSource)ds);
        AttachmentPart ap = new AttachmentPart(dh);
        ap.setMimeHeader("Content-Encoding", "gzip");
        return ap;
    }
}

